/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Placeholder documentation for SignalMapSummary
 */
@Generated("software.amazon.awssdk:codegen")
public final class SignalMapSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<SignalMapSummary.Builder, SignalMapSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(SignalMapSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt")
            .getter(getter(SignalMapSummary::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(SignalMapSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(SignalMapSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("ModifiedAt")
            .getter(getter(SignalMapSummary::modifiedAt))
            .setter(setter(Builder::modifiedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> MONITOR_DEPLOYMENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MonitorDeploymentStatus").getter(getter(SignalMapSummary::monitorDeploymentStatusAsString))
            .setter(setter(Builder::monitorDeploymentStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("monitorDeploymentStatus").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(SignalMapSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(SignalMapSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(SignalMapSummary::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ARN_FIELD, CREATED_AT_FIELD, DESCRIPTION_FIELD, ID_FIELD, MODIFIED_AT_FIELD, MONITOR_DEPLOYMENT_STATUS_FIELD,
                    NAME_FIELD, STATUS_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final Instant createdAt;

    private final String description;

    private final String id;

    private final Instant modifiedAt;

    private final String monitorDeploymentStatus;

    private final String name;

    private final String status;

    private final Map<String, String> tags;

    private SignalMapSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.id = builder.id;
        this.modifiedAt = builder.modifiedAt;
        this.monitorDeploymentStatus = builder.monitorDeploymentStatus;
        this.name = builder.name;
        this.status = builder.status;
        this.tags = builder.tags;
    }

    /**
     * A signal map's ARN (Amazon Resource Name)
     * 
     * @return A signal map's ARN (Amazon Resource Name)
     */
    public final String arn() {
        return arn;
    }

    /**
     * Returns the value of the CreatedAt property for this object.
     * 
     * @return The value of the CreatedAt property for this object.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * A resource's optional description.
     * 
     * @return A resource's optional description.
     */
    public final String description() {
        return description;
    }

    /**
     * A signal map's id.
     * 
     * @return A signal map's id.
     */
    public final String id() {
        return id;
    }

    /**
     * Returns the value of the ModifiedAt property for this object.
     * 
     * @return The value of the ModifiedAt property for this object.
     */
    public final Instant modifiedAt() {
        return modifiedAt;
    }

    /**
     * Returns the value of the MonitorDeploymentStatus property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #monitorDeploymentStatus} will return {@link SignalMapMonitorDeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #monitorDeploymentStatusAsString}.
     * </p>
     * 
     * @return The value of the MonitorDeploymentStatus property for this object.
     * @see SignalMapMonitorDeploymentStatus
     */
    public final SignalMapMonitorDeploymentStatus monitorDeploymentStatus() {
        return SignalMapMonitorDeploymentStatus.fromValue(monitorDeploymentStatus);
    }

    /**
     * Returns the value of the MonitorDeploymentStatus property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #monitorDeploymentStatus} will return {@link SignalMapMonitorDeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #monitorDeploymentStatusAsString}.
     * </p>
     * 
     * @return The value of the MonitorDeploymentStatus property for this object.
     * @see SignalMapMonitorDeploymentStatus
     */
    public final String monitorDeploymentStatusAsString() {
        return monitorDeploymentStatus;
    }

    /**
     * A resource's name. Names must be unique within the scope of a resource type in a specific region.
     * 
     * @return A resource's name. Names must be unique within the scope of a resource type in a specific region.
     */
    public final String name() {
        return name;
    }

    /**
     * Returns the value of the Status property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SignalMapStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The value of the Status property for this object.
     * @see SignalMapStatus
     */
    public final SignalMapStatus status() {
        return SignalMapStatus.fromValue(status);
    }

    /**
     * Returns the value of the Status property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SignalMapStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The value of the Status property for this object.
     * @see SignalMapStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * Returns the value of the Tags property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The value of the Tags property for this object.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(modifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(monitorDeploymentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SignalMapSummary)) {
            return false;
        }
        SignalMapSummary other = (SignalMapSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(description(), other.description()) && Objects.equals(id(), other.id())
                && Objects.equals(modifiedAt(), other.modifiedAt())
                && Objects.equals(monitorDeploymentStatusAsString(), other.monitorDeploymentStatusAsString())
                && Objects.equals(name(), other.name()) && Objects.equals(statusAsString(), other.statusAsString())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SignalMapSummary").add("Arn", arn()).add("CreatedAt", createdAt())
                .add("Description", description()).add("Id", id()).add("ModifiedAt", modifiedAt())
                .add("MonitorDeploymentStatus", monitorDeploymentStatusAsString()).add("Name", name())
                .add("Status", statusAsString()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "ModifiedAt":
            return Optional.ofNullable(clazz.cast(modifiedAt()));
        case "MonitorDeploymentStatus":
            return Optional.ofNullable(clazz.cast(monitorDeploymentStatusAsString()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("id", ID_FIELD);
        map.put("modifiedAt", MODIFIED_AT_FIELD);
        map.put("monitorDeploymentStatus", MONITOR_DEPLOYMENT_STATUS_FIELD);
        map.put("name", NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SignalMapSummary, T> g) {
        return obj -> g.apply((SignalMapSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SignalMapSummary> {
        /**
         * A signal map's ARN (Amazon Resource Name)
         * 
         * @param arn
         *        A signal map's ARN (Amazon Resource Name)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * Sets the value of the CreatedAt property for this object.
         *
         * @param createdAt
         *        The new value for the CreatedAt property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * A resource's optional description.
         * 
         * @param description
         *        A resource's optional description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * A signal map's id.
         * 
         * @param id
         *        A signal map's id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * Sets the value of the ModifiedAt property for this object.
         *
         * @param modifiedAt
         *        The new value for the ModifiedAt property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifiedAt(Instant modifiedAt);

        /**
         * Sets the value of the MonitorDeploymentStatus property for this object.
         *
         * @param monitorDeploymentStatus
         *        The new value for the MonitorDeploymentStatus property for this object.
         * @see SignalMapMonitorDeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SignalMapMonitorDeploymentStatus
         */
        Builder monitorDeploymentStatus(String monitorDeploymentStatus);

        /**
         * Sets the value of the MonitorDeploymentStatus property for this object.
         *
         * @param monitorDeploymentStatus
         *        The new value for the MonitorDeploymentStatus property for this object.
         * @see SignalMapMonitorDeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SignalMapMonitorDeploymentStatus
         */
        Builder monitorDeploymentStatus(SignalMapMonitorDeploymentStatus monitorDeploymentStatus);

        /**
         * A resource's name. Names must be unique within the scope of a resource type in a specific region.
         * 
         * @param name
         *        A resource's name. Names must be unique within the scope of a resource type in a specific region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Sets the value of the Status property for this object.
         *
         * @param status
         *        The new value for the Status property for this object.
         * @see SignalMapStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SignalMapStatus
         */
        Builder status(String status);

        /**
         * Sets the value of the Status property for this object.
         *
         * @param status
         *        The new value for the Status property for this object.
         * @see SignalMapStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SignalMapStatus
         */
        Builder status(SignalMapStatus status);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private Instant createdAt;

        private String description;

        private String id;

        private Instant modifiedAt;

        private String monitorDeploymentStatus;

        private String name;

        private String status;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SignalMapSummary model) {
            arn(model.arn);
            createdAt(model.createdAt);
            description(model.description);
            id(model.id);
            modifiedAt(model.modifiedAt);
            monitorDeploymentStatus(model.monitorDeploymentStatus);
            name(model.name);
            status(model.status);
            tags(model.tags);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getModifiedAt() {
            return modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final String getMonitorDeploymentStatus() {
            return monitorDeploymentStatus;
        }

        public final void setMonitorDeploymentStatus(String monitorDeploymentStatus) {
            this.monitorDeploymentStatus = monitorDeploymentStatus;
        }

        @Override
        public final Builder monitorDeploymentStatus(String monitorDeploymentStatus) {
            this.monitorDeploymentStatus = monitorDeploymentStatus;
            return this;
        }

        @Override
        public final Builder monitorDeploymentStatus(SignalMapMonitorDeploymentStatus monitorDeploymentStatus) {
            this.monitorDeploymentStatus(monitorDeploymentStatus == null ? null : monitorDeploymentStatus.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SignalMapStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public SignalMapSummary build() {
            return new SignalMapSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
