/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Configures the sources for this SRT input. For a single-pipeline input, include one srtCallerSource in the array. For
 * a standard-pipeline input, include two srtCallerSource.
 */
@Generated("software.amazon.awssdk:codegen")
public final class SrtSettingsRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<SrtSettingsRequest.Builder, SrtSettingsRequest> {
    private static final SdkField<List<SrtCallerSourceRequest>> SRT_CALLER_SOURCES_FIELD = SdkField
            .<List<SrtCallerSourceRequest>> builder(MarshallingType.LIST)
            .memberName("SrtCallerSources")
            .getter(getter(SrtSettingsRequest::srtCallerSources))
            .setter(setter(Builder::srtCallerSources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("srtCallerSources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SrtCallerSourceRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(SrtCallerSourceRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SRT_CALLER_SOURCES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<SrtCallerSourceRequest> srtCallerSources;

    private SrtSettingsRequest(BuilderImpl builder) {
        this.srtCallerSources = builder.srtCallerSources;
    }

    /**
     * For responses, this returns true if the service returned a value for the SrtCallerSources property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSrtCallerSources() {
        return srtCallerSources != null && !(srtCallerSources instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the SrtCallerSources property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSrtCallerSources} method.
     * </p>
     * 
     * @return The value of the SrtCallerSources property for this object.
     */
    public final List<SrtCallerSourceRequest> srtCallerSources() {
        return srtCallerSources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSrtCallerSources() ? srtCallerSources() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SrtSettingsRequest)) {
            return false;
        }
        SrtSettingsRequest other = (SrtSettingsRequest) obj;
        return hasSrtCallerSources() == other.hasSrtCallerSources()
                && Objects.equals(srtCallerSources(), other.srtCallerSources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SrtSettingsRequest").add("SrtCallerSources", hasSrtCallerSources() ? srtCallerSources() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SrtCallerSources":
            return Optional.ofNullable(clazz.cast(srtCallerSources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("srtCallerSources", SRT_CALLER_SOURCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SrtSettingsRequest, T> g) {
        return obj -> g.apply((SrtSettingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SrtSettingsRequest> {
        /**
         * Sets the value of the SrtCallerSources property for this object.
         *
         * @param srtCallerSources
         *        The new value for the SrtCallerSources property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder srtCallerSources(Collection<SrtCallerSourceRequest> srtCallerSources);

        /**
         * Sets the value of the SrtCallerSources property for this object.
         *
         * @param srtCallerSources
         *        The new value for the SrtCallerSources property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder srtCallerSources(SrtCallerSourceRequest... srtCallerSources);

        /**
         * Sets the value of the SrtCallerSources property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.medialive.model.SrtCallerSourceRequest.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.medialive.model.SrtCallerSourceRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.medialive.model.SrtCallerSourceRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #srtCallerSources(List<SrtCallerSourceRequest>)}.
         * 
         * @param srtCallerSources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.medialive.model.SrtCallerSourceRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #srtCallerSources(java.util.Collection<SrtCallerSourceRequest>)
         */
        Builder srtCallerSources(Consumer<SrtCallerSourceRequest.Builder>... srtCallerSources);
    }

    static final class BuilderImpl implements Builder {
        private List<SrtCallerSourceRequest> srtCallerSources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SrtSettingsRequest model) {
            srtCallerSources(model.srtCallerSources);
        }

        public final List<SrtCallerSourceRequest.Builder> getSrtCallerSources() {
            List<SrtCallerSourceRequest.Builder> result = ___listOfSrtCallerSourceRequestCopier
                    .copyToBuilder(this.srtCallerSources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSrtCallerSources(Collection<SrtCallerSourceRequest.BuilderImpl> srtCallerSources) {
            this.srtCallerSources = ___listOfSrtCallerSourceRequestCopier.copyFromBuilder(srtCallerSources);
        }

        @Override
        public final Builder srtCallerSources(Collection<SrtCallerSourceRequest> srtCallerSources) {
            this.srtCallerSources = ___listOfSrtCallerSourceRequestCopier.copy(srtCallerSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder srtCallerSources(SrtCallerSourceRequest... srtCallerSources) {
            srtCallerSources(Arrays.asList(srtCallerSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder srtCallerSources(Consumer<SrtCallerSourceRequest.Builder>... srtCallerSources) {
            srtCallerSources(Stream.of(srtCallerSources).map(c -> SrtCallerSourceRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public SrtSettingsRequest build() {
            return new SrtSettingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
