/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * List of account configuration parameters to update.
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAccountConfigurationRequest extends MediaLiveRequest implements
        ToCopyableBuilder<UpdateAccountConfigurationRequest.Builder, UpdateAccountConfigurationRequest> {
    private static final SdkField<AccountConfiguration> ACCOUNT_CONFIGURATION_FIELD = SdkField
            .<AccountConfiguration> builder(MarshallingType.SDK_POJO).memberName("AccountConfiguration")
            .getter(getter(UpdateAccountConfigurationRequest::accountConfiguration))
            .setter(setter(Builder::accountConfiguration)).constructor(AccountConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final AccountConfiguration accountConfiguration;

    private UpdateAccountConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.accountConfiguration = builder.accountConfiguration;
    }

    /**
     * Returns the value of the AccountConfiguration property for this object.
     * 
     * @return The value of the AccountConfiguration property for this object.
     */
    public final AccountConfiguration accountConfiguration() {
        return accountConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAccountConfigurationRequest)) {
            return false;
        }
        UpdateAccountConfigurationRequest other = (UpdateAccountConfigurationRequest) obj;
        return Objects.equals(accountConfiguration(), other.accountConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAccountConfigurationRequest").add("AccountConfiguration", accountConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountConfiguration":
            return Optional.ofNullable(clazz.cast(accountConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accountConfiguration", ACCOUNT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAccountConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateAccountConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateAccountConfigurationRequest> {
        /**
         * Sets the value of the AccountConfiguration property for this object.
         *
         * @param accountConfiguration
         *        The new value for the AccountConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountConfiguration(AccountConfiguration accountConfiguration);

        /**
         * Sets the value of the AccountConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link AccountConfiguration.Builder} avoiding
         * the need to create one manually via {@link AccountConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AccountConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #accountConfiguration(AccountConfiguration)}.
         * 
         * @param accountConfiguration
         *        a consumer that will call methods on {@link AccountConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountConfiguration(AccountConfiguration)
         */
        default Builder accountConfiguration(Consumer<AccountConfiguration.Builder> accountConfiguration) {
            return accountConfiguration(AccountConfiguration.builder().applyMutation(accountConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaLiveRequest.BuilderImpl implements Builder {
        private AccountConfiguration accountConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAccountConfigurationRequest model) {
            super(model);
            accountConfiguration(model.accountConfiguration);
        }

        public final AccountConfiguration.Builder getAccountConfiguration() {
            return accountConfiguration != null ? accountConfiguration.toBuilder() : null;
        }

        public final void setAccountConfiguration(AccountConfiguration.BuilderImpl accountConfiguration) {
            this.accountConfiguration = accountConfiguration != null ? accountConfiguration.build() : null;
        }

        @Override
        public final Builder accountConfiguration(AccountConfiguration accountConfiguration) {
            this.accountConfiguration = accountConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAccountConfigurationRequest build() {
            return new UpdateAccountConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
