/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A request to update an input device.
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateInputDeviceRequest extends MediaLiveRequest implements
        ToCopyableBuilder<UpdateInputDeviceRequest.Builder, UpdateInputDeviceRequest> {
    private static final SdkField<InputDeviceConfigurableSettings> HD_DEVICE_SETTINGS_FIELD = SdkField
            .<InputDeviceConfigurableSettings> builder(MarshallingType.SDK_POJO).memberName("HdDeviceSettings")
            .getter(getter(UpdateInputDeviceRequest::hdDeviceSettings)).setter(setter(Builder::hdDeviceSettings))
            .constructor(InputDeviceConfigurableSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hdDeviceSettings").build()).build();

    private static final SdkField<String> INPUT_DEVICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputDeviceId").getter(getter(UpdateInputDeviceRequest::inputDeviceId))
            .setter(setter(Builder::inputDeviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("inputDeviceId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateInputDeviceRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<InputDeviceConfigurableSettings> UHD_DEVICE_SETTINGS_FIELD = SdkField
            .<InputDeviceConfigurableSettings> builder(MarshallingType.SDK_POJO).memberName("UhdDeviceSettings")
            .getter(getter(UpdateInputDeviceRequest::uhdDeviceSettings)).setter(setter(Builder::uhdDeviceSettings))
            .constructor(InputDeviceConfigurableSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uhdDeviceSettings").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone").getter(getter(UpdateInputDeviceRequest::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HD_DEVICE_SETTINGS_FIELD,
            INPUT_DEVICE_ID_FIELD, NAME_FIELD, UHD_DEVICE_SETTINGS_FIELD, AVAILABILITY_ZONE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final InputDeviceConfigurableSettings hdDeviceSettings;

    private final String inputDeviceId;

    private final String name;

    private final InputDeviceConfigurableSettings uhdDeviceSettings;

    private final String availabilityZone;

    private UpdateInputDeviceRequest(BuilderImpl builder) {
        super(builder);
        this.hdDeviceSettings = builder.hdDeviceSettings;
        this.inputDeviceId = builder.inputDeviceId;
        this.name = builder.name;
        this.uhdDeviceSettings = builder.uhdDeviceSettings;
        this.availabilityZone = builder.availabilityZone;
    }

    /**
     * The settings that you want to apply to the HD input device.
     * 
     * @return The settings that you want to apply to the HD input device.
     */
    public final InputDeviceConfigurableSettings hdDeviceSettings() {
        return hdDeviceSettings;
    }

    /**
     * The unique ID of the input device. For example, hd-123456789abcdef.
     * 
     * @return The unique ID of the input device. For example, hd-123456789abcdef.
     */
    public final String inputDeviceId() {
        return inputDeviceId;
    }

    /**
     * The name that you assigned to this input device (not the unique ID).
     * 
     * @return The name that you assigned to this input device (not the unique ID).
     */
    public final String name() {
        return name;
    }

    /**
     * The settings that you want to apply to the UHD input device.
     * 
     * @return The settings that you want to apply to the UHD input device.
     */
    public final InputDeviceConfigurableSettings uhdDeviceSettings() {
        return uhdDeviceSettings;
    }

    /**
     * The Availability Zone you want associated with this input device.
     * 
     * @return The Availability Zone you want associated with this input device.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hdDeviceSettings());
        hashCode = 31 * hashCode + Objects.hashCode(inputDeviceId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(uhdDeviceSettings());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateInputDeviceRequest)) {
            return false;
        }
        UpdateInputDeviceRequest other = (UpdateInputDeviceRequest) obj;
        return Objects.equals(hdDeviceSettings(), other.hdDeviceSettings())
                && Objects.equals(inputDeviceId(), other.inputDeviceId()) && Objects.equals(name(), other.name())
                && Objects.equals(uhdDeviceSettings(), other.uhdDeviceSettings())
                && Objects.equals(availabilityZone(), other.availabilityZone());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateInputDeviceRequest").add("HdDeviceSettings", hdDeviceSettings())
                .add("InputDeviceId", inputDeviceId()).add("Name", name()).add("UhdDeviceSettings", uhdDeviceSettings())
                .add("AvailabilityZone", availabilityZone()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HdDeviceSettings":
            return Optional.ofNullable(clazz.cast(hdDeviceSettings()));
        case "InputDeviceId":
            return Optional.ofNullable(clazz.cast(inputDeviceId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "UhdDeviceSettings":
            return Optional.ofNullable(clazz.cast(uhdDeviceSettings()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("hdDeviceSettings", HD_DEVICE_SETTINGS_FIELD);
        map.put("inputDeviceId", INPUT_DEVICE_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("uhdDeviceSettings", UHD_DEVICE_SETTINGS_FIELD);
        map.put("availabilityZone", AVAILABILITY_ZONE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateInputDeviceRequest, T> g) {
        return obj -> g.apply((UpdateInputDeviceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateInputDeviceRequest> {
        /**
         * The settings that you want to apply to the HD input device.
         * 
         * @param hdDeviceSettings
         *        The settings that you want to apply to the HD input device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hdDeviceSettings(InputDeviceConfigurableSettings hdDeviceSettings);

        /**
         * The settings that you want to apply to the HD input device. This is a convenience method that creates an
         * instance of the {@link InputDeviceConfigurableSettings.Builder} avoiding the need to create one manually via
         * {@link InputDeviceConfigurableSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InputDeviceConfigurableSettings.Builder#build()} is called
         * immediately and its result is passed to {@link #hdDeviceSettings(InputDeviceConfigurableSettings)}.
         * 
         * @param hdDeviceSettings
         *        a consumer that will call methods on {@link InputDeviceConfigurableSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hdDeviceSettings(InputDeviceConfigurableSettings)
         */
        default Builder hdDeviceSettings(Consumer<InputDeviceConfigurableSettings.Builder> hdDeviceSettings) {
            return hdDeviceSettings(InputDeviceConfigurableSettings.builder().applyMutation(hdDeviceSettings).build());
        }

        /**
         * The unique ID of the input device. For example, hd-123456789abcdef.
         * 
         * @param inputDeviceId
         *        The unique ID of the input device. For example, hd-123456789abcdef.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDeviceId(String inputDeviceId);

        /**
         * The name that you assigned to this input device (not the unique ID).
         * 
         * @param name
         *        The name that you assigned to this input device (not the unique ID).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * The settings that you want to apply to the UHD input device.
         * 
         * @param uhdDeviceSettings
         *        The settings that you want to apply to the UHD input device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uhdDeviceSettings(InputDeviceConfigurableSettings uhdDeviceSettings);

        /**
         * The settings that you want to apply to the UHD input device. This is a convenience method that creates an
         * instance of the {@link InputDeviceConfigurableSettings.Builder} avoiding the need to create one manually via
         * {@link InputDeviceConfigurableSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InputDeviceConfigurableSettings.Builder#build()} is called
         * immediately and its result is passed to {@link #uhdDeviceSettings(InputDeviceConfigurableSettings)}.
         * 
         * @param uhdDeviceSettings
         *        a consumer that will call methods on {@link InputDeviceConfigurableSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #uhdDeviceSettings(InputDeviceConfigurableSettings)
         */
        default Builder uhdDeviceSettings(Consumer<InputDeviceConfigurableSettings.Builder> uhdDeviceSettings) {
            return uhdDeviceSettings(InputDeviceConfigurableSettings.builder().applyMutation(uhdDeviceSettings).build());
        }

        /**
         * The Availability Zone you want associated with this input device.
         * 
         * @param availabilityZone
         *        The Availability Zone you want associated with this input device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaLiveRequest.BuilderImpl implements Builder {
        private InputDeviceConfigurableSettings hdDeviceSettings;

        private String inputDeviceId;

        private String name;

        private InputDeviceConfigurableSettings uhdDeviceSettings;

        private String availabilityZone;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateInputDeviceRequest model) {
            super(model);
            hdDeviceSettings(model.hdDeviceSettings);
            inputDeviceId(model.inputDeviceId);
            name(model.name);
            uhdDeviceSettings(model.uhdDeviceSettings);
            availabilityZone(model.availabilityZone);
        }

        public final InputDeviceConfigurableSettings.Builder getHdDeviceSettings() {
            return hdDeviceSettings != null ? hdDeviceSettings.toBuilder() : null;
        }

        public final void setHdDeviceSettings(InputDeviceConfigurableSettings.BuilderImpl hdDeviceSettings) {
            this.hdDeviceSettings = hdDeviceSettings != null ? hdDeviceSettings.build() : null;
        }

        @Override
        public final Builder hdDeviceSettings(InputDeviceConfigurableSettings hdDeviceSettings) {
            this.hdDeviceSettings = hdDeviceSettings;
            return this;
        }

        public final String getInputDeviceId() {
            return inputDeviceId;
        }

        public final void setInputDeviceId(String inputDeviceId) {
            this.inputDeviceId = inputDeviceId;
        }

        @Override
        public final Builder inputDeviceId(String inputDeviceId) {
            this.inputDeviceId = inputDeviceId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final InputDeviceConfigurableSettings.Builder getUhdDeviceSettings() {
            return uhdDeviceSettings != null ? uhdDeviceSettings.toBuilder() : null;
        }

        public final void setUhdDeviceSettings(InputDeviceConfigurableSettings.BuilderImpl uhdDeviceSettings) {
            this.uhdDeviceSettings = uhdDeviceSettings != null ? uhdDeviceSettings.build() : null;
        }

        @Override
        public final Builder uhdDeviceSettings(InputDeviceConfigurableSettings uhdDeviceSettings) {
            this.uhdDeviceSettings = uhdDeviceSettings;
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateInputDeviceRequest build() {
            return new UpdateInputDeviceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
