/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagev2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mediapackagev2.model.Destination;
import software.amazon.awssdk.services.mediapackagev2.model.HarvestJobStatus;
import software.amazon.awssdk.services.mediapackagev2.model.HarvestedManifests;
import software.amazon.awssdk.services.mediapackagev2.model.HarvesterScheduleConfiguration;
import software.amazon.awssdk.services.mediapackagev2.model.MediaPackageV2Response;
import software.amazon.awssdk.services.mediapackagev2.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetHarvestJobResponse
extends MediaPackageV2Response
implements ToCopyableBuilder<Builder, GetHarvestJobResponse> {
    private static final SdkField<String> CHANNEL_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelGroupName").getter(GetHarvestJobResponse.getter(GetHarvestJobResponse::channelGroupName)).setter(GetHarvestJobResponse.setter(Builder::channelGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelGroupName").build()}).build();
    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelName").getter(GetHarvestJobResponse.getter(GetHarvestJobResponse::channelName)).setter(GetHarvestJobResponse.setter(Builder::channelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelName").build()}).build();
    private static final SdkField<String> ORIGIN_ENDPOINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OriginEndpointName").getter(GetHarvestJobResponse.getter(GetHarvestJobResponse::originEndpointName)).setter(GetHarvestJobResponse.setter(Builder::originEndpointName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginEndpointName").build()}).build();
    private static final SdkField<Destination> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Destination").getter(GetHarvestJobResponse.getter(GetHarvestJobResponse::destination)).setter(GetHarvestJobResponse.setter(Builder::destination)).constructor(Destination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()}).build();
    private static final SdkField<String> HARVEST_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HarvestJobName").getter(GetHarvestJobResponse.getter(GetHarvestJobResponse::harvestJobName)).setter(GetHarvestJobResponse.setter(Builder::harvestJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HarvestJobName").build()}).build();
    private static final SdkField<HarvestedManifests> HARVESTED_MANIFESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HarvestedManifests").getter(GetHarvestJobResponse.getter(GetHarvestJobResponse::harvestedManifests)).setter(GetHarvestJobResponse.setter(Builder::harvestedManifests)).constructor(HarvestedManifests::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HarvestedManifests").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(GetHarvestJobResponse.getter(GetHarvestJobResponse::description)).setter(GetHarvestJobResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<HarvesterScheduleConfiguration> SCHEDULE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ScheduleConfiguration").getter(GetHarvestJobResponse.getter(GetHarvestJobResponse::scheduleConfiguration)).setter(GetHarvestJobResponse.setter(Builder::scheduleConfiguration)).constructor(HarvesterScheduleConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleConfiguration").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(GetHarvestJobResponse.getter(GetHarvestJobResponse::arn)).setter(GetHarvestJobResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(GetHarvestJobResponse.getter(GetHarvestJobResponse::createdAt)).setter(GetHarvestJobResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ModifiedAt").getter(GetHarvestJobResponse.getter(GetHarvestJobResponse::modifiedAt)).setter(GetHarvestJobResponse.setter(Builder::modifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifiedAt").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetHarvestJobResponse.getter(GetHarvestJobResponse::statusAsString)).setter(GetHarvestJobResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorMessage").getter(GetHarvestJobResponse.getter(GetHarvestJobResponse::errorMessage)).setter(GetHarvestJobResponse.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()}).build();
    private static final SdkField<String> E_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ETag").getter(GetHarvestJobResponse.getter(GetHarvestJobResponse::eTag)).setter(GetHarvestJobResponse.setter(Builder::eTag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ETag").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(GetHarvestJobResponse.getter(GetHarvestJobResponse::tags)).setter(GetHarvestJobResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_GROUP_NAME_FIELD, CHANNEL_NAME_FIELD, ORIGIN_ENDPOINT_NAME_FIELD, DESTINATION_FIELD, HARVEST_JOB_NAME_FIELD, HARVESTED_MANIFESTS_FIELD, DESCRIPTION_FIELD, SCHEDULE_CONFIGURATION_FIELD, ARN_FIELD, CREATED_AT_FIELD, MODIFIED_AT_FIELD, STATUS_FIELD, ERROR_MESSAGE_FIELD, E_TAG_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ChannelGroupName", CHANNEL_GROUP_NAME_FIELD);
            this.put("ChannelName", CHANNEL_NAME_FIELD);
            this.put("OriginEndpointName", ORIGIN_ENDPOINT_NAME_FIELD);
            this.put("Destination", DESTINATION_FIELD);
            this.put("HarvestJobName", HARVEST_JOB_NAME_FIELD);
            this.put("HarvestedManifests", HARVESTED_MANIFESTS_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("ScheduleConfiguration", SCHEDULE_CONFIGURATION_FIELD);
            this.put("Arn", ARN_FIELD);
            this.put("CreatedAt", CREATED_AT_FIELD);
            this.put("ModifiedAt", MODIFIED_AT_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("ErrorMessage", ERROR_MESSAGE_FIELD);
            this.put("ETag", E_TAG_FIELD);
            this.put("Tags", TAGS_FIELD);
        }
    });
    private final String channelGroupName;
    private final String channelName;
    private final String originEndpointName;
    private final Destination destination;
    private final String harvestJobName;
    private final HarvestedManifests harvestedManifests;
    private final String description;
    private final HarvesterScheduleConfiguration scheduleConfiguration;
    private final String arn;
    private final Instant createdAt;
    private final Instant modifiedAt;
    private final String status;
    private final String errorMessage;
    private final String eTag;
    private final Map<String, String> tags;

    private GetHarvestJobResponse(BuilderImpl builder) {
        super(builder);
        this.channelGroupName = builder.channelGroupName;
        this.channelName = builder.channelName;
        this.originEndpointName = builder.originEndpointName;
        this.destination = builder.destination;
        this.harvestJobName = builder.harvestJobName;
        this.harvestedManifests = builder.harvestedManifests;
        this.description = builder.description;
        this.scheduleConfiguration = builder.scheduleConfiguration;
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
        this.status = builder.status;
        this.errorMessage = builder.errorMessage;
        this.eTag = builder.eTag;
        this.tags = builder.tags;
    }

    public final String channelGroupName() {
        return this.channelGroupName;
    }

    public final String channelName() {
        return this.channelName;
    }

    public final String originEndpointName() {
        return this.originEndpointName;
    }

    public final Destination destination() {
        return this.destination;
    }

    public final String harvestJobName() {
        return this.harvestJobName;
    }

    public final HarvestedManifests harvestedManifests() {
        return this.harvestedManifests;
    }

    public final String description() {
        return this.description;
    }

    public final HarvesterScheduleConfiguration scheduleConfiguration() {
        return this.scheduleConfiguration;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant modifiedAt() {
        return this.modifiedAt;
    }

    public final HarvestJobStatus status() {
        return HarvestJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final String eTag() {
        return this.eTag;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.channelGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.originEndpointName());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.harvestJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.harvestedManifests());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.eTag());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetHarvestJobResponse)) {
            return false;
        }
        GetHarvestJobResponse other = (GetHarvestJobResponse)((Object)obj);
        return Objects.equals(this.channelGroupName(), other.channelGroupName()) && Objects.equals(this.channelName(), other.channelName()) && Objects.equals(this.originEndpointName(), other.originEndpointName()) && Objects.equals(this.destination(), other.destination()) && Objects.equals(this.harvestJobName(), other.harvestJobName()) && Objects.equals(this.harvestedManifests(), other.harvestedManifests()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.scheduleConfiguration(), other.scheduleConfiguration()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.modifiedAt(), other.modifiedAt()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.eTag(), other.eTag()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"GetHarvestJobResponse").add("ChannelGroupName", (Object)this.channelGroupName()).add("ChannelName", (Object)this.channelName()).add("OriginEndpointName", (Object)this.originEndpointName()).add("Destination", (Object)this.destination()).add("HarvestJobName", (Object)this.harvestJobName()).add("HarvestedManifests", (Object)this.harvestedManifests()).add("Description", (Object)this.description()).add("ScheduleConfiguration", (Object)this.scheduleConfiguration()).add("Arn", (Object)this.arn()).add("CreatedAt", (Object)this.createdAt()).add("ModifiedAt", (Object)this.modifiedAt()).add("Status", (Object)this.statusAsString()).add("ErrorMessage", (Object)this.errorMessage()).add("ETag", (Object)this.eTag()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelGroupName": {
                return Optional.ofNullable(clazz.cast(this.channelGroupName()));
            }
            case "ChannelName": {
                return Optional.ofNullable(clazz.cast(this.channelName()));
            }
            case "OriginEndpointName": {
                return Optional.ofNullable(clazz.cast(this.originEndpointName()));
            }
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "HarvestJobName": {
                return Optional.ofNullable(clazz.cast(this.harvestJobName()));
            }
            case "HarvestedManifests": {
                return Optional.ofNullable(clazz.cast(this.harvestedManifests()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ScheduleConfiguration": {
                return Optional.ofNullable(clazz.cast(this.scheduleConfiguration()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "ModifiedAt": {
                return Optional.ofNullable(clazz.cast(this.modifiedAt()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "ETag": {
                return Optional.ofNullable(clazz.cast(this.eTag()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetHarvestJobResponse, T> g) {
        return obj -> g.apply((GetHarvestJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaPackageV2Response.BuilderImpl
    implements Builder {
        private String channelGroupName;
        private String channelName;
        private String originEndpointName;
        private Destination destination;
        private String harvestJobName;
        private HarvestedManifests harvestedManifests;
        private String description;
        private HarvesterScheduleConfiguration scheduleConfiguration;
        private String arn;
        private Instant createdAt;
        private Instant modifiedAt;
        private String status;
        private String errorMessage;
        private String eTag;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetHarvestJobResponse model) {
            super(model);
            this.channelGroupName(model.channelGroupName);
            this.channelName(model.channelName);
            this.originEndpointName(model.originEndpointName);
            this.destination(model.destination);
            this.harvestJobName(model.harvestJobName);
            this.harvestedManifests(model.harvestedManifests);
            this.description(model.description);
            this.scheduleConfiguration(model.scheduleConfiguration);
            this.arn(model.arn);
            this.createdAt(model.createdAt);
            this.modifiedAt(model.modifiedAt);
            this.status(model.status);
            this.errorMessage(model.errorMessage);
            this.eTag(model.eTag);
            this.tags(model.tags);
        }

        public final String getChannelGroupName() {
            return this.channelGroupName;
        }

        public final void setChannelGroupName(String channelGroupName) {
            this.channelGroupName = channelGroupName;
        }

        @Override
        public final Builder channelGroupName(String channelGroupName) {
            this.channelGroupName = channelGroupName;
            return this;
        }

        public final String getChannelName() {
            return this.channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final String getOriginEndpointName() {
            return this.originEndpointName;
        }

        public final void setOriginEndpointName(String originEndpointName) {
            this.originEndpointName = originEndpointName;
        }

        @Override
        public final Builder originEndpointName(String originEndpointName) {
            this.originEndpointName = originEndpointName;
            return this;
        }

        public final Destination.Builder getDestination() {
            return this.destination != null ? this.destination.toBuilder() : null;
        }

        public final void setDestination(Destination.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        public final Builder destination(Destination destination) {
            this.destination = destination;
            return this;
        }

        public final String getHarvestJobName() {
            return this.harvestJobName;
        }

        public final void setHarvestJobName(String harvestJobName) {
            this.harvestJobName = harvestJobName;
        }

        @Override
        public final Builder harvestJobName(String harvestJobName) {
            this.harvestJobName = harvestJobName;
            return this;
        }

        public final HarvestedManifests.Builder getHarvestedManifests() {
            return this.harvestedManifests != null ? this.harvestedManifests.toBuilder() : null;
        }

        public final void setHarvestedManifests(HarvestedManifests.BuilderImpl harvestedManifests) {
            this.harvestedManifests = harvestedManifests != null ? harvestedManifests.build() : null;
        }

        @Override
        public final Builder harvestedManifests(HarvestedManifests harvestedManifests) {
            this.harvestedManifests = harvestedManifests;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final HarvesterScheduleConfiguration.Builder getScheduleConfiguration() {
            return this.scheduleConfiguration != null ? this.scheduleConfiguration.toBuilder() : null;
        }

        public final void setScheduleConfiguration(HarvesterScheduleConfiguration.BuilderImpl scheduleConfiguration) {
            this.scheduleConfiguration = scheduleConfiguration != null ? scheduleConfiguration.build() : null;
        }

        @Override
        public final Builder scheduleConfiguration(HarvesterScheduleConfiguration scheduleConfiguration) {
            this.scheduleConfiguration = scheduleConfiguration;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getModifiedAt() {
            return this.modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(HarvestJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getETag() {
            return this.eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetHarvestJobResponse build() {
            return new GetHarvestJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MediaPackageV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetHarvestJobResponse> {
        public Builder channelGroupName(String var1);

        public Builder channelName(String var1);

        public Builder originEndpointName(String var1);

        public Builder destination(Destination var1);

        default public Builder destination(Consumer<Destination.Builder> destination) {
            return this.destination((Destination)((Destination.Builder)Destination.builder().applyMutation(destination)).build());
        }

        public Builder harvestJobName(String var1);

        public Builder harvestedManifests(HarvestedManifests var1);

        default public Builder harvestedManifests(Consumer<HarvestedManifests.Builder> harvestedManifests) {
            return this.harvestedManifests((HarvestedManifests)((HarvestedManifests.Builder)HarvestedManifests.builder().applyMutation(harvestedManifests)).build());
        }

        public Builder description(String var1);

        public Builder scheduleConfiguration(HarvesterScheduleConfiguration var1);

        default public Builder scheduleConfiguration(Consumer<HarvesterScheduleConfiguration.Builder> scheduleConfiguration) {
            return this.scheduleConfiguration((HarvesterScheduleConfiguration)((HarvesterScheduleConfiguration.Builder)HarvesterScheduleConfiguration.builder().applyMutation(scheduleConfiguration)).build());
        }

        public Builder arn(String var1);

        public Builder createdAt(Instant var1);

        public Builder modifiedAt(Instant var1);

        public Builder status(String var1);

        public Builder status(HarvestJobStatus var1);

        public Builder errorMessage(String var1);

        public Builder eTag(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

