/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medicalimaging.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medicalimaging.model.CopyImageSetInformation;
import software.amazon.awssdk.services.medicalimaging.model.MedicalImagingRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CopyImageSetRequest
extends MedicalImagingRequest
implements ToCopyableBuilder<Builder, CopyImageSetRequest> {
    private static final SdkField<String> DATASTORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datastoreId").getter(CopyImageSetRequest.getter(CopyImageSetRequest::datastoreId)).setter(CopyImageSetRequest.setter(Builder::datastoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("datastoreId").build()}).build();
    private static final SdkField<String> SOURCE_IMAGE_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceImageSetId").getter(CopyImageSetRequest.getter(CopyImageSetRequest::sourceImageSetId)).setter(CopyImageSetRequest.setter(Builder::sourceImageSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("sourceImageSetId").build()}).build();
    private static final SdkField<CopyImageSetInformation> COPY_IMAGE_SET_INFORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("copyImageSetInformation").getter(CopyImageSetRequest.getter(CopyImageSetRequest::copyImageSetInformation)).setter(CopyImageSetRequest.setter(Builder::copyImageSetInformation)).constructor(CopyImageSetInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("copyImageSetInformation").build(), PayloadTrait.create()}).build();
    private static final SdkField<Boolean> FORCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("force").getter(CopyImageSetRequest.getter(CopyImageSetRequest::force)).setter(CopyImageSetRequest.setter(Builder::force)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("force").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASTORE_ID_FIELD, SOURCE_IMAGE_SET_ID_FIELD, COPY_IMAGE_SET_INFORMATION_FIELD, FORCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CopyImageSetRequest.memberNameToFieldInitializer();
    private final String datastoreId;
    private final String sourceImageSetId;
    private final CopyImageSetInformation copyImageSetInformation;
    private final Boolean force;

    private CopyImageSetRequest(BuilderImpl builder) {
        super(builder);
        this.datastoreId = builder.datastoreId;
        this.sourceImageSetId = builder.sourceImageSetId;
        this.copyImageSetInformation = builder.copyImageSetInformation;
        this.force = builder.force;
    }

    public final String datastoreId() {
        return this.datastoreId;
    }

    public final String sourceImageSetId() {
        return this.sourceImageSetId;
    }

    public final CopyImageSetInformation copyImageSetInformation() {
        return this.copyImageSetInformation;
    }

    public final Boolean force() {
        return this.force;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.datastoreId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceImageSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyImageSetInformation());
        hashCode = 31 * hashCode + Objects.hashCode(this.force());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyImageSetRequest)) {
            return false;
        }
        CopyImageSetRequest other = (CopyImageSetRequest)((Object)obj);
        return Objects.equals(this.datastoreId(), other.datastoreId()) && Objects.equals(this.sourceImageSetId(), other.sourceImageSetId()) && Objects.equals(this.copyImageSetInformation(), other.copyImageSetInformation()) && Objects.equals(this.force(), other.force());
    }

    public final String toString() {
        return ToString.builder((String)"CopyImageSetRequest").add("DatastoreId", (Object)this.datastoreId()).add("SourceImageSetId", (Object)this.sourceImageSetId()).add("CopyImageSetInformation", (Object)this.copyImageSetInformation()).add("Force", (Object)this.force()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "datastoreId": {
                return Optional.ofNullable(clazz.cast(this.datastoreId()));
            }
            case "sourceImageSetId": {
                return Optional.ofNullable(clazz.cast(this.sourceImageSetId()));
            }
            case "copyImageSetInformation": {
                return Optional.ofNullable(clazz.cast(this.copyImageSetInformation()));
            }
            case "force": {
                return Optional.ofNullable(clazz.cast(this.force()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("datastoreId", DATASTORE_ID_FIELD);
        map.put("sourceImageSetId", SOURCE_IMAGE_SET_ID_FIELD);
        map.put("copyImageSetInformation", COPY_IMAGE_SET_INFORMATION_FIELD);
        map.put("force", FORCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CopyImageSetRequest, T> g) {
        return obj -> g.apply((CopyImageSetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MedicalImagingRequest.BuilderImpl
    implements Builder {
        private String datastoreId;
        private String sourceImageSetId;
        private CopyImageSetInformation copyImageSetInformation;
        private Boolean force;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyImageSetRequest model) {
            super(model);
            this.datastoreId(model.datastoreId);
            this.sourceImageSetId(model.sourceImageSetId);
            this.copyImageSetInformation(model.copyImageSetInformation);
            this.force(model.force);
        }

        public final String getDatastoreId() {
            return this.datastoreId;
        }

        public final void setDatastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
        }

        @Override
        public final Builder datastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
            return this;
        }

        public final String getSourceImageSetId() {
            return this.sourceImageSetId;
        }

        public final void setSourceImageSetId(String sourceImageSetId) {
            this.sourceImageSetId = sourceImageSetId;
        }

        @Override
        public final Builder sourceImageSetId(String sourceImageSetId) {
            this.sourceImageSetId = sourceImageSetId;
            return this;
        }

        public final CopyImageSetInformation.Builder getCopyImageSetInformation() {
            return this.copyImageSetInformation != null ? this.copyImageSetInformation.toBuilder() : null;
        }

        public final void setCopyImageSetInformation(CopyImageSetInformation.BuilderImpl copyImageSetInformation) {
            this.copyImageSetInformation = copyImageSetInformation != null ? copyImageSetInformation.build() : null;
        }

        @Override
        public final Builder copyImageSetInformation(CopyImageSetInformation copyImageSetInformation) {
            this.copyImageSetInformation = copyImageSetInformation;
            return this;
        }

        public final Boolean getForce() {
            return this.force;
        }

        public final void setForce(Boolean force) {
            this.force = force;
        }

        @Override
        public final Builder force(Boolean force) {
            this.force = force;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CopyImageSetRequest build() {
            return new CopyImageSetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MedicalImagingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CopyImageSetRequest> {
        public Builder datastoreId(String var1);

        public Builder sourceImageSetId(String var1);

        public Builder copyImageSetInformation(CopyImageSetInformation var1);

        default public Builder copyImageSetInformation(Consumer<CopyImageSetInformation.Builder> copyImageSetInformation) {
            return this.copyImageSetInformation((CopyImageSetInformation)((CopyImageSetInformation.Builder)CopyImageSetInformation.builder().applyMutation(copyImageSetInformation)).build());
        }

        public Builder force(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

