/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medicalimaging.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Copy the destination image set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CopyDestinationImageSet implements SdkPojo, Serializable,
        ToCopyableBuilder<CopyDestinationImageSet.Builder, CopyDestinationImageSet> {
    private static final SdkField<String> IMAGE_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imageSetId").getter(getter(CopyDestinationImageSet::imageSetId)).setter(setter(Builder::imageSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageSetId").build()).build();

    private static final SdkField<String> LATEST_VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("latestVersionId").getter(getter(CopyDestinationImageSet::latestVersionId))
            .setter(setter(Builder::latestVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestVersionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_SET_ID_FIELD,
            LATEST_VERSION_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String imageSetId;

    private final String latestVersionId;

    private CopyDestinationImageSet(BuilderImpl builder) {
        this.imageSetId = builder.imageSetId;
        this.latestVersionId = builder.latestVersionId;
    }

    /**
     * <p>
     * The image set identifier for the destination image set.
     * </p>
     * 
     * @return The image set identifier for the destination image set.
     */
    public final String imageSetId() {
        return imageSetId;
    }

    /**
     * <p>
     * The latest version identifier for the destination image set.
     * </p>
     * 
     * @return The latest version identifier for the destination image set.
     */
    public final String latestVersionId() {
        return latestVersionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(imageSetId());
        hashCode = 31 * hashCode + Objects.hashCode(latestVersionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyDestinationImageSet)) {
            return false;
        }
        CopyDestinationImageSet other = (CopyDestinationImageSet) obj;
        return Objects.equals(imageSetId(), other.imageSetId()) && Objects.equals(latestVersionId(), other.latestVersionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CopyDestinationImageSet").add("ImageSetId", imageSetId())
                .add("LatestVersionId", latestVersionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "imageSetId":
            return Optional.ofNullable(clazz.cast(imageSetId()));
        case "latestVersionId":
            return Optional.ofNullable(clazz.cast(latestVersionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("imageSetId", IMAGE_SET_ID_FIELD);
        map.put("latestVersionId", LATEST_VERSION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CopyDestinationImageSet, T> g) {
        return obj -> g.apply((CopyDestinationImageSet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CopyDestinationImageSet> {
        /**
         * <p>
         * The image set identifier for the destination image set.
         * </p>
         * 
         * @param imageSetId
         *        The image set identifier for the destination image set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageSetId(String imageSetId);

        /**
         * <p>
         * The latest version identifier for the destination image set.
         * </p>
         * 
         * @param latestVersionId
         *        The latest version identifier for the destination image set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestVersionId(String latestVersionId);
    }

    static final class BuilderImpl implements Builder {
        private String imageSetId;

        private String latestVersionId;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyDestinationImageSet model) {
            imageSetId(model.imageSetId);
            latestVersionId(model.latestVersionId);
        }

        public final String getImageSetId() {
            return imageSetId;
        }

        public final void setImageSetId(String imageSetId) {
            this.imageSetId = imageSetId;
        }

        @Override
        public final Builder imageSetId(String imageSetId) {
            this.imageSetId = imageSetId;
            return this;
        }

        public final String getLatestVersionId() {
            return latestVersionId;
        }

        public final void setLatestVersionId(String latestVersionId) {
            this.latestVersionId = latestVersionId;
        }

        @Override
        public final Builder latestVersionId(String latestVersionId) {
            this.latestVersionId = latestVersionId;
            return this;
        }

        @Override
        public CopyDestinationImageSet build() {
            return new CopyDestinationImageSet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
