/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medicalimaging.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CopyImageSetRequest extends MedicalImagingRequest implements
        ToCopyableBuilder<CopyImageSetRequest.Builder, CopyImageSetRequest> {
    private static final SdkField<String> DATASTORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datastoreId").getter(getter(CopyImageSetRequest::datastoreId)).setter(setter(Builder::datastoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("datastoreId").build()).build();

    private static final SdkField<String> SOURCE_IMAGE_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceImageSetId").getter(getter(CopyImageSetRequest::sourceImageSetId))
            .setter(setter(Builder::sourceImageSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("sourceImageSetId").build()).build();

    private static final SdkField<CopyImageSetInformation> COPY_IMAGE_SET_INFORMATION_FIELD = SdkField
            .<CopyImageSetInformation> builder(MarshallingType.SDK_POJO)
            .memberName("copyImageSetInformation")
            .getter(getter(CopyImageSetRequest::copyImageSetInformation))
            .setter(setter(Builder::copyImageSetInformation))
            .constructor(CopyImageSetInformation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("copyImageSetInformation").build(),
                    PayloadTrait.create()).build();

    private static final SdkField<Boolean> FORCE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN).memberName("force")
            .getter(getter(CopyImageSetRequest::force)).setter(setter(Builder::force))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("force").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASTORE_ID_FIELD,
            SOURCE_IMAGE_SET_ID_FIELD, COPY_IMAGE_SET_INFORMATION_FIELD, FORCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String datastoreId;

    private final String sourceImageSetId;

    private final CopyImageSetInformation copyImageSetInformation;

    private final Boolean force;

    private CopyImageSetRequest(BuilderImpl builder) {
        super(builder);
        this.datastoreId = builder.datastoreId;
        this.sourceImageSetId = builder.sourceImageSetId;
        this.copyImageSetInformation = builder.copyImageSetInformation;
        this.force = builder.force;
    }

    /**
     * <p>
     * The data store identifier.
     * </p>
     * 
     * @return The data store identifier.
     */
    public final String datastoreId() {
        return datastoreId;
    }

    /**
     * <p>
     * The source image set identifier.
     * </p>
     * 
     * @return The source image set identifier.
     */
    public final String sourceImageSetId() {
        return sourceImageSetId;
    }

    /**
     * <p>
     * Copy image set information.
     * </p>
     * 
     * @return Copy image set information.
     */
    public final CopyImageSetInformation copyImageSetInformation() {
        return copyImageSetInformation;
    }

    /**
     * <p>
     * Setting this flag will force the <code>CopyImageSet</code> operation, even if Patient, Study, or Series level
     * metadata are mismatched across the <code>sourceImageSet</code> and <code>destinationImageSet</code>.
     * </p>
     * 
     * @return Setting this flag will force the <code>CopyImageSet</code> operation, even if Patient, Study, or Series
     *         level metadata are mismatched across the <code>sourceImageSet</code> and <code>destinationImageSet</code>
     *         .
     */
    public final Boolean force() {
        return force;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(datastoreId());
        hashCode = 31 * hashCode + Objects.hashCode(sourceImageSetId());
        hashCode = 31 * hashCode + Objects.hashCode(copyImageSetInformation());
        hashCode = 31 * hashCode + Objects.hashCode(force());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyImageSetRequest)) {
            return false;
        }
        CopyImageSetRequest other = (CopyImageSetRequest) obj;
        return Objects.equals(datastoreId(), other.datastoreId()) && Objects.equals(sourceImageSetId(), other.sourceImageSetId())
                && Objects.equals(copyImageSetInformation(), other.copyImageSetInformation())
                && Objects.equals(force(), other.force());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CopyImageSetRequest").add("DatastoreId", datastoreId())
                .add("SourceImageSetId", sourceImageSetId()).add("CopyImageSetInformation", copyImageSetInformation())
                .add("Force", force()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "datastoreId":
            return Optional.ofNullable(clazz.cast(datastoreId()));
        case "sourceImageSetId":
            return Optional.ofNullable(clazz.cast(sourceImageSetId()));
        case "copyImageSetInformation":
            return Optional.ofNullable(clazz.cast(copyImageSetInformation()));
        case "force":
            return Optional.ofNullable(clazz.cast(force()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("datastoreId", DATASTORE_ID_FIELD);
        map.put("sourceImageSetId", SOURCE_IMAGE_SET_ID_FIELD);
        map.put("copyImageSetInformation", COPY_IMAGE_SET_INFORMATION_FIELD);
        map.put("force", FORCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CopyImageSetRequest, T> g) {
        return obj -> g.apply((CopyImageSetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MedicalImagingRequest.Builder, SdkPojo, CopyableBuilder<Builder, CopyImageSetRequest> {
        /**
         * <p>
         * The data store identifier.
         * </p>
         * 
         * @param datastoreId
         *        The data store identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datastoreId(String datastoreId);

        /**
         * <p>
         * The source image set identifier.
         * </p>
         * 
         * @param sourceImageSetId
         *        The source image set identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceImageSetId(String sourceImageSetId);

        /**
         * <p>
         * Copy image set information.
         * </p>
         * 
         * @param copyImageSetInformation
         *        Copy image set information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyImageSetInformation(CopyImageSetInformation copyImageSetInformation);

        /**
         * <p>
         * Copy image set information.
         * </p>
         * This is a convenience method that creates an instance of the {@link CopyImageSetInformation.Builder} avoiding
         * the need to create one manually via {@link CopyImageSetInformation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CopyImageSetInformation.Builder#build()} is called immediately
         * and its result is passed to {@link #copyImageSetInformation(CopyImageSetInformation)}.
         * 
         * @param copyImageSetInformation
         *        a consumer that will call methods on {@link CopyImageSetInformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #copyImageSetInformation(CopyImageSetInformation)
         */
        default Builder copyImageSetInformation(Consumer<CopyImageSetInformation.Builder> copyImageSetInformation) {
            return copyImageSetInformation(CopyImageSetInformation.builder().applyMutation(copyImageSetInformation).build());
        }

        /**
         * <p>
         * Setting this flag will force the <code>CopyImageSet</code> operation, even if Patient, Study, or Series level
         * metadata are mismatched across the <code>sourceImageSet</code> and <code>destinationImageSet</code>.
         * </p>
         * 
         * @param force
         *        Setting this flag will force the <code>CopyImageSet</code> operation, even if Patient, Study, or
         *        Series level metadata are mismatched across the <code>sourceImageSet</code> and
         *        <code>destinationImageSet</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder force(Boolean force);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MedicalImagingRequest.BuilderImpl implements Builder {
        private String datastoreId;

        private String sourceImageSetId;

        private CopyImageSetInformation copyImageSetInformation;

        private Boolean force;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyImageSetRequest model) {
            super(model);
            datastoreId(model.datastoreId);
            sourceImageSetId(model.sourceImageSetId);
            copyImageSetInformation(model.copyImageSetInformation);
            force(model.force);
        }

        public final String getDatastoreId() {
            return datastoreId;
        }

        public final void setDatastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
        }

        @Override
        public final Builder datastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
            return this;
        }

        public final String getSourceImageSetId() {
            return sourceImageSetId;
        }

        public final void setSourceImageSetId(String sourceImageSetId) {
            this.sourceImageSetId = sourceImageSetId;
        }

        @Override
        public final Builder sourceImageSetId(String sourceImageSetId) {
            this.sourceImageSetId = sourceImageSetId;
            return this;
        }

        public final CopyImageSetInformation.Builder getCopyImageSetInformation() {
            return copyImageSetInformation != null ? copyImageSetInformation.toBuilder() : null;
        }

        public final void setCopyImageSetInformation(CopyImageSetInformation.BuilderImpl copyImageSetInformation) {
            this.copyImageSetInformation = copyImageSetInformation != null ? copyImageSetInformation.build() : null;
        }

        @Override
        public final Builder copyImageSetInformation(CopyImageSetInformation copyImageSetInformation) {
            this.copyImageSetInformation = copyImageSetInformation;
            return this;
        }

        public final Boolean getForce() {
            return force;
        }

        public final void setForce(Boolean force) {
            this.force = force;
        }

        @Override
        public final Builder force(Boolean force) {
            this.force = force;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CopyImageSetRequest build() {
            return new CopyImageSetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
