/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medicalimaging.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CopyImageSetResponse extends MedicalImagingResponse implements
        ToCopyableBuilder<CopyImageSetResponse.Builder, CopyImageSetResponse> {
    private static final SdkField<String> DATASTORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datastoreId").getter(getter(CopyImageSetResponse::datastoreId)).setter(setter(Builder::datastoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datastoreId").build()).build();

    private static final SdkField<CopySourceImageSetProperties> SOURCE_IMAGE_SET_PROPERTIES_FIELD = SdkField
            .<CopySourceImageSetProperties> builder(MarshallingType.SDK_POJO).memberName("sourceImageSetProperties")
            .getter(getter(CopyImageSetResponse::sourceImageSetProperties)).setter(setter(Builder::sourceImageSetProperties))
            .constructor(CopySourceImageSetProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceImageSetProperties").build())
            .build();

    private static final SdkField<CopyDestinationImageSetProperties> DESTINATION_IMAGE_SET_PROPERTIES_FIELD = SdkField
            .<CopyDestinationImageSetProperties> builder(MarshallingType.SDK_POJO)
            .memberName("destinationImageSetProperties")
            .getter(getter(CopyImageSetResponse::destinationImageSetProperties))
            .setter(setter(Builder::destinationImageSetProperties))
            .constructor(CopyDestinationImageSetProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationImageSetProperties")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASTORE_ID_FIELD,
            SOURCE_IMAGE_SET_PROPERTIES_FIELD, DESTINATION_IMAGE_SET_PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String datastoreId;

    private final CopySourceImageSetProperties sourceImageSetProperties;

    private final CopyDestinationImageSetProperties destinationImageSetProperties;

    private CopyImageSetResponse(BuilderImpl builder) {
        super(builder);
        this.datastoreId = builder.datastoreId;
        this.sourceImageSetProperties = builder.sourceImageSetProperties;
        this.destinationImageSetProperties = builder.destinationImageSetProperties;
    }

    /**
     * <p>
     * The data store identifier.
     * </p>
     * 
     * @return The data store identifier.
     */
    public final String datastoreId() {
        return datastoreId;
    }

    /**
     * <p>
     * The properties of the source image set.
     * </p>
     * 
     * @return The properties of the source image set.
     */
    public final CopySourceImageSetProperties sourceImageSetProperties() {
        return sourceImageSetProperties;
    }

    /**
     * <p>
     * The properties of the destination image set.
     * </p>
     * 
     * @return The properties of the destination image set.
     */
    public final CopyDestinationImageSetProperties destinationImageSetProperties() {
        return destinationImageSetProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(datastoreId());
        hashCode = 31 * hashCode + Objects.hashCode(sourceImageSetProperties());
        hashCode = 31 * hashCode + Objects.hashCode(destinationImageSetProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyImageSetResponse)) {
            return false;
        }
        CopyImageSetResponse other = (CopyImageSetResponse) obj;
        return Objects.equals(datastoreId(), other.datastoreId())
                && Objects.equals(sourceImageSetProperties(), other.sourceImageSetProperties())
                && Objects.equals(destinationImageSetProperties(), other.destinationImageSetProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CopyImageSetResponse").add("DatastoreId", datastoreId())
                .add("SourceImageSetProperties", sourceImageSetProperties())
                .add("DestinationImageSetProperties", destinationImageSetProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "datastoreId":
            return Optional.ofNullable(clazz.cast(datastoreId()));
        case "sourceImageSetProperties":
            return Optional.ofNullable(clazz.cast(sourceImageSetProperties()));
        case "destinationImageSetProperties":
            return Optional.ofNullable(clazz.cast(destinationImageSetProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("datastoreId", DATASTORE_ID_FIELD);
        map.put("sourceImageSetProperties", SOURCE_IMAGE_SET_PROPERTIES_FIELD);
        map.put("destinationImageSetProperties", DESTINATION_IMAGE_SET_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CopyImageSetResponse, T> g) {
        return obj -> g.apply((CopyImageSetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MedicalImagingResponse.Builder, SdkPojo, CopyableBuilder<Builder, CopyImageSetResponse> {
        /**
         * <p>
         * The data store identifier.
         * </p>
         * 
         * @param datastoreId
         *        The data store identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datastoreId(String datastoreId);

        /**
         * <p>
         * The properties of the source image set.
         * </p>
         * 
         * @param sourceImageSetProperties
         *        The properties of the source image set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceImageSetProperties(CopySourceImageSetProperties sourceImageSetProperties);

        /**
         * <p>
         * The properties of the source image set.
         * </p>
         * This is a convenience method that creates an instance of the {@link CopySourceImageSetProperties.Builder}
         * avoiding the need to create one manually via {@link CopySourceImageSetProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CopySourceImageSetProperties.Builder#build()} is called
         * immediately and its result is passed to {@link #sourceImageSetProperties(CopySourceImageSetProperties)}.
         * 
         * @param sourceImageSetProperties
         *        a consumer that will call methods on {@link CopySourceImageSetProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceImageSetProperties(CopySourceImageSetProperties)
         */
        default Builder sourceImageSetProperties(Consumer<CopySourceImageSetProperties.Builder> sourceImageSetProperties) {
            return sourceImageSetProperties(CopySourceImageSetProperties.builder().applyMutation(sourceImageSetProperties)
                    .build());
        }

        /**
         * <p>
         * The properties of the destination image set.
         * </p>
         * 
         * @param destinationImageSetProperties
         *        The properties of the destination image set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationImageSetProperties(CopyDestinationImageSetProperties destinationImageSetProperties);

        /**
         * <p>
         * The properties of the destination image set.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CopyDestinationImageSetProperties.Builder} avoiding the need to create one manually via
         * {@link CopyDestinationImageSetProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CopyDestinationImageSetProperties.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #destinationImageSetProperties(CopyDestinationImageSetProperties)}.
         * 
         * @param destinationImageSetProperties
         *        a consumer that will call methods on {@link CopyDestinationImageSetProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationImageSetProperties(CopyDestinationImageSetProperties)
         */
        default Builder destinationImageSetProperties(
                Consumer<CopyDestinationImageSetProperties.Builder> destinationImageSetProperties) {
            return destinationImageSetProperties(CopyDestinationImageSetProperties.builder()
                    .applyMutation(destinationImageSetProperties).build());
        }
    }

    static final class BuilderImpl extends MedicalImagingResponse.BuilderImpl implements Builder {
        private String datastoreId;

        private CopySourceImageSetProperties sourceImageSetProperties;

        private CopyDestinationImageSetProperties destinationImageSetProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyImageSetResponse model) {
            super(model);
            datastoreId(model.datastoreId);
            sourceImageSetProperties(model.sourceImageSetProperties);
            destinationImageSetProperties(model.destinationImageSetProperties);
        }

        public final String getDatastoreId() {
            return datastoreId;
        }

        public final void setDatastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
        }

        @Override
        public final Builder datastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
            return this;
        }

        public final CopySourceImageSetProperties.Builder getSourceImageSetProperties() {
            return sourceImageSetProperties != null ? sourceImageSetProperties.toBuilder() : null;
        }

        public final void setSourceImageSetProperties(CopySourceImageSetProperties.BuilderImpl sourceImageSetProperties) {
            this.sourceImageSetProperties = sourceImageSetProperties != null ? sourceImageSetProperties.build() : null;
        }

        @Override
        public final Builder sourceImageSetProperties(CopySourceImageSetProperties sourceImageSetProperties) {
            this.sourceImageSetProperties = sourceImageSetProperties;
            return this;
        }

        public final CopyDestinationImageSetProperties.Builder getDestinationImageSetProperties() {
            return destinationImageSetProperties != null ? destinationImageSetProperties.toBuilder() : null;
        }

        public final void setDestinationImageSetProperties(
                CopyDestinationImageSetProperties.BuilderImpl destinationImageSetProperties) {
            this.destinationImageSetProperties = destinationImageSetProperties != null ? destinationImageSetProperties.build()
                    : null;
        }

        @Override
        public final Builder destinationImageSetProperties(CopyDestinationImageSetProperties destinationImageSetProperties) {
            this.destinationImageSetProperties = destinationImageSetProperties;
            return this;
        }

        @Override
        public CopyImageSetResponse build() {
            return new CopyImageSetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
