/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medicalimaging.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Copy source image set information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CopySourceImageSetInformation implements SdkPojo, Serializable,
        ToCopyableBuilder<CopySourceImageSetInformation.Builder, CopySourceImageSetInformation> {
    private static final SdkField<String> LATEST_VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("latestVersionId").getter(getter(CopySourceImageSetInformation::latestVersionId))
            .setter(setter(Builder::latestVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestVersionId").build()).build();

    private static final SdkField<MetadataCopies> DICOM_COPIES_FIELD = SdkField
            .<MetadataCopies> builder(MarshallingType.SDK_POJO).memberName("DICOMCopies")
            .getter(getter(CopySourceImageSetInformation::dicomCopies)).setter(setter(Builder::dicomCopies))
            .constructor(MetadataCopies::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DICOMCopies").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LATEST_VERSION_ID_FIELD,
            DICOM_COPIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String latestVersionId;

    private final MetadataCopies dicomCopies;

    private CopySourceImageSetInformation(BuilderImpl builder) {
        this.latestVersionId = builder.latestVersionId;
        this.dicomCopies = builder.dicomCopies;
    }

    /**
     * <p>
     * The latest version identifier for the source image set.
     * </p>
     * 
     * @return The latest version identifier for the source image set.
     */
    public final String latestVersionId() {
        return latestVersionId;
    }

    /**
     * <p>
     * Contains <code>MetadataCopies</code> structure and wraps information related to specific copy use cases. For
     * example, when copying subsets.
     * </p>
     * 
     * @return Contains <code>MetadataCopies</code> structure and wraps information related to specific copy use cases.
     *         For example, when copying subsets.
     */
    public final MetadataCopies dicomCopies() {
        return dicomCopies;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(latestVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(dicomCopies());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopySourceImageSetInformation)) {
            return false;
        }
        CopySourceImageSetInformation other = (CopySourceImageSetInformation) obj;
        return Objects.equals(latestVersionId(), other.latestVersionId()) && Objects.equals(dicomCopies(), other.dicomCopies());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CopySourceImageSetInformation").add("LatestVersionId", latestVersionId())
                .add("DICOMCopies", dicomCopies()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "latestVersionId":
            return Optional.ofNullable(clazz.cast(latestVersionId()));
        case "DICOMCopies":
            return Optional.ofNullable(clazz.cast(dicomCopies()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("latestVersionId", LATEST_VERSION_ID_FIELD);
        map.put("DICOMCopies", DICOM_COPIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CopySourceImageSetInformation, T> g) {
        return obj -> g.apply((CopySourceImageSetInformation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CopySourceImageSetInformation> {
        /**
         * <p>
         * The latest version identifier for the source image set.
         * </p>
         * 
         * @param latestVersionId
         *        The latest version identifier for the source image set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestVersionId(String latestVersionId);

        /**
         * <p>
         * Contains <code>MetadataCopies</code> structure and wraps information related to specific copy use cases. For
         * example, when copying subsets.
         * </p>
         * 
         * @param dicomCopies
         *        Contains <code>MetadataCopies</code> structure and wraps information related to specific copy use
         *        cases. For example, when copying subsets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dicomCopies(MetadataCopies dicomCopies);

        /**
         * <p>
         * Contains <code>MetadataCopies</code> structure and wraps information related to specific copy use cases. For
         * example, when copying subsets.
         * </p>
         * This is a convenience method that creates an instance of the {@link MetadataCopies.Builder} avoiding the need
         * to create one manually via {@link MetadataCopies#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MetadataCopies.Builder#build()} is called immediately and its
         * result is passed to {@link #dicomCopies(MetadataCopies)}.
         * 
         * @param dicomCopies
         *        a consumer that will call methods on {@link MetadataCopies.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dicomCopies(MetadataCopies)
         */
        default Builder dicomCopies(Consumer<MetadataCopies.Builder> dicomCopies) {
            return dicomCopies(MetadataCopies.builder().applyMutation(dicomCopies).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String latestVersionId;

        private MetadataCopies dicomCopies;

        private BuilderImpl() {
        }

        private BuilderImpl(CopySourceImageSetInformation model) {
            latestVersionId(model.latestVersionId);
            dicomCopies(model.dicomCopies);
        }

        public final String getLatestVersionId() {
            return latestVersionId;
        }

        public final void setLatestVersionId(String latestVersionId) {
            this.latestVersionId = latestVersionId;
        }

        @Override
        public final Builder latestVersionId(String latestVersionId) {
            this.latestVersionId = latestVersionId;
            return this;
        }

        public final MetadataCopies.Builder getDicomCopies() {
            return dicomCopies != null ? dicomCopies.toBuilder() : null;
        }

        public final void setDicomCopies(MetadataCopies.BuilderImpl dicomCopies) {
            this.dicomCopies = dicomCopies != null ? dicomCopies.build() : null;
        }

        @Override
        public final Builder dicomCopies(MetadataCopies dicomCopies) {
            this.dicomCopies = dicomCopies;
            return this;
        }

        @Override
        public CopySourceImageSetInformation build() {
            return new CopySourceImageSetInformation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
