/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medicalimaging.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Copy source image set properties.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CopySourceImageSetProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<CopySourceImageSetProperties.Builder, CopySourceImageSetProperties> {
    private static final SdkField<String> IMAGE_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imageSetId").getter(getter(CopySourceImageSetProperties::imageSetId))
            .setter(setter(Builder::imageSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageSetId").build()).build();

    private static final SdkField<String> LATEST_VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("latestVersionId").getter(getter(CopySourceImageSetProperties::latestVersionId))
            .setter(setter(Builder::latestVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestVersionId").build()).build();

    private static final SdkField<String> IMAGE_SET_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imageSetState").getter(getter(CopySourceImageSetProperties::imageSetStateAsString))
            .setter(setter(Builder::imageSetState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageSetState").build()).build();

    private static final SdkField<String> IMAGE_SET_WORKFLOW_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imageSetWorkflowStatus").getter(getter(CopySourceImageSetProperties::imageSetWorkflowStatusAsString))
            .setter(setter(Builder::imageSetWorkflowStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageSetWorkflowStatus").build())
            .build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(CopySourceImageSetProperties::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(CopySourceImageSetProperties::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final SdkField<String> IMAGE_SET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imageSetArn").getter(getter(CopySourceImageSetProperties::imageSetArn))
            .setter(setter(Builder::imageSetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageSetArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_SET_ID_FIELD,
            LATEST_VERSION_ID_FIELD, IMAGE_SET_STATE_FIELD, IMAGE_SET_WORKFLOW_STATUS_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD,
            IMAGE_SET_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String imageSetId;

    private final String latestVersionId;

    private final String imageSetState;

    private final String imageSetWorkflowStatus;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final String imageSetArn;

    private CopySourceImageSetProperties(BuilderImpl builder) {
        this.imageSetId = builder.imageSetId;
        this.latestVersionId = builder.latestVersionId;
        this.imageSetState = builder.imageSetState;
        this.imageSetWorkflowStatus = builder.imageSetWorkflowStatus;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.imageSetArn = builder.imageSetArn;
    }

    /**
     * <p>
     * The image set identifier for the copied source image set.
     * </p>
     * 
     * @return The image set identifier for the copied source image set.
     */
    public final String imageSetId() {
        return imageSetId;
    }

    /**
     * <p>
     * The latest version identifier for the copied source image set.
     * </p>
     * 
     * @return The latest version identifier for the copied source image set.
     */
    public final String latestVersionId() {
        return latestVersionId;
    }

    /**
     * <p>
     * The image set state of the copied source image set.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #imageSetState}
     * will return {@link ImageSetState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #imageSetStateAsString}.
     * </p>
     * 
     * @return The image set state of the copied source image set.
     * @see ImageSetState
     */
    public final ImageSetState imageSetState() {
        return ImageSetState.fromValue(imageSetState);
    }

    /**
     * <p>
     * The image set state of the copied source image set.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #imageSetState}
     * will return {@link ImageSetState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #imageSetStateAsString}.
     * </p>
     * 
     * @return The image set state of the copied source image set.
     * @see ImageSetState
     */
    public final String imageSetStateAsString() {
        return imageSetState;
    }

    /**
     * <p>
     * The workflow status of the copied source image set.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #imageSetWorkflowStatus} will return {@link ImageSetWorkflowStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #imageSetWorkflowStatusAsString}.
     * </p>
     * 
     * @return The workflow status of the copied source image set.
     * @see ImageSetWorkflowStatus
     */
    public final ImageSetWorkflowStatus imageSetWorkflowStatus() {
        return ImageSetWorkflowStatus.fromValue(imageSetWorkflowStatus);
    }

    /**
     * <p>
     * The workflow status of the copied source image set.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #imageSetWorkflowStatus} will return {@link ImageSetWorkflowStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #imageSetWorkflowStatusAsString}.
     * </p>
     * 
     * @return The workflow status of the copied source image set.
     * @see ImageSetWorkflowStatus
     */
    public final String imageSetWorkflowStatusAsString() {
        return imageSetWorkflowStatus;
    }

    /**
     * <p>
     * The timestamp when the source image set properties were created.
     * </p>
     * 
     * @return The timestamp when the source image set properties were created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp when the source image set properties were updated.
     * </p>
     * 
     * @return The timestamp when the source image set properties were updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) assigned to the source image set.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) assigned to the source image set.
     */
    public final String imageSetArn() {
        return imageSetArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(imageSetId());
        hashCode = 31 * hashCode + Objects.hashCode(latestVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(imageSetStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(imageSetWorkflowStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(imageSetArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopySourceImageSetProperties)) {
            return false;
        }
        CopySourceImageSetProperties other = (CopySourceImageSetProperties) obj;
        return Objects.equals(imageSetId(), other.imageSetId()) && Objects.equals(latestVersionId(), other.latestVersionId())
                && Objects.equals(imageSetStateAsString(), other.imageSetStateAsString())
                && Objects.equals(imageSetWorkflowStatusAsString(), other.imageSetWorkflowStatusAsString())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(imageSetArn(), other.imageSetArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CopySourceImageSetProperties").add("ImageSetId", imageSetId())
                .add("LatestVersionId", latestVersionId()).add("ImageSetState", imageSetStateAsString())
                .add("ImageSetWorkflowStatus", imageSetWorkflowStatusAsString()).add("CreatedAt", createdAt())
                .add("UpdatedAt", updatedAt()).add("ImageSetArn", imageSetArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "imageSetId":
            return Optional.ofNullable(clazz.cast(imageSetId()));
        case "latestVersionId":
            return Optional.ofNullable(clazz.cast(latestVersionId()));
        case "imageSetState":
            return Optional.ofNullable(clazz.cast(imageSetStateAsString()));
        case "imageSetWorkflowStatus":
            return Optional.ofNullable(clazz.cast(imageSetWorkflowStatusAsString()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "imageSetArn":
            return Optional.ofNullable(clazz.cast(imageSetArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("imageSetId", IMAGE_SET_ID_FIELD);
        map.put("latestVersionId", LATEST_VERSION_ID_FIELD);
        map.put("imageSetState", IMAGE_SET_STATE_FIELD);
        map.put("imageSetWorkflowStatus", IMAGE_SET_WORKFLOW_STATUS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("imageSetArn", IMAGE_SET_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CopySourceImageSetProperties, T> g) {
        return obj -> g.apply((CopySourceImageSetProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CopySourceImageSetProperties> {
        /**
         * <p>
         * The image set identifier for the copied source image set.
         * </p>
         * 
         * @param imageSetId
         *        The image set identifier for the copied source image set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageSetId(String imageSetId);

        /**
         * <p>
         * The latest version identifier for the copied source image set.
         * </p>
         * 
         * @param latestVersionId
         *        The latest version identifier for the copied source image set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestVersionId(String latestVersionId);

        /**
         * <p>
         * The image set state of the copied source image set.
         * </p>
         * 
         * @param imageSetState
         *        The image set state of the copied source image set.
         * @see ImageSetState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageSetState
         */
        Builder imageSetState(String imageSetState);

        /**
         * <p>
         * The image set state of the copied source image set.
         * </p>
         * 
         * @param imageSetState
         *        The image set state of the copied source image set.
         * @see ImageSetState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageSetState
         */
        Builder imageSetState(ImageSetState imageSetState);

        /**
         * <p>
         * The workflow status of the copied source image set.
         * </p>
         * 
         * @param imageSetWorkflowStatus
         *        The workflow status of the copied source image set.
         * @see ImageSetWorkflowStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageSetWorkflowStatus
         */
        Builder imageSetWorkflowStatus(String imageSetWorkflowStatus);

        /**
         * <p>
         * The workflow status of the copied source image set.
         * </p>
         * 
         * @param imageSetWorkflowStatus
         *        The workflow status of the copied source image set.
         * @see ImageSetWorkflowStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageSetWorkflowStatus
         */
        Builder imageSetWorkflowStatus(ImageSetWorkflowStatus imageSetWorkflowStatus);

        /**
         * <p>
         * The timestamp when the source image set properties were created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the source image set properties were created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp when the source image set properties were updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp when the source image set properties were updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The Amazon Resource Name (ARN) assigned to the source image set.
         * </p>
         * 
         * @param imageSetArn
         *        The Amazon Resource Name (ARN) assigned to the source image set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageSetArn(String imageSetArn);
    }

    static final class BuilderImpl implements Builder {
        private String imageSetId;

        private String latestVersionId;

        private String imageSetState;

        private String imageSetWorkflowStatus;

        private Instant createdAt;

        private Instant updatedAt;

        private String imageSetArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CopySourceImageSetProperties model) {
            imageSetId(model.imageSetId);
            latestVersionId(model.latestVersionId);
            imageSetState(model.imageSetState);
            imageSetWorkflowStatus(model.imageSetWorkflowStatus);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            imageSetArn(model.imageSetArn);
        }

        public final String getImageSetId() {
            return imageSetId;
        }

        public final void setImageSetId(String imageSetId) {
            this.imageSetId = imageSetId;
        }

        @Override
        public final Builder imageSetId(String imageSetId) {
            this.imageSetId = imageSetId;
            return this;
        }

        public final String getLatestVersionId() {
            return latestVersionId;
        }

        public final void setLatestVersionId(String latestVersionId) {
            this.latestVersionId = latestVersionId;
        }

        @Override
        public final Builder latestVersionId(String latestVersionId) {
            this.latestVersionId = latestVersionId;
            return this;
        }

        public final String getImageSetState() {
            return imageSetState;
        }

        public final void setImageSetState(String imageSetState) {
            this.imageSetState = imageSetState;
        }

        @Override
        public final Builder imageSetState(String imageSetState) {
            this.imageSetState = imageSetState;
            return this;
        }

        @Override
        public final Builder imageSetState(ImageSetState imageSetState) {
            this.imageSetState(imageSetState == null ? null : imageSetState.toString());
            return this;
        }

        public final String getImageSetWorkflowStatus() {
            return imageSetWorkflowStatus;
        }

        public final void setImageSetWorkflowStatus(String imageSetWorkflowStatus) {
            this.imageSetWorkflowStatus = imageSetWorkflowStatus;
        }

        @Override
        public final Builder imageSetWorkflowStatus(String imageSetWorkflowStatus) {
            this.imageSetWorkflowStatus = imageSetWorkflowStatus;
            return this;
        }

        @Override
        public final Builder imageSetWorkflowStatus(ImageSetWorkflowStatus imageSetWorkflowStatus) {
            this.imageSetWorkflowStatus(imageSetWorkflowStatus == null ? null : imageSetWorkflowStatus.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getImageSetArn() {
            return imageSetArn;
        }

        public final void setImageSetArn(String imageSetArn) {
            this.imageSetArn = imageSetArn;
        }

        @Override
        public final Builder imageSetArn(String imageSetArn) {
            this.imageSetArn = imageSetArn;
            return this;
        }

        @Override
        public CopySourceImageSetProperties build() {
            return new CopySourceImageSetProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
