/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medicalimaging.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Properties of the import job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DICOMImportJobProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<DICOMImportJobProperties.Builder, DICOMImportJobProperties> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobId")
            .getter(getter(DICOMImportJobProperties::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()).build();

    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobName").getter(getter(DICOMImportJobProperties::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()).build();

    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobStatus").getter(getter(DICOMImportJobProperties::jobStatusAsString))
            .setter(setter(Builder::jobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobStatus").build()).build();

    private static final SdkField<String> DATASTORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datastoreId").getter(getter(DICOMImportJobProperties::datastoreId)).setter(setter(Builder::datastoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datastoreId").build()).build();

    private static final SdkField<String> DATA_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataAccessRoleArn").getter(getter(DICOMImportJobProperties::dataAccessRoleArn))
            .setter(setter(Builder::dataAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataAccessRoleArn").build()).build();

    private static final SdkField<Instant> ENDED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endedAt").getter(getter(DICOMImportJobProperties::endedAt)).setter(setter(Builder::endedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endedAt").build()).build();

    private static final SdkField<Instant> SUBMITTED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("submittedAt").getter(getter(DICOMImportJobProperties::submittedAt)).setter(setter(Builder::submittedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("submittedAt").build()).build();

    private static final SdkField<String> INPUT_S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inputS3Uri").getter(getter(DICOMImportJobProperties::inputS3Uri)).setter(setter(Builder::inputS3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputS3Uri").build()).build();

    private static final SdkField<String> OUTPUT_S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("outputS3Uri").getter(getter(DICOMImportJobProperties::outputS3Uri)).setter(setter(Builder::outputS3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputS3Uri").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(DICOMImportJobProperties::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, JOB_NAME_FIELD,
            JOB_STATUS_FIELD, DATASTORE_ID_FIELD, DATA_ACCESS_ROLE_ARN_FIELD, ENDED_AT_FIELD, SUBMITTED_AT_FIELD,
            INPUT_S3_URI_FIELD, OUTPUT_S3_URI_FIELD, MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String jobId;

    private final String jobName;

    private final String jobStatus;

    private final String datastoreId;

    private final String dataAccessRoleArn;

    private final Instant endedAt;

    private final Instant submittedAt;

    private final String inputS3Uri;

    private final String outputS3Uri;

    private final String message;

    private DICOMImportJobProperties(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.jobName = builder.jobName;
        this.jobStatus = builder.jobStatus;
        this.datastoreId = builder.datastoreId;
        this.dataAccessRoleArn = builder.dataAccessRoleArn;
        this.endedAt = builder.endedAt;
        this.submittedAt = builder.submittedAt;
        this.inputS3Uri = builder.inputS3Uri;
        this.outputS3Uri = builder.outputS3Uri;
        this.message = builder.message;
    }

    /**
     * <p>
     * The import job identifier.
     * </p>
     * 
     * @return The import job identifier.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The import job name.
     * </p>
     * 
     * @return The import job name.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The filters for listing import jobs based on status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The filters for listing import jobs based on status.
     * @see JobStatus
     */
    public final JobStatus jobStatus() {
        return JobStatus.fromValue(jobStatus);
    }

    /**
     * <p>
     * The filters for listing import jobs based on status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The filters for listing import jobs based on status.
     * @see JobStatus
     */
    public final String jobStatusAsString() {
        return jobStatus;
    }

    /**
     * <p>
     * The data store identifier.
     * </p>
     * 
     * @return The data store identifier.
     */
    public final String datastoreId() {
        return datastoreId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that grants permissions to access medical imaging resources.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that grants permissions to access medical imaging resources.
     */
    public final String dataAccessRoleArn() {
        return dataAccessRoleArn;
    }

    /**
     * <p>
     * The timestamp for when the import job was ended.
     * </p>
     * 
     * @return The timestamp for when the import job was ended.
     */
    public final Instant endedAt() {
        return endedAt;
    }

    /**
     * <p>
     * The timestamp for when the import job was submitted.
     * </p>
     * 
     * @return The timestamp for when the import job was submitted.
     */
    public final Instant submittedAt() {
        return submittedAt;
    }

    /**
     * <p>
     * The input prefix path for the S3 bucket that contains the DICOM P10 files to be imported.
     * </p>
     * 
     * @return The input prefix path for the S3 bucket that contains the DICOM P10 files to be imported.
     */
    public final String inputS3Uri() {
        return inputS3Uri;
    }

    /**
     * <p>
     * The output prefix of the S3 bucket to upload the results of the DICOM import job.
     * </p>
     * 
     * @return The output prefix of the S3 bucket to upload the results of the DICOM import job.
     */
    public final String outputS3Uri() {
        return outputS3Uri;
    }

    /**
     * <p>
     * The error message thrown if an import job fails.
     * </p>
     * 
     * @return The error message thrown if an import job fails.
     */
    public final String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(datastoreId());
        hashCode = 31 * hashCode + Objects.hashCode(dataAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(endedAt());
        hashCode = 31 * hashCode + Objects.hashCode(submittedAt());
        hashCode = 31 * hashCode + Objects.hashCode(inputS3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(outputS3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DICOMImportJobProperties)) {
            return false;
        }
        DICOMImportJobProperties other = (DICOMImportJobProperties) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(jobName(), other.jobName())
                && Objects.equals(jobStatusAsString(), other.jobStatusAsString())
                && Objects.equals(datastoreId(), other.datastoreId())
                && Objects.equals(dataAccessRoleArn(), other.dataAccessRoleArn()) && Objects.equals(endedAt(), other.endedAt())
                && Objects.equals(submittedAt(), other.submittedAt()) && Objects.equals(inputS3Uri(), other.inputS3Uri())
                && Objects.equals(outputS3Uri(), other.outputS3Uri()) && Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DICOMImportJobProperties").add("JobId", jobId()).add("JobName", jobName())
                .add("JobStatus", jobStatusAsString()).add("DatastoreId", datastoreId())
                .add("DataAccessRoleArn", dataAccessRoleArn()).add("EndedAt", endedAt()).add("SubmittedAt", submittedAt())
                .add("InputS3Uri", inputS3Uri()).add("OutputS3Uri", outputS3Uri()).add("Message", message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "jobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "jobStatus":
            return Optional.ofNullable(clazz.cast(jobStatusAsString()));
        case "datastoreId":
            return Optional.ofNullable(clazz.cast(datastoreId()));
        case "dataAccessRoleArn":
            return Optional.ofNullable(clazz.cast(dataAccessRoleArn()));
        case "endedAt":
            return Optional.ofNullable(clazz.cast(endedAt()));
        case "submittedAt":
            return Optional.ofNullable(clazz.cast(submittedAt()));
        case "inputS3Uri":
            return Optional.ofNullable(clazz.cast(inputS3Uri()));
        case "outputS3Uri":
            return Optional.ofNullable(clazz.cast(outputS3Uri()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("jobId", JOB_ID_FIELD);
        map.put("jobName", JOB_NAME_FIELD);
        map.put("jobStatus", JOB_STATUS_FIELD);
        map.put("datastoreId", DATASTORE_ID_FIELD);
        map.put("dataAccessRoleArn", DATA_ACCESS_ROLE_ARN_FIELD);
        map.put("endedAt", ENDED_AT_FIELD);
        map.put("submittedAt", SUBMITTED_AT_FIELD);
        map.put("inputS3Uri", INPUT_S3_URI_FIELD);
        map.put("outputS3Uri", OUTPUT_S3_URI_FIELD);
        map.put("message", MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DICOMImportJobProperties, T> g) {
        return obj -> g.apply((DICOMImportJobProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DICOMImportJobProperties> {
        /**
         * <p>
         * The import job identifier.
         * </p>
         * 
         * @param jobId
         *        The import job identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The import job name.
         * </p>
         * 
         * @param jobName
         *        The import job name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The filters for listing import jobs based on status.
         * </p>
         * 
         * @param jobStatus
         *        The filters for listing import jobs based on status.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder jobStatus(String jobStatus);

        /**
         * <p>
         * The filters for listing import jobs based on status.
         * </p>
         * 
         * @param jobStatus
         *        The filters for listing import jobs based on status.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder jobStatus(JobStatus jobStatus);

        /**
         * <p>
         * The data store identifier.
         * </p>
         * 
         * @param datastoreId
         *        The data store identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datastoreId(String datastoreId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) that grants permissions to access medical imaging resources.
         * </p>
         * 
         * @param dataAccessRoleArn
         *        The Amazon Resource Name (ARN) that grants permissions to access medical imaging resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataAccessRoleArn(String dataAccessRoleArn);

        /**
         * <p>
         * The timestamp for when the import job was ended.
         * </p>
         * 
         * @param endedAt
         *        The timestamp for when the import job was ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endedAt(Instant endedAt);

        /**
         * <p>
         * The timestamp for when the import job was submitted.
         * </p>
         * 
         * @param submittedAt
         *        The timestamp for when the import job was submitted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder submittedAt(Instant submittedAt);

        /**
         * <p>
         * The input prefix path for the S3 bucket that contains the DICOM P10 files to be imported.
         * </p>
         * 
         * @param inputS3Uri
         *        The input prefix path for the S3 bucket that contains the DICOM P10 files to be imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputS3Uri(String inputS3Uri);

        /**
         * <p>
         * The output prefix of the S3 bucket to upload the results of the DICOM import job.
         * </p>
         * 
         * @param outputS3Uri
         *        The output prefix of the S3 bucket to upload the results of the DICOM import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputS3Uri(String outputS3Uri);

        /**
         * <p>
         * The error message thrown if an import job fails.
         * </p>
         * 
         * @param message
         *        The error message thrown if an import job fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String jobId;

        private String jobName;

        private String jobStatus;

        private String datastoreId;

        private String dataAccessRoleArn;

        private Instant endedAt;

        private Instant submittedAt;

        private String inputS3Uri;

        private String outputS3Uri;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(DICOMImportJobProperties model) {
            jobId(model.jobId);
            jobName(model.jobName);
            jobStatus(model.jobStatus);
            datastoreId(model.datastoreId);
            dataAccessRoleArn(model.dataAccessRoleArn);
            endedAt(model.endedAt);
            submittedAt(model.submittedAt);
            inputS3Uri(model.inputS3Uri);
            outputS3Uri(model.outputS3Uri);
            message(model.message);
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getJobStatus() {
            return jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(JobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final String getDatastoreId() {
            return datastoreId;
        }

        public final void setDatastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
        }

        @Override
        public final Builder datastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
            return this;
        }

        public final String getDataAccessRoleArn() {
            return dataAccessRoleArn;
        }

        public final void setDataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
        }

        @Override
        public final Builder dataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
            return this;
        }

        public final Instant getEndedAt() {
            return endedAt;
        }

        public final void setEndedAt(Instant endedAt) {
            this.endedAt = endedAt;
        }

        @Override
        public final Builder endedAt(Instant endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        public final Instant getSubmittedAt() {
            return submittedAt;
        }

        public final void setSubmittedAt(Instant submittedAt) {
            this.submittedAt = submittedAt;
        }

        @Override
        public final Builder submittedAt(Instant submittedAt) {
            this.submittedAt = submittedAt;
            return this;
        }

        public final String getInputS3Uri() {
            return inputS3Uri;
        }

        public final void setInputS3Uri(String inputS3Uri) {
            this.inputS3Uri = inputS3Uri;
        }

        @Override
        public final Builder inputS3Uri(String inputS3Uri) {
            this.inputS3Uri = inputS3Uri;
            return this;
        }

        public final String getOutputS3Uri() {
            return outputS3Uri;
        }

        public final void setOutputS3Uri(String outputS3Uri) {
            this.outputS3Uri = outputS3Uri;
        }

        @Override
        public final Builder outputS3Uri(String outputS3Uri) {
            this.outputS3Uri = outputS3Uri;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public DICOMImportJobProperties build() {
            return new DICOMImportJobProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
