/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medicalimaging.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The aggregated structure to store DICOM study date and study time for search capabilities.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DICOMStudyDateAndTime implements SdkPojo, Serializable,
        ToCopyableBuilder<DICOMStudyDateAndTime.Builder, DICOMStudyDateAndTime> {
    private static final SdkField<String> DICOM_STUDY_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DICOMStudyDate").getter(getter(DICOMStudyDateAndTime::dicomStudyDate))
            .setter(setter(Builder::dicomStudyDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DICOMStudyDate").build()).build();

    private static final SdkField<String> DICOM_STUDY_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DICOMStudyTime").getter(getter(DICOMStudyDateAndTime::dicomStudyTime))
            .setter(setter(Builder::dicomStudyTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DICOMStudyTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DICOM_STUDY_DATE_FIELD,
            DICOM_STUDY_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String dicomStudyDate;

    private final String dicomStudyTime;

    private DICOMStudyDateAndTime(BuilderImpl builder) {
        this.dicomStudyDate = builder.dicomStudyDate;
        this.dicomStudyTime = builder.dicomStudyTime;
    }

    /**
     * <p>
     * The DICOM study date provided in <code>yyMMdd</code> format.
     * </p>
     * 
     * @return The DICOM study date provided in <code>yyMMdd</code> format.
     */
    public final String dicomStudyDate() {
        return dicomStudyDate;
    }

    /**
     * <p>
     * The DICOM study time provided in <code>HHmmss.FFFFFF</code> format.
     * </p>
     * 
     * @return The DICOM study time provided in <code>HHmmss.FFFFFF</code> format.
     */
    public final String dicomStudyTime() {
        return dicomStudyTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dicomStudyDate());
        hashCode = 31 * hashCode + Objects.hashCode(dicomStudyTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DICOMStudyDateAndTime)) {
            return false;
        }
        DICOMStudyDateAndTime other = (DICOMStudyDateAndTime) obj;
        return Objects.equals(dicomStudyDate(), other.dicomStudyDate())
                && Objects.equals(dicomStudyTime(), other.dicomStudyTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DICOMStudyDateAndTime")
                .add("DICOMStudyDate", dicomStudyDate() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DICOMStudyTime", dicomStudyTime() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DICOMStudyDate":
            return Optional.ofNullable(clazz.cast(dicomStudyDate()));
        case "DICOMStudyTime":
            return Optional.ofNullable(clazz.cast(dicomStudyTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DICOMStudyDate", DICOM_STUDY_DATE_FIELD);
        map.put("DICOMStudyTime", DICOM_STUDY_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DICOMStudyDateAndTime, T> g) {
        return obj -> g.apply((DICOMStudyDateAndTime) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DICOMStudyDateAndTime> {
        /**
         * <p>
         * The DICOM study date provided in <code>yyMMdd</code> format.
         * </p>
         * 
         * @param dicomStudyDate
         *        The DICOM study date provided in <code>yyMMdd</code> format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dicomStudyDate(String dicomStudyDate);

        /**
         * <p>
         * The DICOM study time provided in <code>HHmmss.FFFFFF</code> format.
         * </p>
         * 
         * @param dicomStudyTime
         *        The DICOM study time provided in <code>HHmmss.FFFFFF</code> format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dicomStudyTime(String dicomStudyTime);
    }

    static final class BuilderImpl implements Builder {
        private String dicomStudyDate;

        private String dicomStudyTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DICOMStudyDateAndTime model) {
            dicomStudyDate(model.dicomStudyDate);
            dicomStudyTime(model.dicomStudyTime);
        }

        public final String getDicomStudyDate() {
            return dicomStudyDate;
        }

        public final void setDicomStudyDate(String dicomStudyDate) {
            this.dicomStudyDate = dicomStudyDate;
        }

        @Override
        public final Builder dicomStudyDate(String dicomStudyDate) {
            this.dicomStudyDate = dicomStudyDate;
            return this;
        }

        public final String getDicomStudyTime() {
            return dicomStudyTime;
        }

        public final void setDicomStudyTime(String dicomStudyTime) {
            this.dicomStudyTime = dicomStudyTime;
        }

        @Override
        public final Builder dicomStudyTime(String dicomStudyTime) {
            this.dicomStudyTime = dicomStudyTime;
            return this;
        }

        @Override
        public DICOMStudyDateAndTime build() {
            return new DICOMStudyDateAndTime(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
