/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medicalimaging.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteDatastoreResponse extends MedicalImagingResponse implements
        ToCopyableBuilder<DeleteDatastoreResponse.Builder, DeleteDatastoreResponse> {
    private static final SdkField<String> DATASTORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datastoreId").getter(getter(DeleteDatastoreResponse::datastoreId)).setter(setter(Builder::datastoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datastoreId").build()).build();

    private static final SdkField<String> DATASTORE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datastoreStatus").getter(getter(DeleteDatastoreResponse::datastoreStatusAsString))
            .setter(setter(Builder::datastoreStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datastoreStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASTORE_ID_FIELD,
            DATASTORE_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String datastoreId;

    private final String datastoreStatus;

    private DeleteDatastoreResponse(BuilderImpl builder) {
        super(builder);
        this.datastoreId = builder.datastoreId;
        this.datastoreStatus = builder.datastoreStatus;
    }

    /**
     * <p>
     * The data store identifier.
     * </p>
     * 
     * @return The data store identifier.
     */
    public final String datastoreId() {
        return datastoreId;
    }

    /**
     * <p>
     * The data store status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #datastoreStatus}
     * will return {@link DatastoreStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #datastoreStatusAsString}.
     * </p>
     * 
     * @return The data store status.
     * @see DatastoreStatus
     */
    public final DatastoreStatus datastoreStatus() {
        return DatastoreStatus.fromValue(datastoreStatus);
    }

    /**
     * <p>
     * The data store status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #datastoreStatus}
     * will return {@link DatastoreStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #datastoreStatusAsString}.
     * </p>
     * 
     * @return The data store status.
     * @see DatastoreStatus
     */
    public final String datastoreStatusAsString() {
        return datastoreStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(datastoreId());
        hashCode = 31 * hashCode + Objects.hashCode(datastoreStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDatastoreResponse)) {
            return false;
        }
        DeleteDatastoreResponse other = (DeleteDatastoreResponse) obj;
        return Objects.equals(datastoreId(), other.datastoreId())
                && Objects.equals(datastoreStatusAsString(), other.datastoreStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteDatastoreResponse").add("DatastoreId", datastoreId())
                .add("DatastoreStatus", datastoreStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "datastoreId":
            return Optional.ofNullable(clazz.cast(datastoreId()));
        case "datastoreStatus":
            return Optional.ofNullable(clazz.cast(datastoreStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("datastoreId", DATASTORE_ID_FIELD);
        map.put("datastoreStatus", DATASTORE_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteDatastoreResponse, T> g) {
        return obj -> g.apply((DeleteDatastoreResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MedicalImagingResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteDatastoreResponse> {
        /**
         * <p>
         * The data store identifier.
         * </p>
         * 
         * @param datastoreId
         *        The data store identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datastoreId(String datastoreId);

        /**
         * <p>
         * The data store status.
         * </p>
         * 
         * @param datastoreStatus
         *        The data store status.
         * @see DatastoreStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatastoreStatus
         */
        Builder datastoreStatus(String datastoreStatus);

        /**
         * <p>
         * The data store status.
         * </p>
         * 
         * @param datastoreStatus
         *        The data store status.
         * @see DatastoreStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatastoreStatus
         */
        Builder datastoreStatus(DatastoreStatus datastoreStatus);
    }

    static final class BuilderImpl extends MedicalImagingResponse.BuilderImpl implements Builder {
        private String datastoreId;

        private String datastoreStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDatastoreResponse model) {
            super(model);
            datastoreId(model.datastoreId);
            datastoreStatus(model.datastoreStatus);
        }

        public final String getDatastoreId() {
            return datastoreId;
        }

        public final void setDatastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
        }

        @Override
        public final Builder datastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
            return this;
        }

        public final String getDatastoreStatus() {
            return datastoreStatus;
        }

        public final void setDatastoreStatus(String datastoreStatus) {
            this.datastoreStatus = datastoreStatus;
        }

        @Override
        public final Builder datastoreStatus(String datastoreStatus) {
            this.datastoreStatus = datastoreStatus;
            return this;
        }

        @Override
        public final Builder datastoreStatus(DatastoreStatus datastoreStatus) {
            this.datastoreStatus(datastoreStatus == null ? null : datastoreStatus.toString());
            return this;
        }

        @Override
        public DeleteDatastoreResponse build() {
            return new DeleteDatastoreResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
