/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medicalimaging.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDicomImportJobsResponse extends MedicalImagingResponse implements
        ToCopyableBuilder<ListDicomImportJobsResponse.Builder, ListDicomImportJobsResponse> {
    private static final SdkField<List<DICOMImportJobSummary>> JOB_SUMMARIES_FIELD = SdkField
            .<List<DICOMImportJobSummary>> builder(MarshallingType.LIST)
            .memberName("jobSummaries")
            .getter(getter(ListDicomImportJobsResponse::jobSummaries))
            .setter(setter(Builder::jobSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DICOMImportJobSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(DICOMImportJobSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListDicomImportJobsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<DICOMImportJobSummary> jobSummaries;

    private final String nextToken;

    private ListDicomImportJobsResponse(BuilderImpl builder) {
        super(builder);
        this.jobSummaries = builder.jobSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the JobSummaries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasJobSummaries() {
        return jobSummaries != null && !(jobSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of job summaries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasJobSummaries} method.
     * </p>
     * 
     * @return A list of job summaries.
     */
    public final List<DICOMImportJobSummary> jobSummaries() {
        return jobSummaries;
    }

    /**
     * <p>
     * The pagination token used to retrieve the list of import jobs on the next page.
     * </p>
     * 
     * @return The pagination token used to retrieve the list of import jobs on the next page.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasJobSummaries() ? jobSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDicomImportJobsResponse)) {
            return false;
        }
        ListDicomImportJobsResponse other = (ListDicomImportJobsResponse) obj;
        return hasJobSummaries() == other.hasJobSummaries() && Objects.equals(jobSummaries(), other.jobSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDicomImportJobsResponse").add("JobSummaries", hasJobSummaries() ? jobSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobSummaries":
            return Optional.ofNullable(clazz.cast(jobSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("jobSummaries", JOB_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDicomImportJobsResponse, T> g) {
        return obj -> g.apply((ListDicomImportJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MedicalImagingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListDicomImportJobsResponse> {
        /**
         * <p>
         * A list of job summaries.
         * </p>
         * 
         * @param jobSummaries
         *        A list of job summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobSummaries(Collection<DICOMImportJobSummary> jobSummaries);

        /**
         * <p>
         * A list of job summaries.
         * </p>
         * 
         * @param jobSummaries
         *        A list of job summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobSummaries(DICOMImportJobSummary... jobSummaries);

        /**
         * <p>
         * A list of job summaries.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.medicalimaging.model.DICOMImportJobSummary.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.medicalimaging.model.DICOMImportJobSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.medicalimaging.model.DICOMImportJobSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #jobSummaries(List<DICOMImportJobSummary>)}.
         * 
         * @param jobSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.medicalimaging.model.DICOMImportJobSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobSummaries(java.util.Collection<DICOMImportJobSummary>)
         */
        Builder jobSummaries(Consumer<DICOMImportJobSummary.Builder>... jobSummaries);

        /**
         * <p>
         * The pagination token used to retrieve the list of import jobs on the next page.
         * </p>
         * 
         * @param nextToken
         *        The pagination token used to retrieve the list of import jobs on the next page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends MedicalImagingResponse.BuilderImpl implements Builder {
        private List<DICOMImportJobSummary> jobSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDicomImportJobsResponse model) {
            super(model);
            jobSummaries(model.jobSummaries);
            nextToken(model.nextToken);
        }

        public final List<DICOMImportJobSummary.Builder> getJobSummaries() {
            List<DICOMImportJobSummary.Builder> result = DICOMImportJobSummariesCopier.copyToBuilder(this.jobSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setJobSummaries(Collection<DICOMImportJobSummary.BuilderImpl> jobSummaries) {
            this.jobSummaries = DICOMImportJobSummariesCopier.copyFromBuilder(jobSummaries);
        }

        @Override
        public final Builder jobSummaries(Collection<DICOMImportJobSummary> jobSummaries) {
            this.jobSummaries = DICOMImportJobSummariesCopier.copy(jobSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobSummaries(DICOMImportJobSummary... jobSummaries) {
            jobSummaries(Arrays.asList(jobSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobSummaries(Consumer<DICOMImportJobSummary.Builder>... jobSummaries) {
            jobSummaries(Stream.of(jobSummaries).map(c -> DICOMImportJobSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDicomImportJobsResponse build() {
            return new ListDicomImportJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
