/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medicalimaging.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains copiable <code>Attributes</code> structure and wraps information related to specific copy use cases. For
 * example, when copying subsets.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetadataCopies implements SdkPojo, Serializable, ToCopyableBuilder<MetadataCopies.Builder, MetadataCopies> {
    private static final SdkField<String> COPIABLE_ATTRIBUTES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("copiableAttributes").getter(getter(MetadataCopies::copiableAttributes))
            .setter(setter(Builder::copiableAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("copiableAttributes").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COPIABLE_ATTRIBUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String copiableAttributes;

    private MetadataCopies(BuilderImpl builder) {
        this.copiableAttributes = builder.copiableAttributes;
    }

    /**
     * <p>
     * The JSON string used to specify a subset of SOP Instances to copy from source to destination image set.
     * </p>
     * 
     * @return The JSON string used to specify a subset of SOP Instances to copy from source to destination image set.
     */
    public final String copiableAttributes() {
        return copiableAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(copiableAttributes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetadataCopies)) {
            return false;
        }
        MetadataCopies other = (MetadataCopies) obj;
        return Objects.equals(copiableAttributes(), other.copiableAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetadataCopies")
                .add("CopiableAttributes", copiableAttributes() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "copiableAttributes":
            return Optional.ofNullable(clazz.cast(copiableAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("copiableAttributes", COPIABLE_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetadataCopies, T> g) {
        return obj -> g.apply((MetadataCopies) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetadataCopies> {
        /**
         * <p>
         * The JSON string used to specify a subset of SOP Instances to copy from source to destination image set.
         * </p>
         * 
         * @param copiableAttributes
         *        The JSON string used to specify a subset of SOP Instances to copy from source to destination image
         *        set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copiableAttributes(String copiableAttributes);
    }

    static final class BuilderImpl implements Builder {
        private String copiableAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(MetadataCopies model) {
            copiableAttributes(model.copiableAttributes);
        }

        public final String getCopiableAttributes() {
            return copiableAttributes;
        }

        public final void setCopiableAttributes(String copiableAttributes) {
            this.copiableAttributes = copiableAttributes;
        }

        @Override
        public final Builder copiableAttributes(String copiableAttributes) {
            this.copiableAttributes = copiableAttributes;
            return this;
        }

        @Override
        public MetadataCopies build() {
            return new MetadataCopies(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
