/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medicalimaging.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the overrides used in image set modification calls to <code>CopyImageSet</code> and
 * <code>UpdateImageSetMetadata</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Overrides implements SdkPojo, Serializable, ToCopyableBuilder<Overrides.Builder, Overrides> {
    private static final SdkField<Boolean> FORCED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("forced").getter(getter(Overrides::forced)).setter(setter(Builder::forced))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forced").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORCED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean forced;

    private Overrides(BuilderImpl builder) {
        this.forced = builder.forced;
    }

    /**
     * <p>
     * Setting this flag will force the <code>CopyImageSet</code> and <code>UpdateImageSetMetadata</code> operations,
     * even if Patient, Study, or Series level metadata are mismatched.
     * </p>
     * 
     * @return Setting this flag will force the <code>CopyImageSet</code> and <code>UpdateImageSetMetadata</code>
     *         operations, even if Patient, Study, or Series level metadata are mismatched.
     */
    public final Boolean forced() {
        return forced;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(forced());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Overrides)) {
            return false;
        }
        Overrides other = (Overrides) obj;
        return Objects.equals(forced(), other.forced());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Overrides").add("Forced", forced()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "forced":
            return Optional.ofNullable(clazz.cast(forced()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("forced", FORCED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Overrides, T> g) {
        return obj -> g.apply((Overrides) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Overrides> {
        /**
         * <p>
         * Setting this flag will force the <code>CopyImageSet</code> and <code>UpdateImageSetMetadata</code>
         * operations, even if Patient, Study, or Series level metadata are mismatched.
         * </p>
         * 
         * @param forced
         *        Setting this flag will force the <code>CopyImageSet</code> and <code>UpdateImageSetMetadata</code>
         *        operations, even if Patient, Study, or Series level metadata are mismatched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forced(Boolean forced);
    }

    static final class BuilderImpl implements Builder {
        private Boolean forced;

        private BuilderImpl() {
        }

        private BuilderImpl(Overrides model) {
            forced(model.forced);
        }

        public final Boolean getForced() {
            return forced;
        }

        public final void setForced(Boolean forced) {
            this.forced = forced;
        }

        @Override
        public final Builder forced(Boolean forced) {
            this.forced = forced;
            return this;
        }

        @Override
        public Overrides build() {
            return new Overrides(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
