/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medicalimaging.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchImageSetsRequest extends MedicalImagingRequest implements
        ToCopyableBuilder<SearchImageSetsRequest.Builder, SearchImageSetsRequest> {
    private static final SdkField<String> DATASTORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datastoreId").getter(getter(SearchImageSetsRequest::datastoreId)).setter(setter(Builder::datastoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("datastoreId").build()).build();

    private static final SdkField<SearchCriteria> SEARCH_CRITERIA_FIELD = SdkField
            .<SearchCriteria> builder(MarshallingType.SDK_POJO)
            .memberName("searchCriteria")
            .getter(getter(SearchImageSetsRequest::searchCriteria))
            .setter(setter(Builder::searchCriteria))
            .constructor(SearchCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("searchCriteria").build(),
                    PayloadTrait.create()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(SearchImageSetsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(SearchImageSetsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASTORE_ID_FIELD,
            SEARCH_CRITERIA_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String datastoreId;

    private final SearchCriteria searchCriteria;

    private final Integer maxResults;

    private final String nextToken;

    private SearchImageSetsRequest(BuilderImpl builder) {
        super(builder);
        this.datastoreId = builder.datastoreId;
        this.searchCriteria = builder.searchCriteria;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The identifier of the data store where the image sets reside.
     * </p>
     * 
     * @return The identifier of the data store where the image sets reside.
     */
    public final String datastoreId() {
        return datastoreId;
    }

    /**
     * <p>
     * The search criteria that filters by applying a maximum of 1 item to <code>SearchByAttribute</code>.
     * </p>
     * 
     * @return The search criteria that filters by applying a maximum of 1 item to <code>SearchByAttribute</code>.
     */
    public final SearchCriteria searchCriteria() {
        return searchCriteria;
    }

    /**
     * <p>
     * The maximum number of results that can be returned in a search.
     * </p>
     * 
     * @return The maximum number of results that can be returned in a search.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token used for pagination of results returned in the response. Use the token returned from the previous
     * request to continue results where the previous request ended.
     * </p>
     * 
     * @return The token used for pagination of results returned in the response. Use the token returned from the
     *         previous request to continue results where the previous request ended.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(datastoreId());
        hashCode = 31 * hashCode + Objects.hashCode(searchCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchImageSetsRequest)) {
            return false;
        }
        SearchImageSetsRequest other = (SearchImageSetsRequest) obj;
        return Objects.equals(datastoreId(), other.datastoreId()) && Objects.equals(searchCriteria(), other.searchCriteria())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchImageSetsRequest").add("DatastoreId", datastoreId())
                .add("SearchCriteria", searchCriteria() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "datastoreId":
            return Optional.ofNullable(clazz.cast(datastoreId()));
        case "searchCriteria":
            return Optional.ofNullable(clazz.cast(searchCriteria()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("datastoreId", DATASTORE_ID_FIELD);
        map.put("searchCriteria", SEARCH_CRITERIA_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchImageSetsRequest, T> g) {
        return obj -> g.apply((SearchImageSetsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MedicalImagingRequest.Builder, SdkPojo, CopyableBuilder<Builder, SearchImageSetsRequest> {
        /**
         * <p>
         * The identifier of the data store where the image sets reside.
         * </p>
         * 
         * @param datastoreId
         *        The identifier of the data store where the image sets reside.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datastoreId(String datastoreId);

        /**
         * <p>
         * The search criteria that filters by applying a maximum of 1 item to <code>SearchByAttribute</code>.
         * </p>
         * 
         * @param searchCriteria
         *        The search criteria that filters by applying a maximum of 1 item to <code>SearchByAttribute</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchCriteria(SearchCriteria searchCriteria);

        /**
         * <p>
         * The search criteria that filters by applying a maximum of 1 item to <code>SearchByAttribute</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link SearchCriteria.Builder} avoiding the need
         * to create one manually via {@link SearchCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SearchCriteria.Builder#build()} is called immediately and its
         * result is passed to {@link #searchCriteria(SearchCriteria)}.
         * 
         * @param searchCriteria
         *        a consumer that will call methods on {@link SearchCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #searchCriteria(SearchCriteria)
         */
        default Builder searchCriteria(Consumer<SearchCriteria.Builder> searchCriteria) {
            return searchCriteria(SearchCriteria.builder().applyMutation(searchCriteria).build());
        }

        /**
         * <p>
         * The maximum number of results that can be returned in a search.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results that can be returned in a search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token used for pagination of results returned in the response. Use the token returned from the previous
         * request to continue results where the previous request ended.
         * </p>
         * 
         * @param nextToken
         *        The token used for pagination of results returned in the response. Use the token returned from the
         *        previous request to continue results where the previous request ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MedicalImagingRequest.BuilderImpl implements Builder {
        private String datastoreId;

        private SearchCriteria searchCriteria;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchImageSetsRequest model) {
            super(model);
            datastoreId(model.datastoreId);
            searchCriteria(model.searchCriteria);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getDatastoreId() {
            return datastoreId;
        }

        public final void setDatastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
        }

        @Override
        public final Builder datastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
            return this;
        }

        public final SearchCriteria.Builder getSearchCriteria() {
            return searchCriteria != null ? searchCriteria.toBuilder() : null;
        }

        public final void setSearchCriteria(SearchCriteria.BuilderImpl searchCriteria) {
            this.searchCriteria = searchCriteria != null ? searchCriteria.build() : null;
        }

        @Override
        public final Builder searchCriteria(SearchCriteria searchCriteria) {
            this.searchCriteria = searchCriteria;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchImageSetsRequest build() {
            return new SearchImageSetsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
