/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medicalimaging.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchImageSetsResponse extends MedicalImagingResponse implements
        ToCopyableBuilder<SearchImageSetsResponse.Builder, SearchImageSetsResponse> {
    private static final SdkField<List<ImageSetsMetadataSummary>> IMAGE_SETS_METADATA_SUMMARIES_FIELD = SdkField
            .<List<ImageSetsMetadataSummary>> builder(MarshallingType.LIST)
            .memberName("imageSetsMetadataSummaries")
            .getter(getter(SearchImageSetsResponse::imageSetsMetadataSummaries))
            .setter(setter(Builder::imageSetsMetadataSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageSetsMetadataSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ImageSetsMetadataSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ImageSetsMetadataSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Sort> SORT_FIELD = SdkField.<Sort> builder(MarshallingType.SDK_POJO).memberName("sort")
            .getter(getter(SearchImageSetsResponse::sort)).setter(setter(Builder::sort)).constructor(Sort::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sort").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(SearchImageSetsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            IMAGE_SETS_METADATA_SUMMARIES_FIELD, SORT_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ImageSetsMetadataSummary> imageSetsMetadataSummaries;

    private final Sort sort;

    private final String nextToken;

    private SearchImageSetsResponse(BuilderImpl builder) {
        super(builder);
        this.imageSetsMetadataSummaries = builder.imageSetsMetadataSummaries;
        this.sort = builder.sort;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ImageSetsMetadataSummaries property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasImageSetsMetadataSummaries() {
        return imageSetsMetadataSummaries != null && !(imageSetsMetadataSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The model containing the image set results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImageSetsMetadataSummaries} method.
     * </p>
     * 
     * @return The model containing the image set results.
     */
    public final List<ImageSetsMetadataSummary> imageSetsMetadataSummaries() {
        return imageSetsMetadataSummaries;
    }

    /**
     * <p>
     * The sort order for image set search results.
     * </p>
     * 
     * @return The sort order for image set search results.
     */
    public final Sort sort() {
        return sort;
    }

    /**
     * <p>
     * The token for pagination results.
     * </p>
     * 
     * @return The token for pagination results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasImageSetsMetadataSummaries() ? imageSetsMetadataSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sort());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchImageSetsResponse)) {
            return false;
        }
        SearchImageSetsResponse other = (SearchImageSetsResponse) obj;
        return hasImageSetsMetadataSummaries() == other.hasImageSetsMetadataSummaries()
                && Objects.equals(imageSetsMetadataSummaries(), other.imageSetsMetadataSummaries())
                && Objects.equals(sort(), other.sort()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchImageSetsResponse")
                .add("ImageSetsMetadataSummaries", hasImageSetsMetadataSummaries() ? imageSetsMetadataSummaries() : null)
                .add("Sort", sort()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "imageSetsMetadataSummaries":
            return Optional.ofNullable(clazz.cast(imageSetsMetadataSummaries()));
        case "sort":
            return Optional.ofNullable(clazz.cast(sort()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("imageSetsMetadataSummaries", IMAGE_SETS_METADATA_SUMMARIES_FIELD);
        map.put("sort", SORT_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchImageSetsResponse, T> g) {
        return obj -> g.apply((SearchImageSetsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MedicalImagingResponse.Builder, SdkPojo, CopyableBuilder<Builder, SearchImageSetsResponse> {
        /**
         * <p>
         * The model containing the image set results.
         * </p>
         * 
         * @param imageSetsMetadataSummaries
         *        The model containing the image set results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageSetsMetadataSummaries(Collection<ImageSetsMetadataSummary> imageSetsMetadataSummaries);

        /**
         * <p>
         * The model containing the image set results.
         * </p>
         * 
         * @param imageSetsMetadataSummaries
         *        The model containing the image set results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageSetsMetadataSummaries(ImageSetsMetadataSummary... imageSetsMetadataSummaries);

        /**
         * <p>
         * The model containing the image set results.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.medicalimaging.model.ImageSetsMetadataSummary.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.medicalimaging.model.ImageSetsMetadataSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.medicalimaging.model.ImageSetsMetadataSummary.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #imageSetsMetadataSummaries(List<ImageSetsMetadataSummary>)}.
         * 
         * @param imageSetsMetadataSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.medicalimaging.model.ImageSetsMetadataSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageSetsMetadataSummaries(java.util.Collection<ImageSetsMetadataSummary>)
         */
        Builder imageSetsMetadataSummaries(Consumer<ImageSetsMetadataSummary.Builder>... imageSetsMetadataSummaries);

        /**
         * <p>
         * The sort order for image set search results.
         * </p>
         * 
         * @param sort
         *        The sort order for image set search results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sort(Sort sort);

        /**
         * <p>
         * The sort order for image set search results.
         * </p>
         * This is a convenience method that creates an instance of the {@link Sort.Builder} avoiding the need to create
         * one manually via {@link Sort#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Sort.Builder#build()} is called immediately and its result is
         * passed to {@link #sort(Sort)}.
         * 
         * @param sort
         *        a consumer that will call methods on {@link Sort.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sort(Sort)
         */
        default Builder sort(Consumer<Sort.Builder> sort) {
            return sort(Sort.builder().applyMutation(sort).build());
        }

        /**
         * <p>
         * The token for pagination results.
         * </p>
         * 
         * @param nextToken
         *        The token for pagination results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends MedicalImagingResponse.BuilderImpl implements Builder {
        private List<ImageSetsMetadataSummary> imageSetsMetadataSummaries = DefaultSdkAutoConstructList.getInstance();

        private Sort sort;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchImageSetsResponse model) {
            super(model);
            imageSetsMetadataSummaries(model.imageSetsMetadataSummaries);
            sort(model.sort);
            nextToken(model.nextToken);
        }

        public final List<ImageSetsMetadataSummary.Builder> getImageSetsMetadataSummaries() {
            List<ImageSetsMetadataSummary.Builder> result = ImageSetsMetadataSummariesCopier
                    .copyToBuilder(this.imageSetsMetadataSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImageSetsMetadataSummaries(
                Collection<ImageSetsMetadataSummary.BuilderImpl> imageSetsMetadataSummaries) {
            this.imageSetsMetadataSummaries = ImageSetsMetadataSummariesCopier.copyFromBuilder(imageSetsMetadataSummaries);
        }

        @Override
        public final Builder imageSetsMetadataSummaries(Collection<ImageSetsMetadataSummary> imageSetsMetadataSummaries) {
            this.imageSetsMetadataSummaries = ImageSetsMetadataSummariesCopier.copy(imageSetsMetadataSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageSetsMetadataSummaries(ImageSetsMetadataSummary... imageSetsMetadataSummaries) {
            imageSetsMetadataSummaries(Arrays.asList(imageSetsMetadataSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageSetsMetadataSummaries(Consumer<ImageSetsMetadataSummary.Builder>... imageSetsMetadataSummaries) {
            imageSetsMetadataSummaries(Stream.of(imageSetsMetadataSummaries)
                    .map(c -> ImageSetsMetadataSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Sort.Builder getSort() {
            return sort != null ? sort.toBuilder() : null;
        }

        public final void setSort(Sort.BuilderImpl sort) {
            this.sort = sort != null ? sort.build() : null;
        }

        @Override
        public final Builder sort(Sort sort) {
            this.sort = sort;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public SearchImageSetsResponse build() {
            return new SearchImageSetsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
