/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medicalimaging.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Sort search results.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Sort implements SdkPojo, Serializable, ToCopyableBuilder<Sort.Builder, Sort> {
    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sortOrder").getter(getter(Sort::sortOrderAsString)).setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortOrder").build()).build();

    private static final SdkField<String> SORT_FIELD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sortField").getter(getter(Sort::sortFieldAsString)).setter(setter(Builder::sortField))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortField").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SORT_ORDER_FIELD,
            SORT_FIELD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sortOrder;

    private final String sortField;

    private Sort(BuilderImpl builder) {
        this.sortOrder = builder.sortOrder;
        this.sortField = builder.sortField;
    }

    /**
     * <p>
     * The sort order for search criteria.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The sort order for search criteria.
     * @see SortOrder
     */
    public final SortOrder sortOrder() {
        return SortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * The sort order for search criteria.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The sort order for search criteria.
     * @see SortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    /**
     * <p>
     * The sort field for search criteria.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortField} will
     * return {@link SortField#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortFieldAsString}.
     * </p>
     * 
     * @return The sort field for search criteria.
     * @see SortField
     */
    public final SortField sortField() {
        return SortField.fromValue(sortField);
    }

    /**
     * <p>
     * The sort field for search criteria.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortField} will
     * return {@link SortField#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortFieldAsString}.
     * </p>
     * 
     * @return The sort field for search criteria.
     * @see SortField
     */
    public final String sortFieldAsString() {
        return sortField;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortFieldAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Sort)) {
            return false;
        }
        Sort other = (Sort) obj;
        return Objects.equals(sortOrderAsString(), other.sortOrderAsString())
                && Objects.equals(sortFieldAsString(), other.sortFieldAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Sort").add("SortOrder", sortOrderAsString()).add("SortField", sortFieldAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        case "sortField":
            return Optional.ofNullable(clazz.cast(sortFieldAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sortOrder", SORT_ORDER_FIELD);
        map.put("sortField", SORT_FIELD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Sort, T> g) {
        return obj -> g.apply((Sort) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Sort> {
        /**
         * <p>
         * The sort order for search criteria.
         * </p>
         * 
         * @param sortOrder
         *        The sort order for search criteria.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * The sort order for search criteria.
         * </p>
         * 
         * @param sortOrder
         *        The sort order for search criteria.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(SortOrder sortOrder);

        /**
         * <p>
         * The sort field for search criteria.
         * </p>
         * 
         * @param sortField
         *        The sort field for search criteria.
         * @see SortField
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortField
         */
        Builder sortField(String sortField);

        /**
         * <p>
         * The sort field for search criteria.
         * </p>
         * 
         * @param sortField
         *        The sort field for search criteria.
         * @see SortField
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortField
         */
        Builder sortField(SortField sortField);
    }

    static final class BuilderImpl implements Builder {
        private String sortOrder;

        private String sortField;

        private BuilderImpl() {
        }

        private BuilderImpl(Sort model) {
            sortOrder(model.sortOrder);
            sortField(model.sortField);
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final String getSortField() {
            return sortField;
        }

        public final void setSortField(String sortField) {
            this.sortField = sortField;
        }

        @Override
        public final Builder sortField(String sortField) {
            this.sortField = sortField;
            return this;
        }

        @Override
        public final Builder sortField(SortField sortField) {
            this.sortField(sortField == null ? null : sortField.toString());
            return this;
        }

        @Override
        public Sort build() {
            return new Sort(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
