/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medicalimaging.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.medicalimaging.MedicalImagingClient;
import software.amazon.awssdk.services.medicalimaging.internal.UserAgentUtils;
import software.amazon.awssdk.services.medicalimaging.model.DatastoreSummary;
import software.amazon.awssdk.services.medicalimaging.model.ListDatastoresRequest;
import software.amazon.awssdk.services.medicalimaging.model.ListDatastoresResponse;

public class ListDatastoresIterable
implements SdkIterable<ListDatastoresResponse> {
    private final MedicalImagingClient client;
    private final ListDatastoresRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDatastoresIterable(MedicalImagingClient client, ListDatastoresRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDatastoresResponseFetcher();
    }

    public Iterator<ListDatastoresResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DatastoreSummary> datastoreSummaries() {
        Function<ListDatastoresResponse, Iterator> getIterator = response -> {
            if (response != null && response.datastoreSummaries() != null) {
                return response.datastoreSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDatastoresResponseFetcher
    implements SyncPageFetcher<ListDatastoresResponse> {
        private ListDatastoresResponseFetcher() {
        }

        public boolean hasNextPage(ListDatastoresResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDatastoresResponse nextPage(ListDatastoresResponse previousPage) {
            if (previousPage == null) {
                return ListDatastoresIterable.this.client.listDatastores(ListDatastoresIterable.this.firstRequest);
            }
            return ListDatastoresIterable.this.client.listDatastores((ListDatastoresRequest)((Object)ListDatastoresIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

