/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.memorydb.MemoryDbClient;
import software.amazon.awssdk.services.memorydb.model.DescribeParameterGroupsRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeParameterGroupsResponse;
import software.amazon.awssdk.services.memorydb.model.ParameterGroup;

public class DescribeParameterGroupsIterable
implements SdkIterable<DescribeParameterGroupsResponse> {
    private final MemoryDbClient client;
    private final DescribeParameterGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeParameterGroupsIterable(MemoryDbClient client, DescribeParameterGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeParameterGroupsResponseFetcher();
    }

    public Iterator<DescribeParameterGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ParameterGroup> parameterGroups() {
        Function<DescribeParameterGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.parameterGroups() != null) {
                return response.parameterGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeParameterGroupsResponseFetcher
    implements SyncPageFetcher<DescribeParameterGroupsResponse> {
        private DescribeParameterGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeParameterGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeParameterGroupsResponse nextPage(DescribeParameterGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeParameterGroupsIterable.this.client.describeParameterGroups(DescribeParameterGroupsIterable.this.firstRequest);
            }
            return DescribeParameterGroupsIterable.this.client.describeParameterGroups((DescribeParameterGroupsRequest)((Object)DescribeParameterGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

