/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.memorydb.MemoryDbAsyncClient;
import software.amazon.awssdk.services.memorydb.model.DescribeReservedNodesOfferingsRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeReservedNodesOfferingsResponse;
import software.amazon.awssdk.services.memorydb.model.ReservedNodesOffering;

public class DescribeReservedNodesOfferingsPublisher
implements SdkPublisher<DescribeReservedNodesOfferingsResponse> {
    private final MemoryDbAsyncClient client;
    private final DescribeReservedNodesOfferingsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeReservedNodesOfferingsPublisher(MemoryDbAsyncClient client, DescribeReservedNodesOfferingsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeReservedNodesOfferingsPublisher(MemoryDbAsyncClient client, DescribeReservedNodesOfferingsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeReservedNodesOfferingsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeReservedNodesOfferingsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ReservedNodesOffering> reservedNodesOfferings() {
        Function<DescribeReservedNodesOfferingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.reservedNodesOfferings() != null) {
                return response.reservedNodesOfferings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeReservedNodesOfferingsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeReservedNodesOfferingsResponseFetcher
    implements AsyncPageFetcher<DescribeReservedNodesOfferingsResponse> {
        private DescribeReservedNodesOfferingsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReservedNodesOfferingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeReservedNodesOfferingsResponse> nextPage(DescribeReservedNodesOfferingsResponse previousPage) {
            if (previousPage == null) {
                return DescribeReservedNodesOfferingsPublisher.this.client.describeReservedNodesOfferings(DescribeReservedNodesOfferingsPublisher.this.firstRequest);
            }
            return DescribeReservedNodesOfferingsPublisher.this.client.describeReservedNodesOfferings((DescribeReservedNodesOfferingsRequest)((Object)DescribeReservedNodesOfferingsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

