/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AZStatus {
    SINGLEAZ("singleaz"),
    MULTIAZ("multiaz"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AZStatus> VALUE_MAP;
    private final String value;

    private AZStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AZStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AZStatus> knownValues() {
        EnumSet<AZStatus> knownValues = EnumSet.allOf(AZStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AZStatus.class, AZStatus::toString);
    }
}

