/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.memorydb.MemoryDbClient;
import software.amazon.awssdk.services.memorydb.internal.UserAgentUtils;
import software.amazon.awssdk.services.memorydb.model.DescribeParametersRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeParametersResponse;
import software.amazon.awssdk.services.memorydb.model.Parameter;

public class DescribeParametersIterable
implements SdkIterable<DescribeParametersResponse> {
    private final MemoryDbClient client;
    private final DescribeParametersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeParametersIterable(MemoryDbClient client, DescribeParametersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeParametersResponseFetcher();
    }

    public Iterator<DescribeParametersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Parameter> parameters() {
        Function<DescribeParametersResponse, Iterator> getIterator = response -> {
            if (response != null && response.parameters() != null) {
                return response.parameters().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeParametersResponseFetcher
    implements SyncPageFetcher<DescribeParametersResponse> {
        private DescribeParametersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeParametersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeParametersResponse nextPage(DescribeParametersResponse previousPage) {
            if (previousPage == null) {
                return DescribeParametersIterable.this.client.describeParameters(DescribeParametersIterable.this.firstRequest);
            }
            return DescribeParametersIterable.this.client.describeParameters((DescribeParametersRequest)((Object)DescribeParametersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

