/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.memorydb.model.ClusterNameListCopier;
import software.amazon.awssdk.services.memorydb.model.MemoryDbRequest;
import software.amazon.awssdk.services.memorydb.model.ServiceUpdateRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchUpdateClusterRequest
extends MemoryDbRequest
implements ToCopyableBuilder<Builder, BatchUpdateClusterRequest> {
    private static final SdkField<List<String>> CLUSTER_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ClusterNames").getter(BatchUpdateClusterRequest.getter(BatchUpdateClusterRequest::clusterNames)).setter(BatchUpdateClusterRequest.setter(Builder::clusterNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ServiceUpdateRequest> SERVICE_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ServiceUpdate").getter(BatchUpdateClusterRequest.getter(BatchUpdateClusterRequest::serviceUpdate)).setter(BatchUpdateClusterRequest.setter(Builder::serviceUpdate)).constructor(ServiceUpdateRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceUpdate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAMES_FIELD, SERVICE_UPDATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ClusterNames", CLUSTER_NAMES_FIELD);
            this.put("ServiceUpdate", SERVICE_UPDATE_FIELD);
        }
    });
    private final List<String> clusterNames;
    private final ServiceUpdateRequest serviceUpdate;

    private BatchUpdateClusterRequest(BuilderImpl builder) {
        super(builder);
        this.clusterNames = builder.clusterNames;
        this.serviceUpdate = builder.serviceUpdate;
    }

    public final boolean hasClusterNames() {
        return this.clusterNames != null && !(this.clusterNames instanceof SdkAutoConstructList);
    }

    public final List<String> clusterNames() {
        return this.clusterNames;
    }

    public final ServiceUpdateRequest serviceUpdate() {
        return this.serviceUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClusterNames() ? this.clusterNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceUpdate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateClusterRequest)) {
            return false;
        }
        BatchUpdateClusterRequest other = (BatchUpdateClusterRequest)((Object)obj);
        return this.hasClusterNames() == other.hasClusterNames() && Objects.equals(this.clusterNames(), other.clusterNames()) && Objects.equals(this.serviceUpdate(), other.serviceUpdate());
    }

    public final String toString() {
        return ToString.builder((String)"BatchUpdateClusterRequest").add("ClusterNames", this.hasClusterNames() ? this.clusterNames() : null).add("ServiceUpdate", (Object)this.serviceUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterNames": {
                return Optional.ofNullable(clazz.cast(this.clusterNames()));
            }
            case "ServiceUpdate": {
                return Optional.ofNullable(clazz.cast(this.serviceUpdate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateClusterRequest, T> g) {
        return obj -> g.apply((BatchUpdateClusterRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MemoryDbRequest.BuilderImpl
    implements Builder {
        private List<String> clusterNames = DefaultSdkAutoConstructList.getInstance();
        private ServiceUpdateRequest serviceUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateClusterRequest model) {
            super(model);
            this.clusterNames(model.clusterNames);
            this.serviceUpdate(model.serviceUpdate);
        }

        public final Collection<String> getClusterNames() {
            if (this.clusterNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.clusterNames;
        }

        public final void setClusterNames(Collection<String> clusterNames) {
            this.clusterNames = ClusterNameListCopier.copy(clusterNames);
        }

        @Override
        public final Builder clusterNames(Collection<String> clusterNames) {
            this.clusterNames = ClusterNameListCopier.copy(clusterNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterNames(String ... clusterNames) {
            this.clusterNames(Arrays.asList(clusterNames));
            return this;
        }

        public final ServiceUpdateRequest.Builder getServiceUpdate() {
            return this.serviceUpdate != null ? this.serviceUpdate.toBuilder() : null;
        }

        public final void setServiceUpdate(ServiceUpdateRequest.BuilderImpl serviceUpdate) {
            this.serviceUpdate = serviceUpdate != null ? serviceUpdate.build() : null;
        }

        @Override
        public final Builder serviceUpdate(ServiceUpdateRequest serviceUpdate) {
            this.serviceUpdate = serviceUpdate;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchUpdateClusterRequest build() {
            return new BatchUpdateClusterRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MemoryDbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchUpdateClusterRequest> {
        public Builder clusterNames(Collection<String> var1);

        public Builder clusterNames(String ... var1);

        public Builder serviceUpdate(ServiceUpdateRequest var1);

        default public Builder serviceUpdate(Consumer<ServiceUpdateRequest.Builder> serviceUpdate) {
            return this.serviceUpdate((ServiceUpdateRequest)((ServiceUpdateRequest.Builder)ServiceUpdateRequest.builder().applyMutation(serviceUpdate)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

