/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.memorydb.model.ClusterConfiguration;
import software.amazon.awssdk.services.memorydb.model.DataTieringStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Snapshot
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Snapshot> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Snapshot.getter(Snapshot::name)).setter(Snapshot.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Snapshot.getter(Snapshot::status)).setter(Snapshot.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Source").getter(Snapshot.getter(Snapshot::source)).setter(Snapshot.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(Snapshot.getter(Snapshot::kmsKeyId)).setter(Snapshot.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ARN").getter(Snapshot.getter(Snapshot::arn)).setter(Snapshot.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()}).build();
    private static final SdkField<ClusterConfiguration> CLUSTER_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ClusterConfiguration").getter(Snapshot.getter(Snapshot::clusterConfiguration)).setter(Snapshot.setter(Builder::clusterConfiguration)).constructor(ClusterConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterConfiguration").build()}).build();
    private static final SdkField<String> DATA_TIERING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataTiering").getter(Snapshot.getter(Snapshot::dataTieringAsString)).setter(Snapshot.setter(Builder::dataTiering)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataTiering").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STATUS_FIELD, SOURCE_FIELD, KMS_KEY_ID_FIELD, ARN_FIELD, CLUSTER_CONFIGURATION_FIELD, DATA_TIERING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Name", NAME_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("Source", SOURCE_FIELD);
            this.put("KmsKeyId", KMS_KEY_ID_FIELD);
            this.put("ARN", ARN_FIELD);
            this.put("ClusterConfiguration", CLUSTER_CONFIGURATION_FIELD);
            this.put("DataTiering", DATA_TIERING_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String status;
    private final String source;
    private final String kmsKeyId;
    private final String arn;
    private final ClusterConfiguration clusterConfiguration;
    private final String dataTiering;

    private Snapshot(BuilderImpl builder) {
        this.name = builder.name;
        this.status = builder.status;
        this.source = builder.source;
        this.kmsKeyId = builder.kmsKeyId;
        this.arn = builder.arn;
        this.clusterConfiguration = builder.clusterConfiguration;
        this.dataTiering = builder.dataTiering;
    }

    public final String name() {
        return this.name;
    }

    public final String status() {
        return this.status;
    }

    public final String source() {
        return this.source;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final String arn() {
        return this.arn;
    }

    public final ClusterConfiguration clusterConfiguration() {
        return this.clusterConfiguration;
    }

    public final DataTieringStatus dataTiering() {
        return DataTieringStatus.fromValue(this.dataTiering);
    }

    public final String dataTieringAsString() {
        return this.dataTiering;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataTieringAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Snapshot)) {
            return false;
        }
        Snapshot other = (Snapshot)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.clusterConfiguration(), other.clusterConfiguration()) && Objects.equals(this.dataTieringAsString(), other.dataTieringAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Snapshot").add("Name", (Object)this.name()).add("Status", (Object)this.status()).add("Source", (Object)this.source()).add("KmsKeyId", (Object)this.kmsKeyId()).add("ARN", (Object)this.arn()).add("ClusterConfiguration", (Object)this.clusterConfiguration()).add("DataTiering", (Object)this.dataTieringAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "ARN": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "ClusterConfiguration": {
                return Optional.ofNullable(clazz.cast(this.clusterConfiguration()));
            }
            case "DataTiering": {
                return Optional.ofNullable(clazz.cast(this.dataTieringAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Snapshot, T> g) {
        return obj -> g.apply((Snapshot)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String status;
        private String source;
        private String kmsKeyId;
        private String arn;
        private ClusterConfiguration clusterConfiguration;
        private String dataTiering;

        private BuilderImpl() {
        }

        private BuilderImpl(Snapshot model) {
            this.name(model.name);
            this.status(model.status);
            this.source(model.source);
            this.kmsKeyId(model.kmsKeyId);
            this.arn(model.arn);
            this.clusterConfiguration(model.clusterConfiguration);
            this.dataTiering(model.dataTiering);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final ClusterConfiguration.Builder getClusterConfiguration() {
            return this.clusterConfiguration != null ? this.clusterConfiguration.toBuilder() : null;
        }

        public final void setClusterConfiguration(ClusterConfiguration.BuilderImpl clusterConfiguration) {
            this.clusterConfiguration = clusterConfiguration != null ? clusterConfiguration.build() : null;
        }

        @Override
        public final Builder clusterConfiguration(ClusterConfiguration clusterConfiguration) {
            this.clusterConfiguration = clusterConfiguration;
            return this;
        }

        public final String getDataTiering() {
            return this.dataTiering;
        }

        public final void setDataTiering(String dataTiering) {
            this.dataTiering = dataTiering;
        }

        @Override
        public final Builder dataTiering(String dataTiering) {
            this.dataTiering = dataTiering;
            return this;
        }

        @Override
        public final Builder dataTiering(DataTieringStatus dataTiering) {
            this.dataTiering(dataTiering == null ? null : dataTiering.toString());
            return this;
        }

        public Snapshot build() {
            return new Snapshot(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Snapshot> {
        public Builder name(String var1);

        public Builder status(String var1);

        public Builder source(String var1);

        public Builder kmsKeyId(String var1);

        public Builder arn(String var1);

        public Builder clusterConfiguration(ClusterConfiguration var1);

        default public Builder clusterConfiguration(Consumer<ClusterConfiguration.Builder> clusterConfiguration) {
            return this.clusterConfiguration((ClusterConfiguration)((ClusterConfiguration.Builder)ClusterConfiguration.builder().applyMutation(clusterConfiguration)).build());
        }

        public Builder dataTiering(String var1);

        public Builder dataTiering(DataTieringStatus var1);
    }
}

