/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.memorydb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>PurchaseReservedNodesOffering</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReservedNode implements SdkPojo, Serializable, ToCopyableBuilder<ReservedNode.Builder, ReservedNode> {
    private static final SdkField<String> RESERVATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReservationId").getter(getter(ReservedNode::reservationId)).setter(setter(Builder::reservationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservationId").build()).build();

    private static final SdkField<String> RESERVED_NODES_OFFERING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReservedNodesOfferingId").getter(getter(ReservedNode::reservedNodesOfferingId))
            .setter(setter(Builder::reservedNodesOfferingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedNodesOfferingId").build())
            .build();

    private static final SdkField<String> NODE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NodeType").getter(getter(ReservedNode::nodeType)).setter(setter(Builder::nodeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeType").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(ReservedNode::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Integer> DURATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Duration").getter(getter(ReservedNode::duration)).setter(setter(Builder::duration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()).build();

    private static final SdkField<Double> FIXED_PRICE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("FixedPrice").getter(getter(ReservedNode::fixedPrice)).setter(setter(Builder::fixedPrice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FixedPrice").build()).build();

    private static final SdkField<Integer> NODE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NodeCount").getter(getter(ReservedNode::nodeCount)).setter(setter(Builder::nodeCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeCount").build()).build();

    private static final SdkField<String> OFFERING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OfferingType").getter(getter(ReservedNode::offeringType)).setter(setter(Builder::offeringType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfferingType").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(ReservedNode::state)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<List<RecurringCharge>> RECURRING_CHARGES_FIELD = SdkField
            .<List<RecurringCharge>> builder(MarshallingType.LIST)
            .memberName("RecurringCharges")
            .getter(getter(ReservedNode::recurringCharges))
            .setter(setter(Builder::recurringCharges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecurringCharges").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RecurringCharge> builder(MarshallingType.SDK_POJO)
                                            .constructor(RecurringCharge::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ARN")
            .getter(getter(ReservedNode::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESERVATION_ID_FIELD,
            RESERVED_NODES_OFFERING_ID_FIELD, NODE_TYPE_FIELD, START_TIME_FIELD, DURATION_FIELD, FIXED_PRICE_FIELD,
            NODE_COUNT_FIELD, OFFERING_TYPE_FIELD, STATE_FIELD, RECURRING_CHARGES_FIELD, ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String reservationId;

    private final String reservedNodesOfferingId;

    private final String nodeType;

    private final Instant startTime;

    private final Integer duration;

    private final Double fixedPrice;

    private final Integer nodeCount;

    private final String offeringType;

    private final String state;

    private final List<RecurringCharge> recurringCharges;

    private final String arn;

    private ReservedNode(BuilderImpl builder) {
        this.reservationId = builder.reservationId;
        this.reservedNodesOfferingId = builder.reservedNodesOfferingId;
        this.nodeType = builder.nodeType;
        this.startTime = builder.startTime;
        this.duration = builder.duration;
        this.fixedPrice = builder.fixedPrice;
        this.nodeCount = builder.nodeCount;
        this.offeringType = builder.offeringType;
        this.state = builder.state;
        this.recurringCharges = builder.recurringCharges;
        this.arn = builder.arn;
    }

    /**
     * <p>
     * A customer-specified identifier to track this reservation.
     * </p>
     * 
     * @return A customer-specified identifier to track this reservation.
     */
    public final String reservationId() {
        return reservationId;
    }

    /**
     * <p>
     * The ID of the reserved node offering to purchase.
     * </p>
     * 
     * @return The ID of the reserved node offering to purchase.
     */
    public final String reservedNodesOfferingId() {
        return reservedNodesOfferingId;
    }

    /**
     * <p>
     * The node type for the reserved nodes.
     * </p>
     * 
     * @return The node type for the reserved nodes.
     */
    public final String nodeType() {
        return nodeType;
    }

    /**
     * <p>
     * The time the reservation started.
     * </p>
     * 
     * @return The time the reservation started.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The duration of the reservation in seconds.
     * </p>
     * 
     * @return The duration of the reservation in seconds.
     */
    public final Integer duration() {
        return duration;
    }

    /**
     * <p>
     * The fixed price charged for this reserved node.
     * </p>
     * 
     * @return The fixed price charged for this reserved node.
     */
    public final Double fixedPrice() {
        return fixedPrice;
    }

    /**
     * <p>
     * The number of nodes that have been reserved.
     * </p>
     * 
     * @return The number of nodes that have been reserved.
     */
    public final Integer nodeCount() {
        return nodeCount;
    }

    /**
     * <p>
     * The offering type of this reserved node.
     * </p>
     * 
     * @return The offering type of this reserved node.
     */
    public final String offeringType() {
        return offeringType;
    }

    /**
     * <p>
     * The state of the reserved node.
     * </p>
     * 
     * @return The state of the reserved node.
     */
    public final String state() {
        return state;
    }

    /**
     * For responses, this returns true if the service returned a value for the RecurringCharges property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRecurringCharges() {
        return recurringCharges != null && !(recurringCharges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The recurring price charged to run this reserved node.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecurringCharges} method.
     * </p>
     * 
     * @return The recurring price charged to run this reserved node.
     */
    public final List<RecurringCharge> recurringCharges() {
        return recurringCharges;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the reserved node.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the reserved node.
     */
    public final String arn() {
        return arn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(reservationId());
        hashCode = 31 * hashCode + Objects.hashCode(reservedNodesOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(nodeType());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        hashCode = 31 * hashCode + Objects.hashCode(fixedPrice());
        hashCode = 31 * hashCode + Objects.hashCode(nodeCount());
        hashCode = 31 * hashCode + Objects.hashCode(offeringType());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(hasRecurringCharges() ? recurringCharges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedNode)) {
            return false;
        }
        ReservedNode other = (ReservedNode) obj;
        return Objects.equals(reservationId(), other.reservationId())
                && Objects.equals(reservedNodesOfferingId(), other.reservedNodesOfferingId())
                && Objects.equals(nodeType(), other.nodeType()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(duration(), other.duration()) && Objects.equals(fixedPrice(), other.fixedPrice())
                && Objects.equals(nodeCount(), other.nodeCount()) && Objects.equals(offeringType(), other.offeringType())
                && Objects.equals(state(), other.state()) && hasRecurringCharges() == other.hasRecurringCharges()
                && Objects.equals(recurringCharges(), other.recurringCharges()) && Objects.equals(arn(), other.arn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReservedNode").add("ReservationId", reservationId())
                .add("ReservedNodesOfferingId", reservedNodesOfferingId()).add("NodeType", nodeType())
                .add("StartTime", startTime()).add("Duration", duration()).add("FixedPrice", fixedPrice())
                .add("NodeCount", nodeCount()).add("OfferingType", offeringType()).add("State", state())
                .add("RecurringCharges", hasRecurringCharges() ? recurringCharges() : null).add("ARN", arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReservationId":
            return Optional.ofNullable(clazz.cast(reservationId()));
        case "ReservedNodesOfferingId":
            return Optional.ofNullable(clazz.cast(reservedNodesOfferingId()));
        case "NodeType":
            return Optional.ofNullable(clazz.cast(nodeType()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "Duration":
            return Optional.ofNullable(clazz.cast(duration()));
        case "FixedPrice":
            return Optional.ofNullable(clazz.cast(fixedPrice()));
        case "NodeCount":
            return Optional.ofNullable(clazz.cast(nodeCount()));
        case "OfferingType":
            return Optional.ofNullable(clazz.cast(offeringType()));
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        case "RecurringCharges":
            return Optional.ofNullable(clazz.cast(recurringCharges()));
        case "ARN":
            return Optional.ofNullable(clazz.cast(arn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ReservationId", RESERVATION_ID_FIELD);
        map.put("ReservedNodesOfferingId", RESERVED_NODES_OFFERING_ID_FIELD);
        map.put("NodeType", NODE_TYPE_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("Duration", DURATION_FIELD);
        map.put("FixedPrice", FIXED_PRICE_FIELD);
        map.put("NodeCount", NODE_COUNT_FIELD);
        map.put("OfferingType", OFFERING_TYPE_FIELD);
        map.put("State", STATE_FIELD);
        map.put("RecurringCharges", RECURRING_CHARGES_FIELD);
        map.put("ARN", ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReservedNode, T> g) {
        return obj -> g.apply((ReservedNode) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReservedNode> {
        /**
         * <p>
         * A customer-specified identifier to track this reservation.
         * </p>
         * 
         * @param reservationId
         *        A customer-specified identifier to track this reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservationId(String reservationId);

        /**
         * <p>
         * The ID of the reserved node offering to purchase.
         * </p>
         * 
         * @param reservedNodesOfferingId
         *        The ID of the reserved node offering to purchase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedNodesOfferingId(String reservedNodesOfferingId);

        /**
         * <p>
         * The node type for the reserved nodes.
         * </p>
         * 
         * @param nodeType
         *        The node type for the reserved nodes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeType(String nodeType);

        /**
         * <p>
         * The time the reservation started.
         * </p>
         * 
         * @param startTime
         *        The time the reservation started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The duration of the reservation in seconds.
         * </p>
         * 
         * @param duration
         *        The duration of the reservation in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Integer duration);

        /**
         * <p>
         * The fixed price charged for this reserved node.
         * </p>
         * 
         * @param fixedPrice
         *        The fixed price charged for this reserved node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fixedPrice(Double fixedPrice);

        /**
         * <p>
         * The number of nodes that have been reserved.
         * </p>
         * 
         * @param nodeCount
         *        The number of nodes that have been reserved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeCount(Integer nodeCount);

        /**
         * <p>
         * The offering type of this reserved node.
         * </p>
         * 
         * @param offeringType
         *        The offering type of this reserved node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringType(String offeringType);

        /**
         * <p>
         * The state of the reserved node.
         * </p>
         * 
         * @param state
         *        The state of the reserved node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);

        /**
         * <p>
         * The recurring price charged to run this reserved node.
         * </p>
         * 
         * @param recurringCharges
         *        The recurring price charged to run this reserved node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recurringCharges(Collection<RecurringCharge> recurringCharges);

        /**
         * <p>
         * The recurring price charged to run this reserved node.
         * </p>
         * 
         * @param recurringCharges
         *        The recurring price charged to run this reserved node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recurringCharges(RecurringCharge... recurringCharges);

        /**
         * <p>
         * The recurring price charged to run this reserved node.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.memorydb.model.RecurringCharge.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.memorydb.model.RecurringCharge#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.memorydb.model.RecurringCharge.Builder#build()} is called immediately
         * and its result is passed to {@link #recurringCharges(List<RecurringCharge>)}.
         * 
         * @param recurringCharges
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.memorydb.model.RecurringCharge.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recurringCharges(java.util.Collection<RecurringCharge>)
         */
        Builder recurringCharges(Consumer<RecurringCharge.Builder>... recurringCharges);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the reserved node.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the reserved node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);
    }

    static final class BuilderImpl implements Builder {
        private String reservationId;

        private String reservedNodesOfferingId;

        private String nodeType;

        private Instant startTime;

        private Integer duration;

        private Double fixedPrice;

        private Integer nodeCount;

        private String offeringType;

        private String state;

        private List<RecurringCharge> recurringCharges = DefaultSdkAutoConstructList.getInstance();

        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedNode model) {
            reservationId(model.reservationId);
            reservedNodesOfferingId(model.reservedNodesOfferingId);
            nodeType(model.nodeType);
            startTime(model.startTime);
            duration(model.duration);
            fixedPrice(model.fixedPrice);
            nodeCount(model.nodeCount);
            offeringType(model.offeringType);
            state(model.state);
            recurringCharges(model.recurringCharges);
            arn(model.arn);
        }

        public final String getReservationId() {
            return reservationId;
        }

        public final void setReservationId(String reservationId) {
            this.reservationId = reservationId;
        }

        @Override
        public final Builder reservationId(String reservationId) {
            this.reservationId = reservationId;
            return this;
        }

        public final String getReservedNodesOfferingId() {
            return reservedNodesOfferingId;
        }

        public final void setReservedNodesOfferingId(String reservedNodesOfferingId) {
            this.reservedNodesOfferingId = reservedNodesOfferingId;
        }

        @Override
        public final Builder reservedNodesOfferingId(String reservedNodesOfferingId) {
            this.reservedNodesOfferingId = reservedNodesOfferingId;
            return this;
        }

        public final String getNodeType() {
            return nodeType;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Integer getDuration() {
            return duration;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final Double getFixedPrice() {
            return fixedPrice;
        }

        public final void setFixedPrice(Double fixedPrice) {
            this.fixedPrice = fixedPrice;
        }

        @Override
        public final Builder fixedPrice(Double fixedPrice) {
            this.fixedPrice = fixedPrice;
            return this;
        }

        public final Integer getNodeCount() {
            return nodeCount;
        }

        public final void setNodeCount(Integer nodeCount) {
            this.nodeCount = nodeCount;
        }

        @Override
        public final Builder nodeCount(Integer nodeCount) {
            this.nodeCount = nodeCount;
            return this;
        }

        public final String getOfferingType() {
            return offeringType;
        }

        public final void setOfferingType(String offeringType) {
            this.offeringType = offeringType;
        }

        @Override
        public final Builder offeringType(String offeringType) {
            this.offeringType = offeringType;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final List<RecurringCharge.Builder> getRecurringCharges() {
            List<RecurringCharge.Builder> result = RecurringChargeListCopier.copyToBuilder(this.recurringCharges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecurringCharges(Collection<RecurringCharge.BuilderImpl> recurringCharges) {
            this.recurringCharges = RecurringChargeListCopier.copyFromBuilder(recurringCharges);
        }

        @Override
        public final Builder recurringCharges(Collection<RecurringCharge> recurringCharges) {
            this.recurringCharges = RecurringChargeListCopier.copy(recurringCharges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recurringCharges(RecurringCharge... recurringCharges) {
            recurringCharges(Arrays.asList(recurringCharges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recurringCharges(Consumer<RecurringCharge.Builder>... recurringCharges) {
            recurringCharges(Stream.of(recurringCharges).map(c -> RecurringCharge.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        @Override
        public ReservedNode build() {
            return new ReservedNode(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
