/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.memorydb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Shard configuration options. Each shard configuration has the following: Slots and ReplicaCount.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ShardConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ShardConfiguration.Builder, ShardConfiguration> {
    private static final SdkField<String> SLOTS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Slots")
            .getter(getter(ShardConfiguration::slots)).setter(setter(Builder::slots))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Slots").build()).build();

    private static final SdkField<Integer> REPLICA_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ReplicaCount").getter(getter(ShardConfiguration::replicaCount)).setter(setter(Builder::replicaCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SLOTS_FIELD,
            REPLICA_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String slots;

    private final Integer replicaCount;

    private ShardConfiguration(BuilderImpl builder) {
        this.slots = builder.slots;
        this.replicaCount = builder.replicaCount;
    }

    /**
     * <p>
     * A string that specifies the keyspace for a particular node group. Keyspaces range from 0 to 16,383. The string is
     * in the format startkey-endkey.
     * </p>
     * 
     * @return A string that specifies the keyspace for a particular node group. Keyspaces range from 0 to 16,383. The
     *         string is in the format startkey-endkey.
     */
    public final String slots() {
        return slots;
    }

    /**
     * <p>
     * The number of read replica nodes in this shard.
     * </p>
     * 
     * @return The number of read replica nodes in this shard.
     */
    public final Integer replicaCount() {
        return replicaCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(slots());
        hashCode = 31 * hashCode + Objects.hashCode(replicaCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ShardConfiguration)) {
            return false;
        }
        ShardConfiguration other = (ShardConfiguration) obj;
        return Objects.equals(slots(), other.slots()) && Objects.equals(replicaCount(), other.replicaCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ShardConfiguration").add("Slots", slots()).add("ReplicaCount", replicaCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Slots":
            return Optional.ofNullable(clazz.cast(slots()));
        case "ReplicaCount":
            return Optional.ofNullable(clazz.cast(replicaCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Slots", SLOTS_FIELD);
        map.put("ReplicaCount", REPLICA_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ShardConfiguration, T> g) {
        return obj -> g.apply((ShardConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ShardConfiguration> {
        /**
         * <p>
         * A string that specifies the keyspace for a particular node group. Keyspaces range from 0 to 16,383. The
         * string is in the format startkey-endkey.
         * </p>
         * 
         * @param slots
         *        A string that specifies the keyspace for a particular node group. Keyspaces range from 0 to 16,383.
         *        The string is in the format startkey-endkey.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slots(String slots);

        /**
         * <p>
         * The number of read replica nodes in this shard.
         * </p>
         * 
         * @param replicaCount
         *        The number of read replica nodes in this shard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaCount(Integer replicaCount);
    }

    static final class BuilderImpl implements Builder {
        private String slots;

        private Integer replicaCount;

        private BuilderImpl() {
        }

        private BuilderImpl(ShardConfiguration model) {
            slots(model.slots);
            replicaCount(model.replicaCount);
        }

        public final String getSlots() {
            return slots;
        }

        public final void setSlots(String slots) {
            this.slots = slots;
        }

        @Override
        public final Builder slots(String slots) {
            this.slots = slots;
            return this;
        }

        public final Integer getReplicaCount() {
            return replicaCount;
        }

        public final void setReplicaCount(Integer replicaCount) {
            this.replicaCount = replicaCount;
        }

        @Override
        public final Builder replicaCount(Integer replicaCount) {
            this.replicaCount = replicaCount;
            return this;
        }

        @Override
        public ShardConfiguration build() {
            return new ShardConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
