/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.memorydb.model.MemoryDbResponse;
import software.amazon.awssdk.services.memorydb.model.ReservedNodesOffering;
import software.amazon.awssdk.services.memorydb.model.ReservedNodesOfferingListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeReservedNodesOfferingsResponse
extends MemoryDbResponse
implements ToCopyableBuilder<Builder, DescribeReservedNodesOfferingsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeReservedNodesOfferingsResponse.getter(DescribeReservedNodesOfferingsResponse::nextToken)).setter(DescribeReservedNodesOfferingsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<ReservedNodesOffering>> RESERVED_NODES_OFFERINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReservedNodesOfferings").getter(DescribeReservedNodesOfferingsResponse.getter(DescribeReservedNodesOfferingsResponse::reservedNodesOfferings)).setter(DescribeReservedNodesOfferingsResponse.setter(Builder::reservedNodesOfferings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedNodesOfferings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReservedNodesOffering::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, RESERVED_NODES_OFFERINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeReservedNodesOfferingsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<ReservedNodesOffering> reservedNodesOfferings;

    private DescribeReservedNodesOfferingsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.reservedNodesOfferings = builder.reservedNodesOfferings;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasReservedNodesOfferings() {
        return this.reservedNodesOfferings != null && !(this.reservedNodesOfferings instanceof SdkAutoConstructList);
    }

    public final List<ReservedNodesOffering> reservedNodesOfferings() {
        return this.reservedNodesOfferings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReservedNodesOfferings() ? this.reservedNodesOfferings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedNodesOfferingsResponse)) {
            return false;
        }
        DescribeReservedNodesOfferingsResponse other = (DescribeReservedNodesOfferingsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasReservedNodesOfferings() == other.hasReservedNodesOfferings() && Objects.equals(this.reservedNodesOfferings(), other.reservedNodesOfferings());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeReservedNodesOfferingsResponse").add("NextToken", (Object)this.nextToken()).add("ReservedNodesOfferings", this.hasReservedNodesOfferings() ? this.reservedNodesOfferings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ReservedNodesOfferings": {
                return Optional.ofNullable(clazz.cast(this.reservedNodesOfferings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("ReservedNodesOfferings", RESERVED_NODES_OFFERINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeReservedNodesOfferingsResponse, T> g) {
        return obj -> g.apply((DescribeReservedNodesOfferingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MemoryDbResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ReservedNodesOffering> reservedNodesOfferings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedNodesOfferingsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.reservedNodesOfferings(model.reservedNodesOfferings);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ReservedNodesOffering.Builder> getReservedNodesOfferings() {
            List<ReservedNodesOffering.Builder> result = ReservedNodesOfferingListCopier.copyToBuilder(this.reservedNodesOfferings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReservedNodesOfferings(Collection<ReservedNodesOffering.BuilderImpl> reservedNodesOfferings) {
            this.reservedNodesOfferings = ReservedNodesOfferingListCopier.copyFromBuilder(reservedNodesOfferings);
        }

        @Override
        public final Builder reservedNodesOfferings(Collection<ReservedNodesOffering> reservedNodesOfferings) {
            this.reservedNodesOfferings = ReservedNodesOfferingListCopier.copy(reservedNodesOfferings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedNodesOfferings(ReservedNodesOffering ... reservedNodesOfferings) {
            this.reservedNodesOfferings(Arrays.asList(reservedNodesOfferings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedNodesOfferings(Consumer<ReservedNodesOffering.Builder> ... reservedNodesOfferings) {
            this.reservedNodesOfferings(Stream.of(reservedNodesOfferings).map(c -> (ReservedNodesOffering)((ReservedNodesOffering.Builder)ReservedNodesOffering.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeReservedNodesOfferingsResponse build() {
            return new DescribeReservedNodesOfferingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MemoryDbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeReservedNodesOfferingsResponse> {
        public Builder nextToken(String var1);

        public Builder reservedNodesOfferings(Collection<ReservedNodesOffering> var1);

        public Builder reservedNodesOfferings(ReservedNodesOffering ... var1);

        public Builder reservedNodesOfferings(Consumer<ReservedNodesOffering.Builder> ... var1);
    }
}

