/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mq.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns information about all brokers.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BrokerInstance implements SdkPojo, Serializable, ToCopyableBuilder<BrokerInstance.Builder, BrokerInstance> {
    private static final SdkField<String> CONSOLE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConsoleURL").getter(getter(BrokerInstance::consoleURL)).setter(setter(Builder::consoleURL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("consoleURL").build()).build();

    private static final SdkField<List<String>> ENDPOINTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Endpoints")
            .getter(getter(BrokerInstance::endpoints))
            .setter(setter(Builder::endpoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IpAddress").getter(getter(BrokerInstance::ipAddress)).setter(setter(Builder::ipAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAddress").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSOLE_URL_FIELD,
            ENDPOINTS_FIELD, IP_ADDRESS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String consoleURL;

    private final List<String> endpoints;

    private final String ipAddress;

    private BrokerInstance(BuilderImpl builder) {
        this.consoleURL = builder.consoleURL;
        this.endpoints = builder.endpoints;
        this.ipAddress = builder.ipAddress;
    }

    /**
     * <p>
     * The brokers web console URL.
     * </p>
     * 
     * @return The brokers web console URL.
     */
    public final String consoleURL() {
        return consoleURL;
    }

    /**
     * For responses, this returns true if the service returned a value for the Endpoints property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEndpoints() {
        return endpoints != null && !(endpoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The broker's wire-level protocol endpoints.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEndpoints} method.
     * </p>
     * 
     * @return The broker's wire-level protocol endpoints.
     */
    public final List<String> endpoints() {
        return endpoints;
    }

    /**
     * <p>
     * The IP address of the Elastic Network Interface (ENI) attached to the broker. Does not apply to RabbitMQ brokers.
     * </p>
     * 
     * @return The IP address of the Elastic Network Interface (ENI) attached to the broker. Does not apply to RabbitMQ
     *         brokers.
     */
    public final String ipAddress() {
        return ipAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(consoleURL());
        hashCode = 31 * hashCode + Objects.hashCode(hasEndpoints() ? endpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ipAddress());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BrokerInstance)) {
            return false;
        }
        BrokerInstance other = (BrokerInstance) obj;
        return Objects.equals(consoleURL(), other.consoleURL()) && hasEndpoints() == other.hasEndpoints()
                && Objects.equals(endpoints(), other.endpoints()) && Objects.equals(ipAddress(), other.ipAddress());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BrokerInstance").add("ConsoleURL", consoleURL())
                .add("Endpoints", hasEndpoints() ? endpoints() : null).add("IpAddress", ipAddress()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConsoleURL":
            return Optional.ofNullable(clazz.cast(consoleURL()));
        case "Endpoints":
            return Optional.ofNullable(clazz.cast(endpoints()));
        case "IpAddress":
            return Optional.ofNullable(clazz.cast(ipAddress()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("consoleURL", CONSOLE_URL_FIELD);
        map.put("endpoints", ENDPOINTS_FIELD);
        map.put("ipAddress", IP_ADDRESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BrokerInstance, T> g) {
        return obj -> g.apply((BrokerInstance) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BrokerInstance> {
        /**
         * <p>
         * The brokers web console URL.
         * </p>
         * 
         * @param consoleURL
         *        The brokers web console URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consoleURL(String consoleURL);

        /**
         * <p>
         * The broker's wire-level protocol endpoints.
         * </p>
         * 
         * @param endpoints
         *        The broker's wire-level protocol endpoints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoints(Collection<String> endpoints);

        /**
         * <p>
         * The broker's wire-level protocol endpoints.
         * </p>
         * 
         * @param endpoints
         *        The broker's wire-level protocol endpoints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoints(String... endpoints);

        /**
         * <p>
         * The IP address of the Elastic Network Interface (ENI) attached to the broker. Does not apply to RabbitMQ
         * brokers.
         * </p>
         * 
         * @param ipAddress
         *        The IP address of the Elastic Network Interface (ENI) attached to the broker. Does not apply to
         *        RabbitMQ brokers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddress(String ipAddress);
    }

    static final class BuilderImpl implements Builder {
        private String consoleURL;

        private List<String> endpoints = DefaultSdkAutoConstructList.getInstance();

        private String ipAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(BrokerInstance model) {
            consoleURL(model.consoleURL);
            endpoints(model.endpoints);
            ipAddress(model.ipAddress);
        }

        public final String getConsoleURL() {
            return consoleURL;
        }

        public final void setConsoleURL(String consoleURL) {
            this.consoleURL = consoleURL;
        }

        @Override
        public final Builder consoleURL(String consoleURL) {
            this.consoleURL = consoleURL;
            return this;
        }

        public final Collection<String> getEndpoints() {
            if (endpoints instanceof SdkAutoConstructList) {
                return null;
            }
            return endpoints;
        }

        public final void setEndpoints(Collection<String> endpoints) {
            this.endpoints = ___listOf__stringCopier.copy(endpoints);
        }

        @Override
        public final Builder endpoints(Collection<String> endpoints) {
            this.endpoints = ___listOf__stringCopier.copy(endpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(String... endpoints) {
            endpoints(Arrays.asList(endpoints));
            return this;
        }

        public final String getIpAddress() {
            return ipAddress;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        @Override
        public BrokerInstance build() {
            return new BrokerInstance(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
