/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mq.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns information about the status of the changes pending for the ActiveMQ user.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserPendingChanges implements SdkPojo, Serializable,
        ToCopyableBuilder<UserPendingChanges.Builder, UserPendingChanges> {
    private static final SdkField<Boolean> CONSOLE_ACCESS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ConsoleAccess").getter(getter(UserPendingChanges::consoleAccess)).setter(setter(Builder::consoleAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("consoleAccess").build()).build();

    private static final SdkField<List<String>> GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Groups")
            .getter(getter(UserPendingChanges::groups))
            .setter(setter(Builder::groups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PENDING_CHANGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PendingChange").getter(getter(UserPendingChanges::pendingChangeAsString))
            .setter(setter(Builder::pendingChange))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingChange").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSOLE_ACCESS_FIELD,
            GROUPS_FIELD, PENDING_CHANGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean consoleAccess;

    private final List<String> groups;

    private final String pendingChange;

    private UserPendingChanges(BuilderImpl builder) {
        this.consoleAccess = builder.consoleAccess;
        this.groups = builder.groups;
        this.pendingChange = builder.pendingChange;
    }

    /**
     * <p>
     * Enables access to the the ActiveMQ Web Console for the ActiveMQ user.
     * </p>
     * 
     * @return Enables access to the the ActiveMQ Web Console for the ActiveMQ user.
     */
    public final Boolean consoleAccess() {
        return consoleAccess;
    }

    /**
     * For responses, this returns true if the service returned a value for the Groups property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasGroups() {
        return groups != null && !(groups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only alphanumeric
     * characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroups} method.
     * </p>
     * 
     * @return The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only
     *         alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100
     *         characters long.
     */
    public final List<String> groups() {
        return groups;
    }

    /**
     * <p>
     * Required. The type of change pending for the ActiveMQ user.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pendingChange}
     * will return {@link ChangeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pendingChangeAsString}.
     * </p>
     * 
     * @return Required. The type of change pending for the ActiveMQ user.
     * @see ChangeType
     */
    public final ChangeType pendingChange() {
        return ChangeType.fromValue(pendingChange);
    }

    /**
     * <p>
     * Required. The type of change pending for the ActiveMQ user.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pendingChange}
     * will return {@link ChangeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pendingChangeAsString}.
     * </p>
     * 
     * @return Required. The type of change pending for the ActiveMQ user.
     * @see ChangeType
     */
    public final String pendingChangeAsString() {
        return pendingChange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(consoleAccess());
        hashCode = 31 * hashCode + Objects.hashCode(hasGroups() ? groups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(pendingChangeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserPendingChanges)) {
            return false;
        }
        UserPendingChanges other = (UserPendingChanges) obj;
        return Objects.equals(consoleAccess(), other.consoleAccess()) && hasGroups() == other.hasGroups()
                && Objects.equals(groups(), other.groups())
                && Objects.equals(pendingChangeAsString(), other.pendingChangeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UserPendingChanges").add("ConsoleAccess", consoleAccess())
                .add("Groups", hasGroups() ? groups() : null).add("PendingChange", pendingChangeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConsoleAccess":
            return Optional.ofNullable(clazz.cast(consoleAccess()));
        case "Groups":
            return Optional.ofNullable(clazz.cast(groups()));
        case "PendingChange":
            return Optional.ofNullable(clazz.cast(pendingChangeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("consoleAccess", CONSOLE_ACCESS_FIELD);
        map.put("groups", GROUPS_FIELD);
        map.put("pendingChange", PENDING_CHANGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UserPendingChanges, T> g) {
        return obj -> g.apply((UserPendingChanges) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserPendingChanges> {
        /**
         * <p>
         * Enables access to the the ActiveMQ Web Console for the ActiveMQ user.
         * </p>
         * 
         * @param consoleAccess
         *        Enables access to the the ActiveMQ Web Console for the ActiveMQ user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consoleAccess(Boolean consoleAccess);

        /**
         * <p>
         * The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only alphanumeric
         * characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.
         * </p>
         * 
         * @param groups
         *        The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only
         *        alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100
         *        characters long.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(Collection<String> groups);

        /**
         * <p>
         * The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only alphanumeric
         * characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.
         * </p>
         * 
         * @param groups
         *        The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only
         *        alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100
         *        characters long.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(String... groups);

        /**
         * <p>
         * Required. The type of change pending for the ActiveMQ user.
         * </p>
         * 
         * @param pendingChange
         *        Required. The type of change pending for the ActiveMQ user.
         * @see ChangeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeType
         */
        Builder pendingChange(String pendingChange);

        /**
         * <p>
         * Required. The type of change pending for the ActiveMQ user.
         * </p>
         * 
         * @param pendingChange
         *        Required. The type of change pending for the ActiveMQ user.
         * @see ChangeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeType
         */
        Builder pendingChange(ChangeType pendingChange);
    }

    static final class BuilderImpl implements Builder {
        private Boolean consoleAccess;

        private List<String> groups = DefaultSdkAutoConstructList.getInstance();

        private String pendingChange;

        private BuilderImpl() {
        }

        private BuilderImpl(UserPendingChanges model) {
            consoleAccess(model.consoleAccess);
            groups(model.groups);
            pendingChange(model.pendingChange);
        }

        public final Boolean getConsoleAccess() {
            return consoleAccess;
        }

        public final void setConsoleAccess(Boolean consoleAccess) {
            this.consoleAccess = consoleAccess;
        }

        @Override
        public final Builder consoleAccess(Boolean consoleAccess) {
            this.consoleAccess = consoleAccess;
            return this;
        }

        public final Collection<String> getGroups() {
            if (groups instanceof SdkAutoConstructList) {
                return null;
            }
            return groups;
        }

        public final void setGroups(Collection<String> groups) {
            this.groups = ___listOf__stringCopier.copy(groups);
        }

        @Override
        public final Builder groups(Collection<String> groups) {
            this.groups = ___listOf__stringCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(String... groups) {
            groups(Arrays.asList(groups));
            return this;
        }

        public final String getPendingChange() {
            return pendingChange;
        }

        public final void setPendingChange(String pendingChange) {
            this.pendingChange = pendingChange;
        }

        @Override
        public final Builder pendingChange(String pendingChange) {
            this.pendingChange = pendingChange;
            return this;
        }

        @Override
        public final Builder pendingChange(ChangeType pendingChange) {
            this.pendingChange(pendingChange == null ? null : pendingChange.toString());
            return this;
        }

        @Override
        public UserPendingChanges build() {
            return new UserPendingChanges(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
