/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateQualificationTypeResponse extends MTurkResponse implements
        ToCopyableBuilder<CreateQualificationTypeResponse.Builder, CreateQualificationTypeResponse> {
    private static final SdkField<QualificationType> QUALIFICATION_TYPE_FIELD = SdkField
            .<QualificationType> builder(MarshallingType.SDK_POJO).memberName("QualificationType")
            .getter(getter(CreateQualificationTypeResponse::qualificationType)).setter(setter(Builder::qualificationType))
            .constructor(QualificationType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QualificationType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUALIFICATION_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final QualificationType qualificationType;

    private CreateQualificationTypeResponse(BuilderImpl builder) {
        super(builder);
        this.qualificationType = builder.qualificationType;
    }

    /**
     * <p>
     * The created Qualification type, returned as a QualificationType data structure.
     * </p>
     * 
     * @return The created Qualification type, returned as a QualificationType data structure.
     */
    public final QualificationType qualificationType() {
        return qualificationType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(qualificationType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateQualificationTypeResponse)) {
            return false;
        }
        CreateQualificationTypeResponse other = (CreateQualificationTypeResponse) obj;
        return Objects.equals(qualificationType(), other.qualificationType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateQualificationTypeResponse").add("QualificationType", qualificationType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QualificationType":
            return Optional.ofNullable(clazz.cast(qualificationType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("QualificationType", QUALIFICATION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateQualificationTypeResponse, T> g) {
        return obj -> g.apply((CreateQualificationTypeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MTurkResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateQualificationTypeResponse> {
        /**
         * <p>
         * The created Qualification type, returned as a QualificationType data structure.
         * </p>
         * 
         * @param qualificationType
         *        The created Qualification type, returned as a QualificationType data structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qualificationType(QualificationType qualificationType);

        /**
         * <p>
         * The created Qualification type, returned as a QualificationType data structure.
         * </p>
         * This is a convenience method that creates an instance of the {@link QualificationType.Builder} avoiding the
         * need to create one manually via {@link QualificationType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QualificationType.Builder#build()} is called immediately and its
         * result is passed to {@link #qualificationType(QualificationType)}.
         * 
         * @param qualificationType
         *        a consumer that will call methods on {@link QualificationType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #qualificationType(QualificationType)
         */
        default Builder qualificationType(Consumer<QualificationType.Builder> qualificationType) {
            return qualificationType(QualificationType.builder().applyMutation(qualificationType).build());
        }
    }

    static final class BuilderImpl extends MTurkResponse.BuilderImpl implements Builder {
        private QualificationType qualificationType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateQualificationTypeResponse model) {
            super(model);
            qualificationType(model.qualificationType);
        }

        public final QualificationType.Builder getQualificationType() {
            return qualificationType != null ? qualificationType.toBuilder() : null;
        }

        public final void setQualificationType(QualificationType.BuilderImpl qualificationType) {
            this.qualificationType = qualificationType != null ? qualificationType.build() : null;
        }

        @Override
        public final Builder qualificationType(QualificationType qualificationType) {
            this.qualificationType = qualificationType;
            return this;
        }

        @Override
        public CreateQualificationTypeResponse build() {
            return new CreateQualificationTypeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
