/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptune.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the details of an Amazon Neptune DB parameter group.
 * </p>
 * <p>
 * This data type is used as a response element in the <a>DescribeDBParameterGroups</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DBParameterGroup implements SdkPojo, Serializable,
        ToCopyableBuilder<DBParameterGroup.Builder, DBParameterGroup> {
    private static final SdkField<String> DB_PARAMETER_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBParameterGroupName").getter(getter(DBParameterGroup::dbParameterGroupName))
            .setter(setter(Builder::dbParameterGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBParameterGroupName").build())
            .build();

    private static final SdkField<String> DB_PARAMETER_GROUP_FAMILY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBParameterGroupFamily").getter(getter(DBParameterGroup::dbParameterGroupFamily))
            .setter(setter(Builder::dbParameterGroupFamily))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBParameterGroupFamily").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DBParameterGroup::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> DB_PARAMETER_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBParameterGroupArn").getter(getter(DBParameterGroup::dbParameterGroupArn))
            .setter(setter(Builder::dbParameterGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBParameterGroupArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_PARAMETER_GROUP_NAME_FIELD,
            DB_PARAMETER_GROUP_FAMILY_FIELD, DESCRIPTION_FIELD, DB_PARAMETER_GROUP_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String dbParameterGroupName;

    private final String dbParameterGroupFamily;

    private final String description;

    private final String dbParameterGroupArn;

    private DBParameterGroup(BuilderImpl builder) {
        this.dbParameterGroupName = builder.dbParameterGroupName;
        this.dbParameterGroupFamily = builder.dbParameterGroupFamily;
        this.description = builder.description;
        this.dbParameterGroupArn = builder.dbParameterGroupArn;
    }

    /**
     * <p>
     * Provides the name of the DB parameter group.
     * </p>
     * 
     * @return Provides the name of the DB parameter group.
     */
    public final String dbParameterGroupName() {
        return dbParameterGroupName;
    }

    /**
     * <p>
     * Provides the name of the DB parameter group family that this DB parameter group is compatible with.
     * </p>
     * 
     * @return Provides the name of the DB parameter group family that this DB parameter group is compatible with.
     */
    public final String dbParameterGroupFamily() {
        return dbParameterGroupFamily;
    }

    /**
     * <p>
     * Provides the customer-specified description for this DB parameter group.
     * </p>
     * 
     * @return Provides the customer-specified description for this DB parameter group.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the DB parameter group.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the DB parameter group.
     */
    public final String dbParameterGroupArn() {
        return dbParameterGroupArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dbParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(dbParameterGroupFamily());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(dbParameterGroupArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBParameterGroup)) {
            return false;
        }
        DBParameterGroup other = (DBParameterGroup) obj;
        return Objects.equals(dbParameterGroupName(), other.dbParameterGroupName())
                && Objects.equals(dbParameterGroupFamily(), other.dbParameterGroupFamily())
                && Objects.equals(description(), other.description())
                && Objects.equals(dbParameterGroupArn(), other.dbParameterGroupArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DBParameterGroup").add("DBParameterGroupName", dbParameterGroupName())
                .add("DBParameterGroupFamily", dbParameterGroupFamily()).add("Description", description())
                .add("DBParameterGroupArn", dbParameterGroupArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBParameterGroupName":
            return Optional.ofNullable(clazz.cast(dbParameterGroupName()));
        case "DBParameterGroupFamily":
            return Optional.ofNullable(clazz.cast(dbParameterGroupFamily()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DBParameterGroupArn":
            return Optional.ofNullable(clazz.cast(dbParameterGroupArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DBParameterGroupName", DB_PARAMETER_GROUP_NAME_FIELD);
        map.put("DBParameterGroupFamily", DB_PARAMETER_GROUP_FAMILY_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("DBParameterGroupArn", DB_PARAMETER_GROUP_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DBParameterGroup, T> g) {
        return obj -> g.apply((DBParameterGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DBParameterGroup> {
        /**
         * <p>
         * Provides the name of the DB parameter group.
         * </p>
         * 
         * @param dbParameterGroupName
         *        Provides the name of the DB parameter group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbParameterGroupName(String dbParameterGroupName);

        /**
         * <p>
         * Provides the name of the DB parameter group family that this DB parameter group is compatible with.
         * </p>
         * 
         * @param dbParameterGroupFamily
         *        Provides the name of the DB parameter group family that this DB parameter group is compatible with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbParameterGroupFamily(String dbParameterGroupFamily);

        /**
         * <p>
         * Provides the customer-specified description for this DB parameter group.
         * </p>
         * 
         * @param description
         *        Provides the customer-specified description for this DB parameter group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the DB parameter group.
         * </p>
         * 
         * @param dbParameterGroupArn
         *        The Amazon Resource Name (ARN) for the DB parameter group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbParameterGroupArn(String dbParameterGroupArn);
    }

    static final class BuilderImpl implements Builder {
        private String dbParameterGroupName;

        private String dbParameterGroupFamily;

        private String description;

        private String dbParameterGroupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DBParameterGroup model) {
            dbParameterGroupName(model.dbParameterGroupName);
            dbParameterGroupFamily(model.dbParameterGroupFamily);
            description(model.description);
            dbParameterGroupArn(model.dbParameterGroupArn);
        }

        public final String getDbParameterGroupName() {
            return dbParameterGroupName;
        }

        public final void setDbParameterGroupName(String dbParameterGroupName) {
            this.dbParameterGroupName = dbParameterGroupName;
        }

        @Override
        public final Builder dbParameterGroupName(String dbParameterGroupName) {
            this.dbParameterGroupName = dbParameterGroupName;
            return this;
        }

        public final String getDbParameterGroupFamily() {
            return dbParameterGroupFamily;
        }

        public final void setDbParameterGroupFamily(String dbParameterGroupFamily) {
            this.dbParameterGroupFamily = dbParameterGroupFamily;
        }

        @Override
        public final Builder dbParameterGroupFamily(String dbParameterGroupFamily) {
            this.dbParameterGroupFamily = dbParameterGroupFamily;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDbParameterGroupArn() {
            return dbParameterGroupArn;
        }

        public final void setDbParameterGroupArn(String dbParameterGroupArn) {
            this.dbParameterGroupArn = dbParameterGroupArn;
        }

        @Override
        public final Builder dbParameterGroupArn(String dbParameterGroupArn) {
            this.dbParameterGroupArn = dbParameterGroupArn;
            return this;
        }

        @Override
        public DBParameterGroup build() {
            return new DBParameterGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
