/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkfirewall.NetworkFirewallAsyncClient;
import software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsResponse;
import software.amazon.awssdk.services.networkfirewall.model.RuleGroupMetadata;

public class ListRuleGroupsPublisher
implements SdkPublisher<ListRuleGroupsResponse> {
    private final NetworkFirewallAsyncClient client;
    private final ListRuleGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRuleGroupsPublisher(NetworkFirewallAsyncClient client, ListRuleGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRuleGroupsPublisher(NetworkFirewallAsyncClient client, ListRuleGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRuleGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRuleGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RuleGroupMetadata> ruleGroups() {
        Function<ListRuleGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.ruleGroups() != null) {
                return response.ruleGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRuleGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRuleGroupsResponseFetcher
    implements AsyncPageFetcher<ListRuleGroupsResponse> {
        private ListRuleGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListRuleGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRuleGroupsResponse> nextPage(ListRuleGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListRuleGroupsPublisher.this.client.listRuleGroups(ListRuleGroupsPublisher.this.firstRequest);
            }
            return ListRuleGroupsPublisher.this.client.listRuleGroups((ListRuleGroupsRequest)((Object)ListRuleGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

