/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkfirewall.model.CustomAction;
import software.amazon.awssdk.services.networkfirewall.model.CustomActionsCopier;
import software.amazon.awssdk.services.networkfirewall.model.PolicyVariables;
import software.amazon.awssdk.services.networkfirewall.model.StatefulActionsCopier;
import software.amazon.awssdk.services.networkfirewall.model.StatefulEngineOptions;
import software.amazon.awssdk.services.networkfirewall.model.StatefulRuleGroupReference;
import software.amazon.awssdk.services.networkfirewall.model.StatefulRuleGroupReferencesCopier;
import software.amazon.awssdk.services.networkfirewall.model.StatelessActionsCopier;
import software.amazon.awssdk.services.networkfirewall.model.StatelessRuleGroupReference;
import software.amazon.awssdk.services.networkfirewall.model.StatelessRuleGroupReferencesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FirewallPolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FirewallPolicy> {
    private static final SdkField<List<StatelessRuleGroupReference>> STATELESS_RULE_GROUP_REFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StatelessRuleGroupReferences").getter(FirewallPolicy.getter(FirewallPolicy::statelessRuleGroupReferences)).setter(FirewallPolicy.setter(Builder::statelessRuleGroupReferences)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatelessRuleGroupReferences").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StatelessRuleGroupReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> STATELESS_DEFAULT_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StatelessDefaultActions").getter(FirewallPolicy.getter(FirewallPolicy::statelessDefaultActions)).setter(FirewallPolicy.setter(Builder::statelessDefaultActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatelessDefaultActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> STATELESS_FRAGMENT_DEFAULT_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StatelessFragmentDefaultActions").getter(FirewallPolicy.getter(FirewallPolicy::statelessFragmentDefaultActions)).setter(FirewallPolicy.setter(Builder::statelessFragmentDefaultActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatelessFragmentDefaultActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CustomAction>> STATELESS_CUSTOM_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StatelessCustomActions").getter(FirewallPolicy.getter(FirewallPolicy::statelessCustomActions)).setter(FirewallPolicy.setter(Builder::statelessCustomActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatelessCustomActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CustomAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<StatefulRuleGroupReference>> STATEFUL_RULE_GROUP_REFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StatefulRuleGroupReferences").getter(FirewallPolicy.getter(FirewallPolicy::statefulRuleGroupReferences)).setter(FirewallPolicy.setter(Builder::statefulRuleGroupReferences)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatefulRuleGroupReferences").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StatefulRuleGroupReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> STATEFUL_DEFAULT_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StatefulDefaultActions").getter(FirewallPolicy.getter(FirewallPolicy::statefulDefaultActions)).setter(FirewallPolicy.setter(Builder::statefulDefaultActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatefulDefaultActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<StatefulEngineOptions> STATEFUL_ENGINE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StatefulEngineOptions").getter(FirewallPolicy.getter(FirewallPolicy::statefulEngineOptions)).setter(FirewallPolicy.setter(Builder::statefulEngineOptions)).constructor(StatefulEngineOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatefulEngineOptions").build()}).build();
    private static final SdkField<String> TLS_INSPECTION_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TLSInspectionConfigurationArn").getter(FirewallPolicy.getter(FirewallPolicy::tlsInspectionConfigurationArn)).setter(FirewallPolicy.setter(Builder::tlsInspectionConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TLSInspectionConfigurationArn").build()}).build();
    private static final SdkField<PolicyVariables> POLICY_VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PolicyVariables").getter(FirewallPolicy.getter(FirewallPolicy::policyVariables)).setter(FirewallPolicy.setter(Builder::policyVariables)).constructor(PolicyVariables::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyVariables").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATELESS_RULE_GROUP_REFERENCES_FIELD, STATELESS_DEFAULT_ACTIONS_FIELD, STATELESS_FRAGMENT_DEFAULT_ACTIONS_FIELD, STATELESS_CUSTOM_ACTIONS_FIELD, STATEFUL_RULE_GROUP_REFERENCES_FIELD, STATEFUL_DEFAULT_ACTIONS_FIELD, STATEFUL_ENGINE_OPTIONS_FIELD, TLS_INSPECTION_CONFIGURATION_ARN_FIELD, POLICY_VARIABLES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<StatelessRuleGroupReference> statelessRuleGroupReferences;
    private final List<String> statelessDefaultActions;
    private final List<String> statelessFragmentDefaultActions;
    private final List<CustomAction> statelessCustomActions;
    private final List<StatefulRuleGroupReference> statefulRuleGroupReferences;
    private final List<String> statefulDefaultActions;
    private final StatefulEngineOptions statefulEngineOptions;
    private final String tlsInspectionConfigurationArn;
    private final PolicyVariables policyVariables;

    private FirewallPolicy(BuilderImpl builder) {
        this.statelessRuleGroupReferences = builder.statelessRuleGroupReferences;
        this.statelessDefaultActions = builder.statelessDefaultActions;
        this.statelessFragmentDefaultActions = builder.statelessFragmentDefaultActions;
        this.statelessCustomActions = builder.statelessCustomActions;
        this.statefulRuleGroupReferences = builder.statefulRuleGroupReferences;
        this.statefulDefaultActions = builder.statefulDefaultActions;
        this.statefulEngineOptions = builder.statefulEngineOptions;
        this.tlsInspectionConfigurationArn = builder.tlsInspectionConfigurationArn;
        this.policyVariables = builder.policyVariables;
    }

    public final boolean hasStatelessRuleGroupReferences() {
        return this.statelessRuleGroupReferences != null && !(this.statelessRuleGroupReferences instanceof SdkAutoConstructList);
    }

    public final List<StatelessRuleGroupReference> statelessRuleGroupReferences() {
        return this.statelessRuleGroupReferences;
    }

    public final boolean hasStatelessDefaultActions() {
        return this.statelessDefaultActions != null && !(this.statelessDefaultActions instanceof SdkAutoConstructList);
    }

    public final List<String> statelessDefaultActions() {
        return this.statelessDefaultActions;
    }

    public final boolean hasStatelessFragmentDefaultActions() {
        return this.statelessFragmentDefaultActions != null && !(this.statelessFragmentDefaultActions instanceof SdkAutoConstructList);
    }

    public final List<String> statelessFragmentDefaultActions() {
        return this.statelessFragmentDefaultActions;
    }

    public final boolean hasStatelessCustomActions() {
        return this.statelessCustomActions != null && !(this.statelessCustomActions instanceof SdkAutoConstructList);
    }

    public final List<CustomAction> statelessCustomActions() {
        return this.statelessCustomActions;
    }

    public final boolean hasStatefulRuleGroupReferences() {
        return this.statefulRuleGroupReferences != null && !(this.statefulRuleGroupReferences instanceof SdkAutoConstructList);
    }

    public final List<StatefulRuleGroupReference> statefulRuleGroupReferences() {
        return this.statefulRuleGroupReferences;
    }

    public final boolean hasStatefulDefaultActions() {
        return this.statefulDefaultActions != null && !(this.statefulDefaultActions instanceof SdkAutoConstructList);
    }

    public final List<String> statefulDefaultActions() {
        return this.statefulDefaultActions;
    }

    public final StatefulEngineOptions statefulEngineOptions() {
        return this.statefulEngineOptions;
    }

    public final String tlsInspectionConfigurationArn() {
        return this.tlsInspectionConfigurationArn;
    }

    public final PolicyVariables policyVariables() {
        return this.policyVariables;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatelessRuleGroupReferences() ? this.statelessRuleGroupReferences() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatelessDefaultActions() ? this.statelessDefaultActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatelessFragmentDefaultActions() ? this.statelessFragmentDefaultActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatelessCustomActions() ? this.statelessCustomActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatefulRuleGroupReferences() ? this.statefulRuleGroupReferences() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatefulDefaultActions() ? this.statefulDefaultActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statefulEngineOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.tlsInspectionConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyVariables());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FirewallPolicy)) {
            return false;
        }
        FirewallPolicy other = (FirewallPolicy)obj;
        return this.hasStatelessRuleGroupReferences() == other.hasStatelessRuleGroupReferences() && Objects.equals(this.statelessRuleGroupReferences(), other.statelessRuleGroupReferences()) && this.hasStatelessDefaultActions() == other.hasStatelessDefaultActions() && Objects.equals(this.statelessDefaultActions(), other.statelessDefaultActions()) && this.hasStatelessFragmentDefaultActions() == other.hasStatelessFragmentDefaultActions() && Objects.equals(this.statelessFragmentDefaultActions(), other.statelessFragmentDefaultActions()) && this.hasStatelessCustomActions() == other.hasStatelessCustomActions() && Objects.equals(this.statelessCustomActions(), other.statelessCustomActions()) && this.hasStatefulRuleGroupReferences() == other.hasStatefulRuleGroupReferences() && Objects.equals(this.statefulRuleGroupReferences(), other.statefulRuleGroupReferences()) && this.hasStatefulDefaultActions() == other.hasStatefulDefaultActions() && Objects.equals(this.statefulDefaultActions(), other.statefulDefaultActions()) && Objects.equals(this.statefulEngineOptions(), other.statefulEngineOptions()) && Objects.equals(this.tlsInspectionConfigurationArn(), other.tlsInspectionConfigurationArn()) && Objects.equals(this.policyVariables(), other.policyVariables());
    }

    public final String toString() {
        return ToString.builder((String)"FirewallPolicy").add("StatelessRuleGroupReferences", this.hasStatelessRuleGroupReferences() ? this.statelessRuleGroupReferences() : null).add("StatelessDefaultActions", this.hasStatelessDefaultActions() ? this.statelessDefaultActions() : null).add("StatelessFragmentDefaultActions", this.hasStatelessFragmentDefaultActions() ? this.statelessFragmentDefaultActions() : null).add("StatelessCustomActions", this.hasStatelessCustomActions() ? this.statelessCustomActions() : null).add("StatefulRuleGroupReferences", this.hasStatefulRuleGroupReferences() ? this.statefulRuleGroupReferences() : null).add("StatefulDefaultActions", this.hasStatefulDefaultActions() ? this.statefulDefaultActions() : null).add("StatefulEngineOptions", (Object)this.statefulEngineOptions()).add("TLSInspectionConfigurationArn", (Object)this.tlsInspectionConfigurationArn()).add("PolicyVariables", (Object)this.policyVariables()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StatelessRuleGroupReferences": {
                return Optional.ofNullable(clazz.cast(this.statelessRuleGroupReferences()));
            }
            case "StatelessDefaultActions": {
                return Optional.ofNullable(clazz.cast(this.statelessDefaultActions()));
            }
            case "StatelessFragmentDefaultActions": {
                return Optional.ofNullable(clazz.cast(this.statelessFragmentDefaultActions()));
            }
            case "StatelessCustomActions": {
                return Optional.ofNullable(clazz.cast(this.statelessCustomActions()));
            }
            case "StatefulRuleGroupReferences": {
                return Optional.ofNullable(clazz.cast(this.statefulRuleGroupReferences()));
            }
            case "StatefulDefaultActions": {
                return Optional.ofNullable(clazz.cast(this.statefulDefaultActions()));
            }
            case "StatefulEngineOptions": {
                return Optional.ofNullable(clazz.cast(this.statefulEngineOptions()));
            }
            case "TLSInspectionConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.tlsInspectionConfigurationArn()));
            }
            case "PolicyVariables": {
                return Optional.ofNullable(clazz.cast(this.policyVariables()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FirewallPolicy, T> g) {
        return obj -> g.apply((FirewallPolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<StatelessRuleGroupReference> statelessRuleGroupReferences = DefaultSdkAutoConstructList.getInstance();
        private List<String> statelessDefaultActions = DefaultSdkAutoConstructList.getInstance();
        private List<String> statelessFragmentDefaultActions = DefaultSdkAutoConstructList.getInstance();
        private List<CustomAction> statelessCustomActions = DefaultSdkAutoConstructList.getInstance();
        private List<StatefulRuleGroupReference> statefulRuleGroupReferences = DefaultSdkAutoConstructList.getInstance();
        private List<String> statefulDefaultActions = DefaultSdkAutoConstructList.getInstance();
        private StatefulEngineOptions statefulEngineOptions;
        private String tlsInspectionConfigurationArn;
        private PolicyVariables policyVariables;

        private BuilderImpl() {
        }

        private BuilderImpl(FirewallPolicy model) {
            this.statelessRuleGroupReferences(model.statelessRuleGroupReferences);
            this.statelessDefaultActions(model.statelessDefaultActions);
            this.statelessFragmentDefaultActions(model.statelessFragmentDefaultActions);
            this.statelessCustomActions(model.statelessCustomActions);
            this.statefulRuleGroupReferences(model.statefulRuleGroupReferences);
            this.statefulDefaultActions(model.statefulDefaultActions);
            this.statefulEngineOptions(model.statefulEngineOptions);
            this.tlsInspectionConfigurationArn(model.tlsInspectionConfigurationArn);
            this.policyVariables(model.policyVariables);
        }

        public final List<StatelessRuleGroupReference.Builder> getStatelessRuleGroupReferences() {
            List<StatelessRuleGroupReference.Builder> result = StatelessRuleGroupReferencesCopier.copyToBuilder(this.statelessRuleGroupReferences);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStatelessRuleGroupReferences(Collection<StatelessRuleGroupReference.BuilderImpl> statelessRuleGroupReferences) {
            this.statelessRuleGroupReferences = StatelessRuleGroupReferencesCopier.copyFromBuilder(statelessRuleGroupReferences);
        }

        @Override
        public final Builder statelessRuleGroupReferences(Collection<StatelessRuleGroupReference> statelessRuleGroupReferences) {
            this.statelessRuleGroupReferences = StatelessRuleGroupReferencesCopier.copy(statelessRuleGroupReferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statelessRuleGroupReferences(StatelessRuleGroupReference ... statelessRuleGroupReferences) {
            this.statelessRuleGroupReferences(Arrays.asList(statelessRuleGroupReferences));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statelessRuleGroupReferences(Consumer<StatelessRuleGroupReference.Builder> ... statelessRuleGroupReferences) {
            this.statelessRuleGroupReferences(Stream.of(statelessRuleGroupReferences).map(c -> (StatelessRuleGroupReference)((StatelessRuleGroupReference.Builder)StatelessRuleGroupReference.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getStatelessDefaultActions() {
            if (this.statelessDefaultActions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.statelessDefaultActions;
        }

        public final void setStatelessDefaultActions(Collection<String> statelessDefaultActions) {
            this.statelessDefaultActions = StatelessActionsCopier.copy(statelessDefaultActions);
        }

        @Override
        public final Builder statelessDefaultActions(Collection<String> statelessDefaultActions) {
            this.statelessDefaultActions = StatelessActionsCopier.copy(statelessDefaultActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statelessDefaultActions(String ... statelessDefaultActions) {
            this.statelessDefaultActions(Arrays.asList(statelessDefaultActions));
            return this;
        }

        public final Collection<String> getStatelessFragmentDefaultActions() {
            if (this.statelessFragmentDefaultActions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.statelessFragmentDefaultActions;
        }

        public final void setStatelessFragmentDefaultActions(Collection<String> statelessFragmentDefaultActions) {
            this.statelessFragmentDefaultActions = StatelessActionsCopier.copy(statelessFragmentDefaultActions);
        }

        @Override
        public final Builder statelessFragmentDefaultActions(Collection<String> statelessFragmentDefaultActions) {
            this.statelessFragmentDefaultActions = StatelessActionsCopier.copy(statelessFragmentDefaultActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statelessFragmentDefaultActions(String ... statelessFragmentDefaultActions) {
            this.statelessFragmentDefaultActions(Arrays.asList(statelessFragmentDefaultActions));
            return this;
        }

        public final List<CustomAction.Builder> getStatelessCustomActions() {
            List<CustomAction.Builder> result = CustomActionsCopier.copyToBuilder(this.statelessCustomActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStatelessCustomActions(Collection<CustomAction.BuilderImpl> statelessCustomActions) {
            this.statelessCustomActions = CustomActionsCopier.copyFromBuilder(statelessCustomActions);
        }

        @Override
        public final Builder statelessCustomActions(Collection<CustomAction> statelessCustomActions) {
            this.statelessCustomActions = CustomActionsCopier.copy(statelessCustomActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statelessCustomActions(CustomAction ... statelessCustomActions) {
            this.statelessCustomActions(Arrays.asList(statelessCustomActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statelessCustomActions(Consumer<CustomAction.Builder> ... statelessCustomActions) {
            this.statelessCustomActions(Stream.of(statelessCustomActions).map(c -> (CustomAction)((CustomAction.Builder)CustomAction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<StatefulRuleGroupReference.Builder> getStatefulRuleGroupReferences() {
            List<StatefulRuleGroupReference.Builder> result = StatefulRuleGroupReferencesCopier.copyToBuilder(this.statefulRuleGroupReferences);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStatefulRuleGroupReferences(Collection<StatefulRuleGroupReference.BuilderImpl> statefulRuleGroupReferences) {
            this.statefulRuleGroupReferences = StatefulRuleGroupReferencesCopier.copyFromBuilder(statefulRuleGroupReferences);
        }

        @Override
        public final Builder statefulRuleGroupReferences(Collection<StatefulRuleGroupReference> statefulRuleGroupReferences) {
            this.statefulRuleGroupReferences = StatefulRuleGroupReferencesCopier.copy(statefulRuleGroupReferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statefulRuleGroupReferences(StatefulRuleGroupReference ... statefulRuleGroupReferences) {
            this.statefulRuleGroupReferences(Arrays.asList(statefulRuleGroupReferences));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statefulRuleGroupReferences(Consumer<StatefulRuleGroupReference.Builder> ... statefulRuleGroupReferences) {
            this.statefulRuleGroupReferences(Stream.of(statefulRuleGroupReferences).map(c -> (StatefulRuleGroupReference)((StatefulRuleGroupReference.Builder)StatefulRuleGroupReference.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getStatefulDefaultActions() {
            if (this.statefulDefaultActions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.statefulDefaultActions;
        }

        public final void setStatefulDefaultActions(Collection<String> statefulDefaultActions) {
            this.statefulDefaultActions = StatefulActionsCopier.copy(statefulDefaultActions);
        }

        @Override
        public final Builder statefulDefaultActions(Collection<String> statefulDefaultActions) {
            this.statefulDefaultActions = StatefulActionsCopier.copy(statefulDefaultActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statefulDefaultActions(String ... statefulDefaultActions) {
            this.statefulDefaultActions(Arrays.asList(statefulDefaultActions));
            return this;
        }

        public final StatefulEngineOptions.Builder getStatefulEngineOptions() {
            return this.statefulEngineOptions != null ? this.statefulEngineOptions.toBuilder() : null;
        }

        public final void setStatefulEngineOptions(StatefulEngineOptions.BuilderImpl statefulEngineOptions) {
            this.statefulEngineOptions = statefulEngineOptions != null ? statefulEngineOptions.build() : null;
        }

        @Override
        public final Builder statefulEngineOptions(StatefulEngineOptions statefulEngineOptions) {
            this.statefulEngineOptions = statefulEngineOptions;
            return this;
        }

        public final String getTlsInspectionConfigurationArn() {
            return this.tlsInspectionConfigurationArn;
        }

        public final void setTlsInspectionConfigurationArn(String tlsInspectionConfigurationArn) {
            this.tlsInspectionConfigurationArn = tlsInspectionConfigurationArn;
        }

        @Override
        public final Builder tlsInspectionConfigurationArn(String tlsInspectionConfigurationArn) {
            this.tlsInspectionConfigurationArn = tlsInspectionConfigurationArn;
            return this;
        }

        public final PolicyVariables.Builder getPolicyVariables() {
            return this.policyVariables != null ? this.policyVariables.toBuilder() : null;
        }

        public final void setPolicyVariables(PolicyVariables.BuilderImpl policyVariables) {
            this.policyVariables = policyVariables != null ? policyVariables.build() : null;
        }

        @Override
        public final Builder policyVariables(PolicyVariables policyVariables) {
            this.policyVariables = policyVariables;
            return this;
        }

        public FirewallPolicy build() {
            return new FirewallPolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FirewallPolicy> {
        public Builder statelessRuleGroupReferences(Collection<StatelessRuleGroupReference> var1);

        public Builder statelessRuleGroupReferences(StatelessRuleGroupReference ... var1);

        public Builder statelessRuleGroupReferences(Consumer<StatelessRuleGroupReference.Builder> ... var1);

        public Builder statelessDefaultActions(Collection<String> var1);

        public Builder statelessDefaultActions(String ... var1);

        public Builder statelessFragmentDefaultActions(Collection<String> var1);

        public Builder statelessFragmentDefaultActions(String ... var1);

        public Builder statelessCustomActions(Collection<CustomAction> var1);

        public Builder statelessCustomActions(CustomAction ... var1);

        public Builder statelessCustomActions(Consumer<CustomAction.Builder> ... var1);

        public Builder statefulRuleGroupReferences(Collection<StatefulRuleGroupReference> var1);

        public Builder statefulRuleGroupReferences(StatefulRuleGroupReference ... var1);

        public Builder statefulRuleGroupReferences(Consumer<StatefulRuleGroupReference.Builder> ... var1);

        public Builder statefulDefaultActions(Collection<String> var1);

        public Builder statefulDefaultActions(String ... var1);

        public Builder statefulEngineOptions(StatefulEngineOptions var1);

        default public Builder statefulEngineOptions(Consumer<StatefulEngineOptions.Builder> statefulEngineOptions) {
            return this.statefulEngineOptions((StatefulEngineOptions)((StatefulEngineOptions.Builder)StatefulEngineOptions.builder().applyMutation(statefulEngineOptions)).build());
        }

        public Builder tlsInspectionConfigurationArn(String var1);

        public Builder policyVariables(PolicyVariables var1);

        default public Builder policyVariables(Consumer<PolicyVariables.Builder> policyVariables) {
            return this.policyVariables((PolicyVariables)((PolicyVariables.Builder)PolicyVariables.builder().applyMutation(policyVariables)).build());
        }
    }
}

