/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.networkfirewall.model.NetworkFirewallRequest;
import software.amazon.awssdk.services.networkfirewall.model.RuleGroupType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteRuleGroupRequest
extends NetworkFirewallRequest
implements ToCopyableBuilder<Builder, DeleteRuleGroupRequest> {
    private static final SdkField<String> RULE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleGroupName").getter(DeleteRuleGroupRequest.getter(DeleteRuleGroupRequest::ruleGroupName)).setter(DeleteRuleGroupRequest.setter(Builder::ruleGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroupName").build()}).build();
    private static final SdkField<String> RULE_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleGroupArn").getter(DeleteRuleGroupRequest.getter(DeleteRuleGroupRequest::ruleGroupArn)).setter(DeleteRuleGroupRequest.setter(Builder::ruleGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroupArn").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(DeleteRuleGroupRequest.getter(DeleteRuleGroupRequest::typeAsString)).setter(DeleteRuleGroupRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_GROUP_NAME_FIELD, RULE_GROUP_ARN_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteRuleGroupRequest.memberNameToFieldInitializer();
    private final String ruleGroupName;
    private final String ruleGroupArn;
    private final String type;

    private DeleteRuleGroupRequest(BuilderImpl builder) {
        super(builder);
        this.ruleGroupName = builder.ruleGroupName;
        this.ruleGroupArn = builder.ruleGroupArn;
        this.type = builder.type;
    }

    public final String ruleGroupName() {
        return this.ruleGroupName;
    }

    public final String ruleGroupArn() {
        return this.ruleGroupArn;
    }

    public final RuleGroupType type() {
        return RuleGroupType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRuleGroupRequest)) {
            return false;
        }
        DeleteRuleGroupRequest other = (DeleteRuleGroupRequest)((Object)obj);
        return Objects.equals(this.ruleGroupName(), other.ruleGroupName()) && Objects.equals(this.ruleGroupArn(), other.ruleGroupArn()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteRuleGroupRequest").add("RuleGroupName", (Object)this.ruleGroupName()).add("RuleGroupArn", (Object)this.ruleGroupArn()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleGroupName": {
                return Optional.ofNullable(clazz.cast(this.ruleGroupName()));
            }
            case "RuleGroupArn": {
                return Optional.ofNullable(clazz.cast(this.ruleGroupArn()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("RuleGroupName", RULE_GROUP_NAME_FIELD);
        map.put("RuleGroupArn", RULE_GROUP_ARN_FIELD);
        map.put("Type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteRuleGroupRequest, T> g) {
        return obj -> g.apply((DeleteRuleGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkFirewallRequest.BuilderImpl
    implements Builder {
        private String ruleGroupName;
        private String ruleGroupArn;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteRuleGroupRequest model) {
            super(model);
            this.ruleGroupName(model.ruleGroupName);
            this.ruleGroupArn(model.ruleGroupArn);
            this.type(model.type);
        }

        public final String getRuleGroupName() {
            return this.ruleGroupName;
        }

        public final void setRuleGroupName(String ruleGroupName) {
            this.ruleGroupName = ruleGroupName;
        }

        @Override
        public final Builder ruleGroupName(String ruleGroupName) {
            this.ruleGroupName = ruleGroupName;
            return this;
        }

        public final String getRuleGroupArn() {
            return this.ruleGroupArn;
        }

        public final void setRuleGroupArn(String ruleGroupArn) {
            this.ruleGroupArn = ruleGroupArn;
        }

        @Override
        public final Builder ruleGroupArn(String ruleGroupArn) {
            this.ruleGroupArn = ruleGroupArn;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RuleGroupType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteRuleGroupRequest build() {
            return new DeleteRuleGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NetworkFirewallRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteRuleGroupRequest> {
        public Builder ruleGroupName(String var1);

        public Builder ruleGroupArn(String var1);

        public Builder type(String var1);

        public Builder type(RuleGroupType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

