/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.networkfirewall.model.FlowTimeouts;
import software.amazon.awssdk.services.networkfirewall.model.RuleOrder;
import software.amazon.awssdk.services.networkfirewall.model.StreamExceptionPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StatefulEngineOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StatefulEngineOptions> {
    private static final SdkField<String> RULE_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleOrder").getter(StatefulEngineOptions.getter(StatefulEngineOptions::ruleOrderAsString)).setter(StatefulEngineOptions.setter(Builder::ruleOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleOrder").build()}).build();
    private static final SdkField<String> STREAM_EXCEPTION_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamExceptionPolicy").getter(StatefulEngineOptions.getter(StatefulEngineOptions::streamExceptionPolicyAsString)).setter(StatefulEngineOptions.setter(Builder::streamExceptionPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamExceptionPolicy").build()}).build();
    private static final SdkField<FlowTimeouts> FLOW_TIMEOUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FlowTimeouts").getter(StatefulEngineOptions.getter(StatefulEngineOptions::flowTimeouts)).setter(StatefulEngineOptions.setter(Builder::flowTimeouts)).constructor(FlowTimeouts::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowTimeouts").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_ORDER_FIELD, STREAM_EXCEPTION_POLICY_FIELD, FLOW_TIMEOUTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StatefulEngineOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String ruleOrder;
    private final String streamExceptionPolicy;
    private final FlowTimeouts flowTimeouts;

    private StatefulEngineOptions(BuilderImpl builder) {
        this.ruleOrder = builder.ruleOrder;
        this.streamExceptionPolicy = builder.streamExceptionPolicy;
        this.flowTimeouts = builder.flowTimeouts;
    }

    public final RuleOrder ruleOrder() {
        return RuleOrder.fromValue(this.ruleOrder);
    }

    public final String ruleOrderAsString() {
        return this.ruleOrder;
    }

    public final StreamExceptionPolicy streamExceptionPolicy() {
        return StreamExceptionPolicy.fromValue(this.streamExceptionPolicy);
    }

    public final String streamExceptionPolicyAsString() {
        return this.streamExceptionPolicy;
    }

    public final FlowTimeouts flowTimeouts() {
        return this.flowTimeouts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamExceptionPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowTimeouts());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StatefulEngineOptions)) {
            return false;
        }
        StatefulEngineOptions other = (StatefulEngineOptions)obj;
        return Objects.equals(this.ruleOrderAsString(), other.ruleOrderAsString()) && Objects.equals(this.streamExceptionPolicyAsString(), other.streamExceptionPolicyAsString()) && Objects.equals(this.flowTimeouts(), other.flowTimeouts());
    }

    public final String toString() {
        return ToString.builder((String)"StatefulEngineOptions").add("RuleOrder", (Object)this.ruleOrderAsString()).add("StreamExceptionPolicy", (Object)this.streamExceptionPolicyAsString()).add("FlowTimeouts", (Object)this.flowTimeouts()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleOrder": {
                return Optional.ofNullable(clazz.cast(this.ruleOrderAsString()));
            }
            case "StreamExceptionPolicy": {
                return Optional.ofNullable(clazz.cast(this.streamExceptionPolicyAsString()));
            }
            case "FlowTimeouts": {
                return Optional.ofNullable(clazz.cast(this.flowTimeouts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RuleOrder", RULE_ORDER_FIELD);
        map.put("StreamExceptionPolicy", STREAM_EXCEPTION_POLICY_FIELD);
        map.put("FlowTimeouts", FLOW_TIMEOUTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StatefulEngineOptions, T> g) {
        return obj -> g.apply((StatefulEngineOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ruleOrder;
        private String streamExceptionPolicy;
        private FlowTimeouts flowTimeouts;

        private BuilderImpl() {
        }

        private BuilderImpl(StatefulEngineOptions model) {
            this.ruleOrder(model.ruleOrder);
            this.streamExceptionPolicy(model.streamExceptionPolicy);
            this.flowTimeouts(model.flowTimeouts);
        }

        public final String getRuleOrder() {
            return this.ruleOrder;
        }

        public final void setRuleOrder(String ruleOrder) {
            this.ruleOrder = ruleOrder;
        }

        @Override
        public final Builder ruleOrder(String ruleOrder) {
            this.ruleOrder = ruleOrder;
            return this;
        }

        @Override
        public final Builder ruleOrder(RuleOrder ruleOrder) {
            this.ruleOrder(ruleOrder == null ? null : ruleOrder.toString());
            return this;
        }

        public final String getStreamExceptionPolicy() {
            return this.streamExceptionPolicy;
        }

        public final void setStreamExceptionPolicy(String streamExceptionPolicy) {
            this.streamExceptionPolicy = streamExceptionPolicy;
        }

        @Override
        public final Builder streamExceptionPolicy(String streamExceptionPolicy) {
            this.streamExceptionPolicy = streamExceptionPolicy;
            return this;
        }

        @Override
        public final Builder streamExceptionPolicy(StreamExceptionPolicy streamExceptionPolicy) {
            this.streamExceptionPolicy(streamExceptionPolicy == null ? null : streamExceptionPolicy.toString());
            return this;
        }

        public final FlowTimeouts.Builder getFlowTimeouts() {
            return this.flowTimeouts != null ? this.flowTimeouts.toBuilder() : null;
        }

        public final void setFlowTimeouts(FlowTimeouts.BuilderImpl flowTimeouts) {
            this.flowTimeouts = flowTimeouts != null ? flowTimeouts.build() : null;
        }

        @Override
        public final Builder flowTimeouts(FlowTimeouts flowTimeouts) {
            this.flowTimeouts = flowTimeouts;
            return this;
        }

        public StatefulEngineOptions build() {
            return new StatefulEngineOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StatefulEngineOptions> {
        public Builder ruleOrder(String var1);

        public Builder ruleOrder(RuleOrder var1);

        public Builder streamExceptionPolicy(String var1);

        public Builder streamExceptionPolicy(StreamExceptionPolicy var1);

        public Builder flowTimeouts(FlowTimeouts var1);

        default public Builder flowTimeouts(Consumer<FlowTimeouts.Builder> flowTimeouts) {
            return this.flowTimeouts((FlowTimeouts)((FlowTimeouts.Builder)FlowTimeouts.builder().applyMutation(flowTimeouts)).build());
        }
    }
}

