/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkmanager.NetworkManagerAsyncClient;
import software.amazon.awssdk.services.networkmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceCountsRequest;
import software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceCountsResponse;
import software.amazon.awssdk.services.networkmanager.model.NetworkResourceCount;

public class GetNetworkResourceCountsPublisher
implements SdkPublisher<GetNetworkResourceCountsResponse> {
    private final NetworkManagerAsyncClient client;
    private final GetNetworkResourceCountsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetNetworkResourceCountsPublisher(NetworkManagerAsyncClient client, GetNetworkResourceCountsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetNetworkResourceCountsPublisher(NetworkManagerAsyncClient client, GetNetworkResourceCountsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetNetworkResourceCountsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetNetworkResourceCountsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<NetworkResourceCount> networkResourceCounts() {
        Function<GetNetworkResourceCountsResponse, Iterator> getIterator = response -> {
            if (response != null && response.networkResourceCounts() != null) {
                return response.networkResourceCounts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetNetworkResourceCountsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetNetworkResourceCountsResponseFetcher
    implements AsyncPageFetcher<GetNetworkResourceCountsResponse> {
        private GetNetworkResourceCountsResponseFetcher() {
        }

        public boolean hasNextPage(GetNetworkResourceCountsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetNetworkResourceCountsResponse> nextPage(GetNetworkResourceCountsResponse previousPage) {
            if (previousPage == null) {
                return GetNetworkResourceCountsPublisher.this.client.getNetworkResourceCounts(GetNetworkResourceCountsPublisher.this.firstRequest);
            }
            return GetNetworkResourceCountsPublisher.this.client.getNetworkResourceCounts((GetNetworkResourceCountsRequest)((Object)GetNetworkResourceCountsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

