/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a core network Connect peer configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectPeerConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectPeerConfiguration.Builder, ConnectPeerConfiguration> {
    private static final SdkField<String> CORE_NETWORK_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CoreNetworkAddress").getter(getter(ConnectPeerConfiguration::coreNetworkAddress))
            .setter(setter(Builder::coreNetworkAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreNetworkAddress").build())
            .build();

    private static final SdkField<String> PEER_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PeerAddress").getter(getter(ConnectPeerConfiguration::peerAddress)).setter(setter(Builder::peerAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerAddress").build()).build();

    private static final SdkField<List<String>> INSIDE_CIDR_BLOCKS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("InsideCidrBlocks")
            .getter(getter(ConnectPeerConfiguration::insideCidrBlocks))
            .setter(setter(Builder::insideCidrBlocks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsideCidrBlocks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Protocol").getter(getter(ConnectPeerConfiguration::protocolAsString)).setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()).build();

    private static final SdkField<List<ConnectPeerBgpConfiguration>> BGP_CONFIGURATIONS_FIELD = SdkField
            .<List<ConnectPeerBgpConfiguration>> builder(MarshallingType.LIST)
            .memberName("BgpConfigurations")
            .getter(getter(ConnectPeerConfiguration::bgpConfigurations))
            .setter(setter(Builder::bgpConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BgpConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConnectPeerBgpConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConnectPeerBgpConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CORE_NETWORK_ADDRESS_FIELD,
            PEER_ADDRESS_FIELD, INSIDE_CIDR_BLOCKS_FIELD, PROTOCOL_FIELD, BGP_CONFIGURATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String coreNetworkAddress;

    private final String peerAddress;

    private final List<String> insideCidrBlocks;

    private final String protocol;

    private final List<ConnectPeerBgpConfiguration> bgpConfigurations;

    private ConnectPeerConfiguration(BuilderImpl builder) {
        this.coreNetworkAddress = builder.coreNetworkAddress;
        this.peerAddress = builder.peerAddress;
        this.insideCidrBlocks = builder.insideCidrBlocks;
        this.protocol = builder.protocol;
        this.bgpConfigurations = builder.bgpConfigurations;
    }

    /**
     * <p>
     * The IP address of a core network.
     * </p>
     * 
     * @return The IP address of a core network.
     */
    public final String coreNetworkAddress() {
        return coreNetworkAddress;
    }

    /**
     * <p>
     * The IP address of the Connect peer.
     * </p>
     * 
     * @return The IP address of the Connect peer.
     */
    public final String peerAddress() {
        return peerAddress;
    }

    /**
     * For responses, this returns true if the service returned a value for the InsideCidrBlocks property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInsideCidrBlocks() {
        return insideCidrBlocks != null && !(insideCidrBlocks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The inside IP addresses used for a Connect peer configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInsideCidrBlocks} method.
     * </p>
     * 
     * @return The inside IP addresses used for a Connect peer configuration.
     */
    public final List<String> insideCidrBlocks() {
        return insideCidrBlocks;
    }

    /**
     * <p>
     * The protocol used for a Connect peer configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link TunnelProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol used for a Connect peer configuration.
     * @see TunnelProtocol
     */
    public final TunnelProtocol protocol() {
        return TunnelProtocol.fromValue(protocol);
    }

    /**
     * <p>
     * The protocol used for a Connect peer configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link TunnelProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol used for a Connect peer configuration.
     * @see TunnelProtocol
     */
    public final String protocolAsString() {
        return protocol;
    }

    /**
     * For responses, this returns true if the service returned a value for the BgpConfigurations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBgpConfigurations() {
        return bgpConfigurations != null && !(bgpConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Connect peer BGP configurations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBgpConfigurations} method.
     * </p>
     * 
     * @return The Connect peer BGP configurations.
     */
    public final List<ConnectPeerBgpConfiguration> bgpConfigurations() {
        return bgpConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(coreNetworkAddress());
        hashCode = 31 * hashCode + Objects.hashCode(peerAddress());
        hashCode = 31 * hashCode + Objects.hashCode(hasInsideCidrBlocks() ? insideCidrBlocks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasBgpConfigurations() ? bgpConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectPeerConfiguration)) {
            return false;
        }
        ConnectPeerConfiguration other = (ConnectPeerConfiguration) obj;
        return Objects.equals(coreNetworkAddress(), other.coreNetworkAddress())
                && Objects.equals(peerAddress(), other.peerAddress()) && hasInsideCidrBlocks() == other.hasInsideCidrBlocks()
                && Objects.equals(insideCidrBlocks(), other.insideCidrBlocks())
                && Objects.equals(protocolAsString(), other.protocolAsString())
                && hasBgpConfigurations() == other.hasBgpConfigurations()
                && Objects.equals(bgpConfigurations(), other.bgpConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectPeerConfiguration").add("CoreNetworkAddress", coreNetworkAddress())
                .add("PeerAddress", peerAddress()).add("InsideCidrBlocks", hasInsideCidrBlocks() ? insideCidrBlocks() : null)
                .add("Protocol", protocolAsString())
                .add("BgpConfigurations", hasBgpConfigurations() ? bgpConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CoreNetworkAddress":
            return Optional.ofNullable(clazz.cast(coreNetworkAddress()));
        case "PeerAddress":
            return Optional.ofNullable(clazz.cast(peerAddress()));
        case "InsideCidrBlocks":
            return Optional.ofNullable(clazz.cast(insideCidrBlocks()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocolAsString()));
        case "BgpConfigurations":
            return Optional.ofNullable(clazz.cast(bgpConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CoreNetworkAddress", CORE_NETWORK_ADDRESS_FIELD);
        map.put("PeerAddress", PEER_ADDRESS_FIELD);
        map.put("InsideCidrBlocks", INSIDE_CIDR_BLOCKS_FIELD);
        map.put("Protocol", PROTOCOL_FIELD);
        map.put("BgpConfigurations", BGP_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConnectPeerConfiguration, T> g) {
        return obj -> g.apply((ConnectPeerConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectPeerConfiguration> {
        /**
         * <p>
         * The IP address of a core network.
         * </p>
         * 
         * @param coreNetworkAddress
         *        The IP address of a core network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coreNetworkAddress(String coreNetworkAddress);

        /**
         * <p>
         * The IP address of the Connect peer.
         * </p>
         * 
         * @param peerAddress
         *        The IP address of the Connect peer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peerAddress(String peerAddress);

        /**
         * <p>
         * The inside IP addresses used for a Connect peer configuration.
         * </p>
         * 
         * @param insideCidrBlocks
         *        The inside IP addresses used for a Connect peer configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insideCidrBlocks(Collection<String> insideCidrBlocks);

        /**
         * <p>
         * The inside IP addresses used for a Connect peer configuration.
         * </p>
         * 
         * @param insideCidrBlocks
         *        The inside IP addresses used for a Connect peer configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insideCidrBlocks(String... insideCidrBlocks);

        /**
         * <p>
         * The protocol used for a Connect peer configuration.
         * </p>
         * 
         * @param protocol
         *        The protocol used for a Connect peer configuration.
         * @see TunnelProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TunnelProtocol
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The protocol used for a Connect peer configuration.
         * </p>
         * 
         * @param protocol
         *        The protocol used for a Connect peer configuration.
         * @see TunnelProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TunnelProtocol
         */
        Builder protocol(TunnelProtocol protocol);

        /**
         * <p>
         * The Connect peer BGP configurations.
         * </p>
         * 
         * @param bgpConfigurations
         *        The Connect peer BGP configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bgpConfigurations(Collection<ConnectPeerBgpConfiguration> bgpConfigurations);

        /**
         * <p>
         * The Connect peer BGP configurations.
         * </p>
         * 
         * @param bgpConfigurations
         *        The Connect peer BGP configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bgpConfigurations(ConnectPeerBgpConfiguration... bgpConfigurations);

        /**
         * <p>
         * The Connect peer BGP configurations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkmanager.model.ConnectPeerBgpConfiguration.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.networkmanager.model.ConnectPeerBgpConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkmanager.model.ConnectPeerBgpConfiguration.Builder#build()} is
         * called immediately and its result is passed to {@link #bgpConfigurations(List<ConnectPeerBgpConfiguration>)}.
         * 
         * @param bgpConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkmanager.model.ConnectPeerBgpConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bgpConfigurations(java.util.Collection<ConnectPeerBgpConfiguration>)
         */
        Builder bgpConfigurations(Consumer<ConnectPeerBgpConfiguration.Builder>... bgpConfigurations);
    }

    static final class BuilderImpl implements Builder {
        private String coreNetworkAddress;

        private String peerAddress;

        private List<String> insideCidrBlocks = DefaultSdkAutoConstructList.getInstance();

        private String protocol;

        private List<ConnectPeerBgpConfiguration> bgpConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectPeerConfiguration model) {
            coreNetworkAddress(model.coreNetworkAddress);
            peerAddress(model.peerAddress);
            insideCidrBlocks(model.insideCidrBlocks);
            protocol(model.protocol);
            bgpConfigurations(model.bgpConfigurations);
        }

        public final String getCoreNetworkAddress() {
            return coreNetworkAddress;
        }

        public final void setCoreNetworkAddress(String coreNetworkAddress) {
            this.coreNetworkAddress = coreNetworkAddress;
        }

        @Override
        public final Builder coreNetworkAddress(String coreNetworkAddress) {
            this.coreNetworkAddress = coreNetworkAddress;
            return this;
        }

        public final String getPeerAddress() {
            return peerAddress;
        }

        public final void setPeerAddress(String peerAddress) {
            this.peerAddress = peerAddress;
        }

        @Override
        public final Builder peerAddress(String peerAddress) {
            this.peerAddress = peerAddress;
            return this;
        }

        public final Collection<String> getInsideCidrBlocks() {
            if (insideCidrBlocks instanceof SdkAutoConstructList) {
                return null;
            }
            return insideCidrBlocks;
        }

        public final void setInsideCidrBlocks(Collection<String> insideCidrBlocks) {
            this.insideCidrBlocks = ConstrainedStringListCopier.copy(insideCidrBlocks);
        }

        @Override
        public final Builder insideCidrBlocks(Collection<String> insideCidrBlocks) {
            this.insideCidrBlocks = ConstrainedStringListCopier.copy(insideCidrBlocks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insideCidrBlocks(String... insideCidrBlocks) {
            insideCidrBlocks(Arrays.asList(insideCidrBlocks));
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(TunnelProtocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final List<ConnectPeerBgpConfiguration.Builder> getBgpConfigurations() {
            List<ConnectPeerBgpConfiguration.Builder> result = ConnectPeerBgpConfigurationListCopier
                    .copyToBuilder(this.bgpConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBgpConfigurations(Collection<ConnectPeerBgpConfiguration.BuilderImpl> bgpConfigurations) {
            this.bgpConfigurations = ConnectPeerBgpConfigurationListCopier.copyFromBuilder(bgpConfigurations);
        }

        @Override
        public final Builder bgpConfigurations(Collection<ConnectPeerBgpConfiguration> bgpConfigurations) {
            this.bgpConfigurations = ConnectPeerBgpConfigurationListCopier.copy(bgpConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bgpConfigurations(ConnectPeerBgpConfiguration... bgpConfigurations) {
            bgpConfigurations(Arrays.asList(bgpConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bgpConfigurations(Consumer<ConnectPeerBgpConfiguration.Builder>... bgpConfigurations) {
            bgpConfigurations(Stream.of(bgpConfigurations)
                    .map(c -> ConnectPeerBgpConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ConnectPeerConfiguration build() {
            return new ConnectPeerConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
