/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an error associated with a Connect peer request
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectPeerError implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectPeerError.Builder, ConnectPeerError> {
    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Code")
            .getter(getter(ConnectPeerError::codeAsString)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(ConnectPeerError::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(ConnectPeerError::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(ConnectPeerError::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_FIELD, MESSAGE_FIELD,
            RESOURCE_ARN_FIELD, REQUEST_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String code;

    private final String message;

    private final String resourceArn;

    private final String requestId;

    private ConnectPeerError(BuilderImpl builder) {
        this.code = builder.code;
        this.message = builder.message;
        this.resourceArn = builder.resourceArn;
        this.requestId = builder.requestId;
    }

    /**
     * <p>
     * The error code for the Connect peer request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link ConnectPeerErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codeAsString}.
     * </p>
     * 
     * @return The error code for the Connect peer request.
     * @see ConnectPeerErrorCode
     */
    public final ConnectPeerErrorCode code() {
        return ConnectPeerErrorCode.fromValue(code);
    }

    /**
     * <p>
     * The error code for the Connect peer request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link ConnectPeerErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codeAsString}.
     * </p>
     * 
     * @return The error code for the Connect peer request.
     * @see ConnectPeerErrorCode
     */
    public final String codeAsString() {
        return code;
    }

    /**
     * <p>
     * The message associated with the error <code>code</code>.
     * </p>
     * 
     * @return The message associated with the error <code>code</code>.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The ARN of the requested Connect peer resource.
     * </p>
     * 
     * @return The ARN of the requested Connect peer resource.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The ID of the Connect peer request.
     * </p>
     * 
     * @return The ID of the Connect peer request.
     */
    public final String requestId() {
        return requestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(codeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectPeerError)) {
            return false;
        }
        ConnectPeerError other = (ConnectPeerError) obj;
        return Objects.equals(codeAsString(), other.codeAsString()) && Objects.equals(message(), other.message())
                && Objects.equals(resourceArn(), other.resourceArn()) && Objects.equals(requestId(), other.requestId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectPeerError").add("Code", codeAsString()).add("Message", message())
                .add("ResourceArn", resourceArn()).add("RequestId", requestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Code":
            return Optional.ofNullable(clazz.cast(codeAsString()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Code", CODE_FIELD);
        map.put("Message", MESSAGE_FIELD);
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("RequestId", REQUEST_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConnectPeerError, T> g) {
        return obj -> g.apply((ConnectPeerError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectPeerError> {
        /**
         * <p>
         * The error code for the Connect peer request.
         * </p>
         * 
         * @param code
         *        The error code for the Connect peer request.
         * @see ConnectPeerErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectPeerErrorCode
         */
        Builder code(String code);

        /**
         * <p>
         * The error code for the Connect peer request.
         * </p>
         * 
         * @param code
         *        The error code for the Connect peer request.
         * @see ConnectPeerErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectPeerErrorCode
         */
        Builder code(ConnectPeerErrorCode code);

        /**
         * <p>
         * The message associated with the error <code>code</code>.
         * </p>
         * 
         * @param message
         *        The message associated with the error <code>code</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The ARN of the requested Connect peer resource.
         * </p>
         * 
         * @param resourceArn
         *        The ARN of the requested Connect peer resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The ID of the Connect peer request.
         * </p>
         * 
         * @param requestId
         *        The ID of the Connect peer request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);
    }

    static final class BuilderImpl implements Builder {
        private String code;

        private String message;

        private String resourceArn;

        private String requestId;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectPeerError model) {
            code(model.code);
            message(model.message);
            resourceArn(model.resourceArn);
            requestId(model.requestId);
        }

        public final String getCode() {
            return code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        @Override
        public final Builder code(ConnectPeerErrorCode code) {
            this.code(code == null ? null : code.toString());
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public ConnectPeerError build() {
            return new ConnectPeerError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
