/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a network function group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CoreNetworkNetworkFunctionGroup implements SdkPojo, Serializable,
        ToCopyableBuilder<CoreNetworkNetworkFunctionGroup.Builder, CoreNetworkNetworkFunctionGroup> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CoreNetworkNetworkFunctionGroup::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<String>> EDGE_LOCATIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EdgeLocations")
            .getter(getter(CoreNetworkNetworkFunctionGroup::edgeLocations))
            .setter(setter(Builder::edgeLocations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeLocations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ServiceInsertionSegments> SEGMENTS_FIELD = SdkField
            .<ServiceInsertionSegments> builder(MarshallingType.SDK_POJO).memberName("Segments")
            .getter(getter(CoreNetworkNetworkFunctionGroup::segments)).setter(setter(Builder::segments))
            .constructor(ServiceInsertionSegments::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Segments").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            EDGE_LOCATIONS_FIELD, SEGMENTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final List<String> edgeLocations;

    private final ServiceInsertionSegments segments;

    private CoreNetworkNetworkFunctionGroup(BuilderImpl builder) {
        this.name = builder.name;
        this.edgeLocations = builder.edgeLocations;
        this.segments = builder.segments;
    }

    /**
     * <p>
     * The name of the network function group.
     * </p>
     * 
     * @return The name of the network function group.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the EdgeLocations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEdgeLocations() {
        return edgeLocations != null && !(edgeLocations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The core network edge locations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEdgeLocations} method.
     * </p>
     * 
     * @return The core network edge locations.
     */
    public final List<String> edgeLocations() {
        return edgeLocations;
    }

    /**
     * <p>
     * The segments associated with the network function group.
     * </p>
     * 
     * @return The segments associated with the network function group.
     */
    public final ServiceInsertionSegments segments() {
        return segments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasEdgeLocations() ? edgeLocations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(segments());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoreNetworkNetworkFunctionGroup)) {
            return false;
        }
        CoreNetworkNetworkFunctionGroup other = (CoreNetworkNetworkFunctionGroup) obj;
        return Objects.equals(name(), other.name()) && hasEdgeLocations() == other.hasEdgeLocations()
                && Objects.equals(edgeLocations(), other.edgeLocations()) && Objects.equals(segments(), other.segments());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CoreNetworkNetworkFunctionGroup").add("Name", name())
                .add("EdgeLocations", hasEdgeLocations() ? edgeLocations() : null).add("Segments", segments()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "EdgeLocations":
            return Optional.ofNullable(clazz.cast(edgeLocations()));
        case "Segments":
            return Optional.ofNullable(clazz.cast(segments()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("EdgeLocations", EDGE_LOCATIONS_FIELD);
        map.put("Segments", SEGMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CoreNetworkNetworkFunctionGroup, T> g) {
        return obj -> g.apply((CoreNetworkNetworkFunctionGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CoreNetworkNetworkFunctionGroup> {
        /**
         * <p>
         * The name of the network function group.
         * </p>
         * 
         * @param name
         *        The name of the network function group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The core network edge locations.
         * </p>
         * 
         * @param edgeLocations
         *        The core network edge locations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edgeLocations(Collection<String> edgeLocations);

        /**
         * <p>
         * The core network edge locations.
         * </p>
         * 
         * @param edgeLocations
         *        The core network edge locations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edgeLocations(String... edgeLocations);

        /**
         * <p>
         * The segments associated with the network function group.
         * </p>
         * 
         * @param segments
         *        The segments associated with the network function group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segments(ServiceInsertionSegments segments);

        /**
         * <p>
         * The segments associated with the network function group.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServiceInsertionSegments.Builder}
         * avoiding the need to create one manually via {@link ServiceInsertionSegments#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceInsertionSegments.Builder#build()} is called immediately
         * and its result is passed to {@link #segments(ServiceInsertionSegments)}.
         * 
         * @param segments
         *        a consumer that will call methods on {@link ServiceInsertionSegments.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #segments(ServiceInsertionSegments)
         */
        default Builder segments(Consumer<ServiceInsertionSegments.Builder> segments) {
            return segments(ServiceInsertionSegments.builder().applyMutation(segments).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<String> edgeLocations = DefaultSdkAutoConstructList.getInstance();

        private ServiceInsertionSegments segments;

        private BuilderImpl() {
        }

        private BuilderImpl(CoreNetworkNetworkFunctionGroup model) {
            name(model.name);
            edgeLocations(model.edgeLocations);
            segments(model.segments);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getEdgeLocations() {
            if (edgeLocations instanceof SdkAutoConstructList) {
                return null;
            }
            return edgeLocations;
        }

        public final void setEdgeLocations(Collection<String> edgeLocations) {
            this.edgeLocations = ExternalRegionCodeListCopier.copy(edgeLocations);
        }

        @Override
        public final Builder edgeLocations(Collection<String> edgeLocations) {
            this.edgeLocations = ExternalRegionCodeListCopier.copy(edgeLocations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder edgeLocations(String... edgeLocations) {
            edgeLocations(Arrays.asList(edgeLocations));
            return this;
        }

        public final ServiceInsertionSegments.Builder getSegments() {
            return segments != null ? segments.toBuilder() : null;
        }

        public final void setSegments(ServiceInsertionSegments.BuilderImpl segments) {
            this.segments = segments != null ? segments.build() : null;
        }

        @Override
        public final Builder segments(ServiceInsertionSegments segments) {
            this.segments = segments;
            return this;
        }

        @Override
        public CoreNetworkNetworkFunctionGroup build() {
            return new CoreNetworkNetworkFunctionGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
