/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDirectConnectGatewayAttachmentRequest extends NetworkManagerRequest implements
        ToCopyableBuilder<CreateDirectConnectGatewayAttachmentRequest.Builder, CreateDirectConnectGatewayAttachmentRequest> {
    private static final SdkField<String> CORE_NETWORK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CoreNetworkId").getter(getter(CreateDirectConnectGatewayAttachmentRequest::coreNetworkId))
            .setter(setter(Builder::coreNetworkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreNetworkId").build()).build();

    private static final SdkField<String> DIRECT_CONNECT_GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectConnectGatewayArn")
            .getter(getter(CreateDirectConnectGatewayAttachmentRequest::directConnectGatewayArn))
            .setter(setter(Builder::directConnectGatewayArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectConnectGatewayArn").build())
            .build();

    private static final SdkField<List<String>> EDGE_LOCATIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EdgeLocations")
            .getter(getter(CreateDirectConnectGatewayAttachmentRequest::edgeLocations))
            .setter(setter(Builder::edgeLocations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeLocations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateDirectConnectGatewayAttachmentRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateDirectConnectGatewayAttachmentRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CORE_NETWORK_ID_FIELD,
            DIRECT_CONNECT_GATEWAY_ARN_FIELD, EDGE_LOCATIONS_FIELD, TAGS_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String coreNetworkId;

    private final String directConnectGatewayArn;

    private final List<String> edgeLocations;

    private final List<Tag> tags;

    private final String clientToken;

    private CreateDirectConnectGatewayAttachmentRequest(BuilderImpl builder) {
        super(builder);
        this.coreNetworkId = builder.coreNetworkId;
        this.directConnectGatewayArn = builder.directConnectGatewayArn;
        this.edgeLocations = builder.edgeLocations;
        this.tags = builder.tags;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The ID of the Cloud WAN core network that the Direct Connect gateway attachment should be attached to.
     * </p>
     * 
     * @return The ID of the Cloud WAN core network that the Direct Connect gateway attachment should be attached to.
     */
    public final String coreNetworkId() {
        return coreNetworkId;
    }

    /**
     * <p>
     * The ARN of the Direct Connect gateway attachment.
     * </p>
     * 
     * @return The ARN of the Direct Connect gateway attachment.
     */
    public final String directConnectGatewayArn() {
        return directConnectGatewayArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the EdgeLocations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEdgeLocations() {
        return edgeLocations != null && !(edgeLocations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more core network edge locations that the Direct Connect gateway attachment is associated with.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEdgeLocations} method.
     * </p>
     * 
     * @return One or more core network edge locations that the Direct Connect gateway attachment is associated with.
     */
    public final List<String> edgeLocations() {
        return edgeLocations;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The key value tags to apply to the Direct Connect gateway attachment during creation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The key value tags to apply to the Direct Connect gateway attachment during creation.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * client token
     * </p>
     * 
     * @return client token
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(coreNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(directConnectGatewayArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasEdgeLocations() ? edgeLocations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDirectConnectGatewayAttachmentRequest)) {
            return false;
        }
        CreateDirectConnectGatewayAttachmentRequest other = (CreateDirectConnectGatewayAttachmentRequest) obj;
        return Objects.equals(coreNetworkId(), other.coreNetworkId())
                && Objects.equals(directConnectGatewayArn(), other.directConnectGatewayArn())
                && hasEdgeLocations() == other.hasEdgeLocations() && Objects.equals(edgeLocations(), other.edgeLocations())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDirectConnectGatewayAttachmentRequest").add("CoreNetworkId", coreNetworkId())
                .add("DirectConnectGatewayArn", directConnectGatewayArn())
                .add("EdgeLocations", hasEdgeLocations() ? edgeLocations() : null).add("Tags", hasTags() ? tags() : null)
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CoreNetworkId":
            return Optional.ofNullable(clazz.cast(coreNetworkId()));
        case "DirectConnectGatewayArn":
            return Optional.ofNullable(clazz.cast(directConnectGatewayArn()));
        case "EdgeLocations":
            return Optional.ofNullable(clazz.cast(edgeLocations()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CoreNetworkId", CORE_NETWORK_ID_FIELD);
        map.put("DirectConnectGatewayArn", DIRECT_CONNECT_GATEWAY_ARN_FIELD);
        map.put("EdgeLocations", EDGE_LOCATIONS_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDirectConnectGatewayAttachmentRequest, T> g) {
        return obj -> g.apply((CreateDirectConnectGatewayAttachmentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NetworkManagerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateDirectConnectGatewayAttachmentRequest> {
        /**
         * <p>
         * The ID of the Cloud WAN core network that the Direct Connect gateway attachment should be attached to.
         * </p>
         * 
         * @param coreNetworkId
         *        The ID of the Cloud WAN core network that the Direct Connect gateway attachment should be attached to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coreNetworkId(String coreNetworkId);

        /**
         * <p>
         * The ARN of the Direct Connect gateway attachment.
         * </p>
         * 
         * @param directConnectGatewayArn
         *        The ARN of the Direct Connect gateway attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directConnectGatewayArn(String directConnectGatewayArn);

        /**
         * <p>
         * One or more core network edge locations that the Direct Connect gateway attachment is associated with.
         * </p>
         * 
         * @param edgeLocations
         *        One or more core network edge locations that the Direct Connect gateway attachment is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edgeLocations(Collection<String> edgeLocations);

        /**
         * <p>
         * One or more core network edge locations that the Direct Connect gateway attachment is associated with.
         * </p>
         * 
         * @param edgeLocations
         *        One or more core network edge locations that the Direct Connect gateway attachment is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edgeLocations(String... edgeLocations);

        /**
         * <p>
         * The key value tags to apply to the Direct Connect gateway attachment during creation.
         * </p>
         * 
         * @param tags
         *        The key value tags to apply to the Direct Connect gateway attachment during creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The key value tags to apply to the Direct Connect gateway attachment during creation.
         * </p>
         * 
         * @param tags
         *        The key value tags to apply to the Direct Connect gateway attachment during creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The key value tags to apply to the Direct Connect gateway attachment during creation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkmanager.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.networkmanager.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkmanager.model.Tag.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkmanager.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * client token
         * </p>
         * 
         * @param clientToken
         *        client token
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NetworkManagerRequest.BuilderImpl implements Builder {
        private String coreNetworkId;

        private String directConnectGatewayArn;

        private List<String> edgeLocations = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDirectConnectGatewayAttachmentRequest model) {
            super(model);
            coreNetworkId(model.coreNetworkId);
            directConnectGatewayArn(model.directConnectGatewayArn);
            edgeLocations(model.edgeLocations);
            tags(model.tags);
            clientToken(model.clientToken);
        }

        public final String getCoreNetworkId() {
            return coreNetworkId;
        }

        public final void setCoreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
        }

        @Override
        public final Builder coreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
            return this;
        }

        public final String getDirectConnectGatewayArn() {
            return directConnectGatewayArn;
        }

        public final void setDirectConnectGatewayArn(String directConnectGatewayArn) {
            this.directConnectGatewayArn = directConnectGatewayArn;
        }

        @Override
        public final Builder directConnectGatewayArn(String directConnectGatewayArn) {
            this.directConnectGatewayArn = directConnectGatewayArn;
            return this;
        }

        public final Collection<String> getEdgeLocations() {
            if (edgeLocations instanceof SdkAutoConstructList) {
                return null;
            }
            return edgeLocations;
        }

        public final void setEdgeLocations(Collection<String> edgeLocations) {
            this.edgeLocations = ExternalRegionCodeListCopier.copy(edgeLocations);
        }

        @Override
        public final Builder edgeLocations(Collection<String> edgeLocations) {
            this.edgeLocations = ExternalRegionCodeListCopier.copy(edgeLocations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder edgeLocations(String... edgeLocations) {
            edgeLocations(Arrays.asList(edgeLocations));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDirectConnectGatewayAttachmentRequest build() {
            return new CreateDirectConnectGatewayAttachmentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
