/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteConnectPeerResponse extends NetworkManagerResponse implements
        ToCopyableBuilder<DeleteConnectPeerResponse.Builder, DeleteConnectPeerResponse> {
    private static final SdkField<ConnectPeer> CONNECT_PEER_FIELD = SdkField.<ConnectPeer> builder(MarshallingType.SDK_POJO)
            .memberName("ConnectPeer").getter(getter(DeleteConnectPeerResponse::connectPeer))
            .setter(setter(Builder::connectPeer)).constructor(ConnectPeer::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectPeer").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECT_PEER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ConnectPeer connectPeer;

    private DeleteConnectPeerResponse(BuilderImpl builder) {
        super(builder);
        this.connectPeer = builder.connectPeer;
    }

    /**
     * <p>
     * Information about the deleted Connect peer.
     * </p>
     * 
     * @return Information about the deleted Connect peer.
     */
    public final ConnectPeer connectPeer() {
        return connectPeer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(connectPeer());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteConnectPeerResponse)) {
            return false;
        }
        DeleteConnectPeerResponse other = (DeleteConnectPeerResponse) obj;
        return Objects.equals(connectPeer(), other.connectPeer());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteConnectPeerResponse").add("ConnectPeer", connectPeer()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectPeer":
            return Optional.ofNullable(clazz.cast(connectPeer()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConnectPeer", CONNECT_PEER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteConnectPeerResponse, T> g) {
        return obj -> g.apply((DeleteConnectPeerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NetworkManagerResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteConnectPeerResponse> {
        /**
         * <p>
         * Information about the deleted Connect peer.
         * </p>
         * 
         * @param connectPeer
         *        Information about the deleted Connect peer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectPeer(ConnectPeer connectPeer);

        /**
         * <p>
         * Information about the deleted Connect peer.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConnectPeer.Builder} avoiding the need to
         * create one manually via {@link ConnectPeer#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConnectPeer.Builder#build()} is called immediately and its result
         * is passed to {@link #connectPeer(ConnectPeer)}.
         * 
         * @param connectPeer
         *        a consumer that will call methods on {@link ConnectPeer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectPeer(ConnectPeer)
         */
        default Builder connectPeer(Consumer<ConnectPeer.Builder> connectPeer) {
            return connectPeer(ConnectPeer.builder().applyMutation(connectPeer).build());
        }
    }

    static final class BuilderImpl extends NetworkManagerResponse.BuilderImpl implements Builder {
        private ConnectPeer connectPeer;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteConnectPeerResponse model) {
            super(model);
            connectPeer(model.connectPeer);
        }

        public final ConnectPeer.Builder getConnectPeer() {
            return connectPeer != null ? connectPeer.toBuilder() : null;
        }

        public final void setConnectPeer(ConnectPeer.BuilderImpl connectPeer) {
            this.connectPeer = connectPeer != null ? connectPeer.build() : null;
        }

        @Override
        public final Builder connectPeer(ConnectPeer connectPeer) {
            this.connectPeer = connectPeer;
            return this;
        }

        @Override
        public DeleteConnectPeerResponse build() {
            return new DeleteConnectPeerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
