/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeletePeeringResponse extends NetworkManagerResponse implements
        ToCopyableBuilder<DeletePeeringResponse.Builder, DeletePeeringResponse> {
    private static final SdkField<Peering> PEERING_FIELD = SdkField.<Peering> builder(MarshallingType.SDK_POJO)
            .memberName("Peering").getter(getter(DeletePeeringResponse::peering)).setter(setter(Builder::peering))
            .constructor(Peering::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Peering").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PEERING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Peering peering;

    private DeletePeeringResponse(BuilderImpl builder) {
        super(builder);
        this.peering = builder.peering;
    }

    /**
     * <p>
     * Information about a deleted peering connection.
     * </p>
     * 
     * @return Information about a deleted peering connection.
     */
    public final Peering peering() {
        return peering;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(peering());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeletePeeringResponse)) {
            return false;
        }
        DeletePeeringResponse other = (DeletePeeringResponse) obj;
        return Objects.equals(peering(), other.peering());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeletePeeringResponse").add("Peering", peering()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Peering":
            return Optional.ofNullable(clazz.cast(peering()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Peering", PEERING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeletePeeringResponse, T> g) {
        return obj -> g.apply((DeletePeeringResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NetworkManagerResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeletePeeringResponse> {
        /**
         * <p>
         * Information about a deleted peering connection.
         * </p>
         * 
         * @param peering
         *        Information about a deleted peering connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peering(Peering peering);

        /**
         * <p>
         * Information about a deleted peering connection.
         * </p>
         * This is a convenience method that creates an instance of the {@link Peering.Builder} avoiding the need to
         * create one manually via {@link Peering#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Peering.Builder#build()} is called immediately and its result is
         * passed to {@link #peering(Peering)}.
         * 
         * @param peering
         *        a consumer that will call methods on {@link Peering.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #peering(Peering)
         */
        default Builder peering(Consumer<Peering.Builder> peering) {
            return peering(Peering.builder().applyMutation(peering).build());
        }
    }

    static final class BuilderImpl extends NetworkManagerResponse.BuilderImpl implements Builder {
        private Peering peering;

        private BuilderImpl() {
        }

        private BuilderImpl(DeletePeeringResponse model) {
            super(model);
            peering(model.peering);
        }

        public final Peering.Builder getPeering() {
            return peering != null ? peering.toBuilder() : null;
        }

        public final void setPeering(Peering.BuilderImpl peering) {
            this.peering = peering != null ? peering.build() : null;
        }

        @Override
        public final Builder peering(Peering peering) {
            this.peering = peering;
            return this;
        }

        @Override
        public DeletePeeringResponse build() {
            return new DeletePeeringResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
