/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the edge that's used for the override.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EdgeOverride implements SdkPojo, Serializable, ToCopyableBuilder<EdgeOverride.Builder, EdgeOverride> {
    private static final SdkField<List<List<String>>> EDGE_SETS_FIELD = SdkField
            .<List<List<String>>> builder(MarshallingType.LIST)
            .memberName("EdgeSets")
            .getter(getter(EdgeOverride::edgeSets))
            .setter(setter(Builder::edgeSets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeSets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> USE_EDGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UseEdge").getter(getter(EdgeOverride::useEdge)).setter(setter(Builder::useEdge))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseEdge").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EDGE_SETS_FIELD,
            USE_EDGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<List<String>> edgeSets;

    private final String useEdge;

    private EdgeOverride(BuilderImpl builder) {
        this.edgeSets = builder.edgeSets;
        this.useEdge = builder.useEdge;
    }

    /**
     * For responses, this returns true if the service returned a value for the EdgeSets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEdgeSets() {
        return edgeSets != null && !(edgeSets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of edge locations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEdgeSets} method.
     * </p>
     * 
     * @return The list of edge locations.
     */
    public final List<List<String>> edgeSets() {
        return edgeSets;
    }

    /**
     * <p>
     * The edge that should be used when overriding the current edge order.
     * </p>
     * 
     * @return The edge that should be used when overriding the current edge order.
     */
    public final String useEdge() {
        return useEdge;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasEdgeSets() ? edgeSets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(useEdge());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EdgeOverride)) {
            return false;
        }
        EdgeOverride other = (EdgeOverride) obj;
        return hasEdgeSets() == other.hasEdgeSets() && Objects.equals(edgeSets(), other.edgeSets())
                && Objects.equals(useEdge(), other.useEdge());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EdgeOverride").add("EdgeSets", hasEdgeSets() ? edgeSets() : null).add("UseEdge", useEdge())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EdgeSets":
            return Optional.ofNullable(clazz.cast(edgeSets()));
        case "UseEdge":
            return Optional.ofNullable(clazz.cast(useEdge()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EdgeSets", EDGE_SETS_FIELD);
        map.put("UseEdge", USE_EDGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EdgeOverride, T> g) {
        return obj -> g.apply((EdgeOverride) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EdgeOverride> {
        /**
         * <p>
         * The list of edge locations.
         * </p>
         * 
         * @param edgeSets
         *        The list of edge locations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edgeSets(Collection<? extends Collection<String>> edgeSets);

        /**
         * <p>
         * The list of edge locations.
         * </p>
         * 
         * @param edgeSets
         *        The list of edge locations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edgeSets(Collection<String>... edgeSets);

        /**
         * <p>
         * The edge that should be used when overriding the current edge order.
         * </p>
         * 
         * @param useEdge
         *        The edge that should be used when overriding the current edge order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useEdge(String useEdge);
    }

    static final class BuilderImpl implements Builder {
        private List<List<String>> edgeSets = DefaultSdkAutoConstructList.getInstance();

        private String useEdge;

        private BuilderImpl() {
        }

        private BuilderImpl(EdgeOverride model) {
            edgeSets(model.edgeSets);
            useEdge(model.useEdge);
        }

        public final Collection<? extends Collection<String>> getEdgeSets() {
            if (edgeSets instanceof SdkAutoConstructList) {
                return null;
            }
            return edgeSets;
        }

        public final void setEdgeSets(Collection<? extends Collection<String>> edgeSets) {
            this.edgeSets = EdgeSetListCopier.copy(edgeSets);
        }

        @Override
        public final Builder edgeSets(Collection<? extends Collection<String>> edgeSets) {
            this.edgeSets = EdgeSetListCopier.copy(edgeSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder edgeSets(Collection<String>... edgeSets) {
            edgeSets(Arrays.asList(edgeSets));
            return this;
        }

        public final String getUseEdge() {
            return useEdge;
        }

        public final void setUseEdge(String useEdge) {
            this.useEdge = useEdge;
        }

        @Override
        public final Builder useEdge(String useEdge) {
            this.useEdge = useEdge;
            return this;
        }

        @Override
        public EdgeOverride build() {
            return new EdgeOverride(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
