/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCoreNetworkPolicyVersionsResponse extends NetworkManagerResponse implements
        ToCopyableBuilder<ListCoreNetworkPolicyVersionsResponse.Builder, ListCoreNetworkPolicyVersionsResponse> {
    private static final SdkField<List<CoreNetworkPolicyVersion>> CORE_NETWORK_POLICY_VERSIONS_FIELD = SdkField
            .<List<CoreNetworkPolicyVersion>> builder(MarshallingType.LIST)
            .memberName("CoreNetworkPolicyVersions")
            .getter(getter(ListCoreNetworkPolicyVersionsResponse::coreNetworkPolicyVersions))
            .setter(setter(Builder::coreNetworkPolicyVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreNetworkPolicyVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CoreNetworkPolicyVersion> builder(MarshallingType.SDK_POJO)
                                            .constructor(CoreNetworkPolicyVersion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListCoreNetworkPolicyVersionsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CORE_NETWORK_POLICY_VERSIONS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<CoreNetworkPolicyVersion> coreNetworkPolicyVersions;

    private final String nextToken;

    private ListCoreNetworkPolicyVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.coreNetworkPolicyVersions = builder.coreNetworkPolicyVersions;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the CoreNetworkPolicyVersions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCoreNetworkPolicyVersions() {
        return coreNetworkPolicyVersions != null && !(coreNetworkPolicyVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Describes core network policy versions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCoreNetworkPolicyVersions} method.
     * </p>
     * 
     * @return Describes core network policy versions.
     */
    public final List<CoreNetworkPolicyVersion> coreNetworkPolicyVersions() {
        return coreNetworkPolicyVersions;
    }

    /**
     * <p>
     * The token for the next page of results.
     * </p>
     * 
     * @return The token for the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCoreNetworkPolicyVersions() ? coreNetworkPolicyVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCoreNetworkPolicyVersionsResponse)) {
            return false;
        }
        ListCoreNetworkPolicyVersionsResponse other = (ListCoreNetworkPolicyVersionsResponse) obj;
        return hasCoreNetworkPolicyVersions() == other.hasCoreNetworkPolicyVersions()
                && Objects.equals(coreNetworkPolicyVersions(), other.coreNetworkPolicyVersions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCoreNetworkPolicyVersionsResponse")
                .add("CoreNetworkPolicyVersions", hasCoreNetworkPolicyVersions() ? coreNetworkPolicyVersions() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CoreNetworkPolicyVersions":
            return Optional.ofNullable(clazz.cast(coreNetworkPolicyVersions()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CoreNetworkPolicyVersions", CORE_NETWORK_POLICY_VERSIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCoreNetworkPolicyVersionsResponse, T> g) {
        return obj -> g.apply((ListCoreNetworkPolicyVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NetworkManagerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListCoreNetworkPolicyVersionsResponse> {
        /**
         * <p>
         * Describes core network policy versions.
         * </p>
         * 
         * @param coreNetworkPolicyVersions
         *        Describes core network policy versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coreNetworkPolicyVersions(Collection<CoreNetworkPolicyVersion> coreNetworkPolicyVersions);

        /**
         * <p>
         * Describes core network policy versions.
         * </p>
         * 
         * @param coreNetworkPolicyVersions
         *        Describes core network policy versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coreNetworkPolicyVersions(CoreNetworkPolicyVersion... coreNetworkPolicyVersions);

        /**
         * <p>
         * Describes core network policy versions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkmanager.model.CoreNetworkPolicyVersion.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.networkmanager.model.CoreNetworkPolicyVersion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkmanager.model.CoreNetworkPolicyVersion.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #coreNetworkPolicyVersions(List<CoreNetworkPolicyVersion>)}.
         * 
         * @param coreNetworkPolicyVersions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkmanager.model.CoreNetworkPolicyVersion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #coreNetworkPolicyVersions(java.util.Collection<CoreNetworkPolicyVersion>)
         */
        Builder coreNetworkPolicyVersions(Consumer<CoreNetworkPolicyVersion.Builder>... coreNetworkPolicyVersions);

        /**
         * <p>
         * The token for the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends NetworkManagerResponse.BuilderImpl implements Builder {
        private List<CoreNetworkPolicyVersion> coreNetworkPolicyVersions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCoreNetworkPolicyVersionsResponse model) {
            super(model);
            coreNetworkPolicyVersions(model.coreNetworkPolicyVersions);
            nextToken(model.nextToken);
        }

        public final List<CoreNetworkPolicyVersion.Builder> getCoreNetworkPolicyVersions() {
            List<CoreNetworkPolicyVersion.Builder> result = CoreNetworkPolicyVersionListCopier
                    .copyToBuilder(this.coreNetworkPolicyVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCoreNetworkPolicyVersions(Collection<CoreNetworkPolicyVersion.BuilderImpl> coreNetworkPolicyVersions) {
            this.coreNetworkPolicyVersions = CoreNetworkPolicyVersionListCopier.copyFromBuilder(coreNetworkPolicyVersions);
        }

        @Override
        public final Builder coreNetworkPolicyVersions(Collection<CoreNetworkPolicyVersion> coreNetworkPolicyVersions) {
            this.coreNetworkPolicyVersions = CoreNetworkPolicyVersionListCopier.copy(coreNetworkPolicyVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder coreNetworkPolicyVersions(CoreNetworkPolicyVersion... coreNetworkPolicyVersions) {
            coreNetworkPolicyVersions(Arrays.asList(coreNetworkPolicyVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder coreNetworkPolicyVersions(Consumer<CoreNetworkPolicyVersion.Builder>... coreNetworkPolicyVersions) {
            coreNetworkPolicyVersions(Stream.of(coreNetworkPolicyVersions)
                    .map(c -> CoreNetworkPolicyVersion.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCoreNetworkPolicyVersionsResponse build() {
            return new ListCoreNetworkPolicyVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
