/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a path component.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PathComponent implements SdkPojo, Serializable, ToCopyableBuilder<PathComponent.Builder, PathComponent> {
    private static final SdkField<Integer> SEQUENCE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Sequence").getter(getter(PathComponent::sequence)).setter(setter(Builder::sequence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sequence").build()).build();

    private static final SdkField<NetworkResourceSummary> RESOURCE_FIELD = SdkField
            .<NetworkResourceSummary> builder(MarshallingType.SDK_POJO).memberName("Resource")
            .getter(getter(PathComponent::resource)).setter(setter(Builder::resource))
            .constructor(NetworkResourceSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resource").build()).build();

    private static final SdkField<String> DESTINATION_CIDR_BLOCK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationCidrBlock").getter(getter(PathComponent::destinationCidrBlock))
            .setter(setter(Builder::destinationCidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationCidrBlock").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEQUENCE_FIELD,
            RESOURCE_FIELD, DESTINATION_CIDR_BLOCK_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer sequence;

    private final NetworkResourceSummary resource;

    private final String destinationCidrBlock;

    private PathComponent(BuilderImpl builder) {
        this.sequence = builder.sequence;
        this.resource = builder.resource;
        this.destinationCidrBlock = builder.destinationCidrBlock;
    }

    /**
     * <p>
     * The sequence number in the path. The destination is 0.
     * </p>
     * 
     * @return The sequence number in the path. The destination is 0.
     */
    public final Integer sequence() {
        return sequence;
    }

    /**
     * <p>
     * The resource.
     * </p>
     * 
     * @return The resource.
     */
    public final NetworkResourceSummary resource() {
        return resource;
    }

    /**
     * <p>
     * The destination CIDR block in the route table.
     * </p>
     * 
     * @return The destination CIDR block in the route table.
     */
    public final String destinationCidrBlock() {
        return destinationCidrBlock;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sequence());
        hashCode = 31 * hashCode + Objects.hashCode(resource());
        hashCode = 31 * hashCode + Objects.hashCode(destinationCidrBlock());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PathComponent)) {
            return false;
        }
        PathComponent other = (PathComponent) obj;
        return Objects.equals(sequence(), other.sequence()) && Objects.equals(resource(), other.resource())
                && Objects.equals(destinationCidrBlock(), other.destinationCidrBlock());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PathComponent").add("Sequence", sequence()).add("Resource", resource())
                .add("DestinationCidrBlock", destinationCidrBlock()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Sequence":
            return Optional.ofNullable(clazz.cast(sequence()));
        case "Resource":
            return Optional.ofNullable(clazz.cast(resource()));
        case "DestinationCidrBlock":
            return Optional.ofNullable(clazz.cast(destinationCidrBlock()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Sequence", SEQUENCE_FIELD);
        map.put("Resource", RESOURCE_FIELD);
        map.put("DestinationCidrBlock", DESTINATION_CIDR_BLOCK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PathComponent, T> g) {
        return obj -> g.apply((PathComponent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PathComponent> {
        /**
         * <p>
         * The sequence number in the path. The destination is 0.
         * </p>
         * 
         * @param sequence
         *        The sequence number in the path. The destination is 0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sequence(Integer sequence);

        /**
         * <p>
         * The resource.
         * </p>
         * 
         * @param resource
         *        The resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(NetworkResourceSummary resource);

        /**
         * <p>
         * The resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link NetworkResourceSummary.Builder} avoiding
         * the need to create one manually via {@link NetworkResourceSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NetworkResourceSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #resource(NetworkResourceSummary)}.
         * 
         * @param resource
         *        a consumer that will call methods on {@link NetworkResourceSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resource(NetworkResourceSummary)
         */
        default Builder resource(Consumer<NetworkResourceSummary.Builder> resource) {
            return resource(NetworkResourceSummary.builder().applyMutation(resource).build());
        }

        /**
         * <p>
         * The destination CIDR block in the route table.
         * </p>
         * 
         * @param destinationCidrBlock
         *        The destination CIDR block in the route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationCidrBlock(String destinationCidrBlock);
    }

    static final class BuilderImpl implements Builder {
        private Integer sequence;

        private NetworkResourceSummary resource;

        private String destinationCidrBlock;

        private BuilderImpl() {
        }

        private BuilderImpl(PathComponent model) {
            sequence(model.sequence);
            resource(model.resource);
            destinationCidrBlock(model.destinationCidrBlock);
        }

        public final Integer getSequence() {
            return sequence;
        }

        public final void setSequence(Integer sequence) {
            this.sequence = sequence;
        }

        @Override
        public final Builder sequence(Integer sequence) {
            this.sequence = sequence;
            return this;
        }

        public final NetworkResourceSummary.Builder getResource() {
            return resource != null ? resource.toBuilder() : null;
        }

        public final void setResource(NetworkResourceSummary.BuilderImpl resource) {
            this.resource = resource != null ? resource.build() : null;
        }

        @Override
        public final Builder resource(NetworkResourceSummary resource) {
            this.resource = resource;
            return this;
        }

        public final String getDestinationCidrBlock() {
            return destinationCidrBlock;
        }

        public final void setDestinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
        }

        @Override
        public final Builder destinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        @Override
        public PathComponent build() {
            return new PathComponent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
