/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a peering connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Peering implements SdkPojo, Serializable, ToCopyableBuilder<Peering.Builder, Peering> {
    private static final SdkField<String> CORE_NETWORK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CoreNetworkId").getter(getter(Peering::coreNetworkId)).setter(setter(Builder::coreNetworkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreNetworkId").build()).build();

    private static final SdkField<String> CORE_NETWORK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CoreNetworkArn").getter(getter(Peering::coreNetworkArn)).setter(setter(Builder::coreNetworkArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreNetworkArn").build()).build();

    private static final SdkField<String> PEERING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PeeringId").getter(getter(Peering::peeringId)).setter(setter(Builder::peeringId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeeringId").build()).build();

    private static final SdkField<String> OWNER_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OwnerAccountId").getter(getter(Peering::ownerAccountId)).setter(setter(Builder::ownerAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAccountId").build()).build();

    private static final SdkField<String> PEERING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PeeringType").getter(getter(Peering::peeringTypeAsString)).setter(setter(Builder::peeringType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeeringType").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(Peering::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> EDGE_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EdgeLocation").getter(getter(Peering::edgeLocation)).setter(setter(Builder::edgeLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeLocation").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(Peering::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(Peering::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(Peering::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<List<PeeringError>> LAST_MODIFICATION_ERRORS_FIELD = SdkField
            .<List<PeeringError>> builder(MarshallingType.LIST)
            .memberName("LastModificationErrors")
            .getter(getter(Peering::lastModificationErrors))
            .setter(setter(Builder::lastModificationErrors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModificationErrors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PeeringError> builder(MarshallingType.SDK_POJO)
                                            .constructor(PeeringError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CORE_NETWORK_ID_FIELD,
            CORE_NETWORK_ARN_FIELD, PEERING_ID_FIELD, OWNER_ACCOUNT_ID_FIELD, PEERING_TYPE_FIELD, STATE_FIELD,
            EDGE_LOCATION_FIELD, RESOURCE_ARN_FIELD, TAGS_FIELD, CREATED_AT_FIELD, LAST_MODIFICATION_ERRORS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String coreNetworkId;

    private final String coreNetworkArn;

    private final String peeringId;

    private final String ownerAccountId;

    private final String peeringType;

    private final String state;

    private final String edgeLocation;

    private final String resourceArn;

    private final List<Tag> tags;

    private final Instant createdAt;

    private final List<PeeringError> lastModificationErrors;

    private Peering(BuilderImpl builder) {
        this.coreNetworkId = builder.coreNetworkId;
        this.coreNetworkArn = builder.coreNetworkArn;
        this.peeringId = builder.peeringId;
        this.ownerAccountId = builder.ownerAccountId;
        this.peeringType = builder.peeringType;
        this.state = builder.state;
        this.edgeLocation = builder.edgeLocation;
        this.resourceArn = builder.resourceArn;
        this.tags = builder.tags;
        this.createdAt = builder.createdAt;
        this.lastModificationErrors = builder.lastModificationErrors;
    }

    /**
     * <p>
     * The ID of the core network for the peering request.
     * </p>
     * 
     * @return The ID of the core network for the peering request.
     */
    public final String coreNetworkId() {
        return coreNetworkId;
    }

    /**
     * <p>
     * The ARN of a core network.
     * </p>
     * 
     * @return The ARN of a core network.
     */
    public final String coreNetworkArn() {
        return coreNetworkArn;
    }

    /**
     * <p>
     * The ID of the peering attachment.
     * </p>
     * 
     * @return The ID of the peering attachment.
     */
    public final String peeringId() {
        return peeringId;
    }

    /**
     * <p>
     * The ID of the account owner.
     * </p>
     * 
     * @return The ID of the account owner.
     */
    public final String ownerAccountId() {
        return ownerAccountId;
    }

    /**
     * <p>
     * The type of peering. This will be <code>TRANSIT_GATEWAY</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #peeringType} will
     * return {@link PeeringType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #peeringTypeAsString}.
     * </p>
     * 
     * @return The type of peering. This will be <code>TRANSIT_GATEWAY</code>.
     * @see PeeringType
     */
    public final PeeringType peeringType() {
        return PeeringType.fromValue(peeringType);
    }

    /**
     * <p>
     * The type of peering. This will be <code>TRANSIT_GATEWAY</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #peeringType} will
     * return {@link PeeringType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #peeringTypeAsString}.
     * </p>
     * 
     * @return The type of peering. This will be <code>TRANSIT_GATEWAY</code>.
     * @see PeeringType
     */
    public final String peeringTypeAsString() {
        return peeringType;
    }

    /**
     * <p>
     * The current state of the peering connection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link PeeringState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the peering connection.
     * @see PeeringState
     */
    public final PeeringState state() {
        return PeeringState.fromValue(state);
    }

    /**
     * <p>
     * The current state of the peering connection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link PeeringState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the peering connection.
     * @see PeeringState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The edge location for the peer.
     * </p>
     * 
     * @return The edge location for the peer.
     */
    public final String edgeLocation() {
        return edgeLocation;
    }

    /**
     * <p>
     * The resource ARN of the peer.
     * </p>
     * 
     * @return The resource ARN of the peer.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of key-value tags associated with the peering.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The list of key-value tags associated with the peering.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The timestamp when the attachment peer was created.
     * </p>
     * 
     * @return The timestamp when the attachment peer was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the LastModificationErrors property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLastModificationErrors() {
        return lastModificationErrors != null && !(lastModificationErrors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Describes the error associated with the Connect peer request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLastModificationErrors} method.
     * </p>
     * 
     * @return Describes the error associated with the Connect peer request.
     */
    public final List<PeeringError> lastModificationErrors() {
        return lastModificationErrors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(coreNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(coreNetworkArn());
        hashCode = 31 * hashCode + Objects.hashCode(peeringId());
        hashCode = 31 * hashCode + Objects.hashCode(ownerAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(peeringTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(edgeLocation());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasLastModificationErrors() ? lastModificationErrors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Peering)) {
            return false;
        }
        Peering other = (Peering) obj;
        return Objects.equals(coreNetworkId(), other.coreNetworkId()) && Objects.equals(coreNetworkArn(), other.coreNetworkArn())
                && Objects.equals(peeringId(), other.peeringId()) && Objects.equals(ownerAccountId(), other.ownerAccountId())
                && Objects.equals(peeringTypeAsString(), other.peeringTypeAsString())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(edgeLocation(), other.edgeLocation())
                && Objects.equals(resourceArn(), other.resourceArn()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(createdAt(), other.createdAt())
                && hasLastModificationErrors() == other.hasLastModificationErrors()
                && Objects.equals(lastModificationErrors(), other.lastModificationErrors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Peering").add("CoreNetworkId", coreNetworkId()).add("CoreNetworkArn", coreNetworkArn())
                .add("PeeringId", peeringId()).add("OwnerAccountId", ownerAccountId()).add("PeeringType", peeringTypeAsString())
                .add("State", stateAsString()).add("EdgeLocation", edgeLocation()).add("ResourceArn", resourceArn())
                .add("Tags", hasTags() ? tags() : null).add("CreatedAt", createdAt())
                .add("LastModificationErrors", hasLastModificationErrors() ? lastModificationErrors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CoreNetworkId":
            return Optional.ofNullable(clazz.cast(coreNetworkId()));
        case "CoreNetworkArn":
            return Optional.ofNullable(clazz.cast(coreNetworkArn()));
        case "PeeringId":
            return Optional.ofNullable(clazz.cast(peeringId()));
        case "OwnerAccountId":
            return Optional.ofNullable(clazz.cast(ownerAccountId()));
        case "PeeringType":
            return Optional.ofNullable(clazz.cast(peeringTypeAsString()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "EdgeLocation":
            return Optional.ofNullable(clazz.cast(edgeLocation()));
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "LastModificationErrors":
            return Optional.ofNullable(clazz.cast(lastModificationErrors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CoreNetworkId", CORE_NETWORK_ID_FIELD);
        map.put("CoreNetworkArn", CORE_NETWORK_ARN_FIELD);
        map.put("PeeringId", PEERING_ID_FIELD);
        map.put("OwnerAccountId", OWNER_ACCOUNT_ID_FIELD);
        map.put("PeeringType", PEERING_TYPE_FIELD);
        map.put("State", STATE_FIELD);
        map.put("EdgeLocation", EDGE_LOCATION_FIELD);
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("LastModificationErrors", LAST_MODIFICATION_ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Peering, T> g) {
        return obj -> g.apply((Peering) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Peering> {
        /**
         * <p>
         * The ID of the core network for the peering request.
         * </p>
         * 
         * @param coreNetworkId
         *        The ID of the core network for the peering request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coreNetworkId(String coreNetworkId);

        /**
         * <p>
         * The ARN of a core network.
         * </p>
         * 
         * @param coreNetworkArn
         *        The ARN of a core network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coreNetworkArn(String coreNetworkArn);

        /**
         * <p>
         * The ID of the peering attachment.
         * </p>
         * 
         * @param peeringId
         *        The ID of the peering attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peeringId(String peeringId);

        /**
         * <p>
         * The ID of the account owner.
         * </p>
         * 
         * @param ownerAccountId
         *        The ID of the account owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerAccountId(String ownerAccountId);

        /**
         * <p>
         * The type of peering. This will be <code>TRANSIT_GATEWAY</code>.
         * </p>
         * 
         * @param peeringType
         *        The type of peering. This will be <code>TRANSIT_GATEWAY</code>.
         * @see PeeringType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PeeringType
         */
        Builder peeringType(String peeringType);

        /**
         * <p>
         * The type of peering. This will be <code>TRANSIT_GATEWAY</code>.
         * </p>
         * 
         * @param peeringType
         *        The type of peering. This will be <code>TRANSIT_GATEWAY</code>.
         * @see PeeringType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PeeringType
         */
        Builder peeringType(PeeringType peeringType);

        /**
         * <p>
         * The current state of the peering connection.
         * </p>
         * 
         * @param state
         *        The current state of the peering connection.
         * @see PeeringState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PeeringState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of the peering connection.
         * </p>
         * 
         * @param state
         *        The current state of the peering connection.
         * @see PeeringState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PeeringState
         */
        Builder state(PeeringState state);

        /**
         * <p>
         * The edge location for the peer.
         * </p>
         * 
         * @param edgeLocation
         *        The edge location for the peer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edgeLocation(String edgeLocation);

        /**
         * <p>
         * The resource ARN of the peer.
         * </p>
         * 
         * @param resourceArn
         *        The resource ARN of the peer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The list of key-value tags associated with the peering.
         * </p>
         * 
         * @param tags
         *        The list of key-value tags associated with the peering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The list of key-value tags associated with the peering.
         * </p>
         * 
         * @param tags
         *        The list of key-value tags associated with the peering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The list of key-value tags associated with the peering.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkmanager.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.networkmanager.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkmanager.model.Tag.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkmanager.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The timestamp when the attachment peer was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the attachment peer was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * Describes the error associated with the Connect peer request.
         * </p>
         * 
         * @param lastModificationErrors
         *        Describes the error associated with the Connect peer request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModificationErrors(Collection<PeeringError> lastModificationErrors);

        /**
         * <p>
         * Describes the error associated with the Connect peer request.
         * </p>
         * 
         * @param lastModificationErrors
         *        Describes the error associated with the Connect peer request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModificationErrors(PeeringError... lastModificationErrors);

        /**
         * <p>
         * Describes the error associated with the Connect peer request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkmanager.model.PeeringError.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.networkmanager.model.PeeringError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkmanager.model.PeeringError.Builder#build()} is called
         * immediately and its result is passed to {@link #lastModificationErrors(List<PeeringError>)}.
         * 
         * @param lastModificationErrors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkmanager.model.PeeringError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastModificationErrors(java.util.Collection<PeeringError>)
         */
        Builder lastModificationErrors(Consumer<PeeringError.Builder>... lastModificationErrors);
    }

    static final class BuilderImpl implements Builder {
        private String coreNetworkId;

        private String coreNetworkArn;

        private String peeringId;

        private String ownerAccountId;

        private String peeringType;

        private String state;

        private String edgeLocation;

        private String resourceArn;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private Instant createdAt;

        private List<PeeringError> lastModificationErrors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Peering model) {
            coreNetworkId(model.coreNetworkId);
            coreNetworkArn(model.coreNetworkArn);
            peeringId(model.peeringId);
            ownerAccountId(model.ownerAccountId);
            peeringType(model.peeringType);
            state(model.state);
            edgeLocation(model.edgeLocation);
            resourceArn(model.resourceArn);
            tags(model.tags);
            createdAt(model.createdAt);
            lastModificationErrors(model.lastModificationErrors);
        }

        public final String getCoreNetworkId() {
            return coreNetworkId;
        }

        public final void setCoreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
        }

        @Override
        public final Builder coreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
            return this;
        }

        public final String getCoreNetworkArn() {
            return coreNetworkArn;
        }

        public final void setCoreNetworkArn(String coreNetworkArn) {
            this.coreNetworkArn = coreNetworkArn;
        }

        @Override
        public final Builder coreNetworkArn(String coreNetworkArn) {
            this.coreNetworkArn = coreNetworkArn;
            return this;
        }

        public final String getPeeringId() {
            return peeringId;
        }

        public final void setPeeringId(String peeringId) {
            this.peeringId = peeringId;
        }

        @Override
        public final Builder peeringId(String peeringId) {
            this.peeringId = peeringId;
            return this;
        }

        public final String getOwnerAccountId() {
            return ownerAccountId;
        }

        public final void setOwnerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
        }

        @Override
        public final Builder ownerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
            return this;
        }

        public final String getPeeringType() {
            return peeringType;
        }

        public final void setPeeringType(String peeringType) {
            this.peeringType = peeringType;
        }

        @Override
        public final Builder peeringType(String peeringType) {
            this.peeringType = peeringType;
            return this;
        }

        @Override
        public final Builder peeringType(PeeringType peeringType) {
            this.peeringType(peeringType == null ? null : peeringType.toString());
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(PeeringState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getEdgeLocation() {
            return edgeLocation;
        }

        public final void setEdgeLocation(String edgeLocation) {
            this.edgeLocation = edgeLocation;
        }

        @Override
        public final Builder edgeLocation(String edgeLocation) {
            this.edgeLocation = edgeLocation;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final List<PeeringError.Builder> getLastModificationErrors() {
            List<PeeringError.Builder> result = PeeringErrorListCopier.copyToBuilder(this.lastModificationErrors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLastModificationErrors(Collection<PeeringError.BuilderImpl> lastModificationErrors) {
            this.lastModificationErrors = PeeringErrorListCopier.copyFromBuilder(lastModificationErrors);
        }

        @Override
        public final Builder lastModificationErrors(Collection<PeeringError> lastModificationErrors) {
            this.lastModificationErrors = PeeringErrorListCopier.copy(lastModificationErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lastModificationErrors(PeeringError... lastModificationErrors) {
            lastModificationErrors(Arrays.asList(lastModificationErrors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lastModificationErrors(Consumer<PeeringError.Builder>... lastModificationErrors) {
            lastModificationErrors(Stream.of(lastModificationErrors).map(c -> PeeringError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Peering build() {
            return new Peering(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
