/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an error associated with a peering request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PeeringError implements SdkPojo, Serializable, ToCopyableBuilder<PeeringError.Builder, PeeringError> {
    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Code")
            .getter(getter(PeeringError::codeAsString)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(PeeringError::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(PeeringError::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(PeeringError::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final SdkField<PermissionsErrorContext> MISSING_PERMISSIONS_CONTEXT_FIELD = SdkField
            .<PermissionsErrorContext> builder(MarshallingType.SDK_POJO).memberName("MissingPermissionsContext")
            .getter(getter(PeeringError::missingPermissionsContext)).setter(setter(Builder::missingPermissionsContext))
            .constructor(PermissionsErrorContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MissingPermissionsContext").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_FIELD, MESSAGE_FIELD,
            RESOURCE_ARN_FIELD, REQUEST_ID_FIELD, MISSING_PERMISSIONS_CONTEXT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String code;

    private final String message;

    private final String resourceArn;

    private final String requestId;

    private final PermissionsErrorContext missingPermissionsContext;

    private PeeringError(BuilderImpl builder) {
        this.code = builder.code;
        this.message = builder.message;
        this.resourceArn = builder.resourceArn;
        this.requestId = builder.requestId;
        this.missingPermissionsContext = builder.missingPermissionsContext;
    }

    /**
     * <p>
     * The error code for the peering request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link PeeringErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codeAsString}.
     * </p>
     * 
     * @return The error code for the peering request.
     * @see PeeringErrorCode
     */
    public final PeeringErrorCode code() {
        return PeeringErrorCode.fromValue(code);
    }

    /**
     * <p>
     * The error code for the peering request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link PeeringErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codeAsString}.
     * </p>
     * 
     * @return The error code for the peering request.
     * @see PeeringErrorCode
     */
    public final String codeAsString() {
        return code;
    }

    /**
     * <p>
     * The message associated with the error <code>code</code>.
     * </p>
     * 
     * @return The message associated with the error <code>code</code>.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The ARN of the requested peering resource.
     * </p>
     * 
     * @return The ARN of the requested peering resource.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The ID of the Peering request.
     * </p>
     * 
     * @return The ID of the Peering request.
     */
    public final String requestId() {
        return requestId;
    }

    /**
     * <p>
     * Provides additional information about missing permissions for the peering error.
     * </p>
     * 
     * @return Provides additional information about missing permissions for the peering error.
     */
    public final PermissionsErrorContext missingPermissionsContext() {
        return missingPermissionsContext;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(codeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(missingPermissionsContext());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PeeringError)) {
            return false;
        }
        PeeringError other = (PeeringError) obj;
        return Objects.equals(codeAsString(), other.codeAsString()) && Objects.equals(message(), other.message())
                && Objects.equals(resourceArn(), other.resourceArn()) && Objects.equals(requestId(), other.requestId())
                && Objects.equals(missingPermissionsContext(), other.missingPermissionsContext());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PeeringError").add("Code", codeAsString()).add("Message", message())
                .add("ResourceArn", resourceArn()).add("RequestId", requestId())
                .add("MissingPermissionsContext", missingPermissionsContext()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Code":
            return Optional.ofNullable(clazz.cast(codeAsString()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "MissingPermissionsContext":
            return Optional.ofNullable(clazz.cast(missingPermissionsContext()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Code", CODE_FIELD);
        map.put("Message", MESSAGE_FIELD);
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("RequestId", REQUEST_ID_FIELD);
        map.put("MissingPermissionsContext", MISSING_PERMISSIONS_CONTEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PeeringError, T> g) {
        return obj -> g.apply((PeeringError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PeeringError> {
        /**
         * <p>
         * The error code for the peering request.
         * </p>
         * 
         * @param code
         *        The error code for the peering request.
         * @see PeeringErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PeeringErrorCode
         */
        Builder code(String code);

        /**
         * <p>
         * The error code for the peering request.
         * </p>
         * 
         * @param code
         *        The error code for the peering request.
         * @see PeeringErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PeeringErrorCode
         */
        Builder code(PeeringErrorCode code);

        /**
         * <p>
         * The message associated with the error <code>code</code>.
         * </p>
         * 
         * @param message
         *        The message associated with the error <code>code</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The ARN of the requested peering resource.
         * </p>
         * 
         * @param resourceArn
         *        The ARN of the requested peering resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The ID of the Peering request.
         * </p>
         * 
         * @param requestId
         *        The ID of the Peering request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * <p>
         * Provides additional information about missing permissions for the peering error.
         * </p>
         * 
         * @param missingPermissionsContext
         *        Provides additional information about missing permissions for the peering error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder missingPermissionsContext(PermissionsErrorContext missingPermissionsContext);

        /**
         * <p>
         * Provides additional information about missing permissions for the peering error.
         * </p>
         * This is a convenience method that creates an instance of the {@link PermissionsErrorContext.Builder} avoiding
         * the need to create one manually via {@link PermissionsErrorContext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PermissionsErrorContext.Builder#build()} is called immediately
         * and its result is passed to {@link #missingPermissionsContext(PermissionsErrorContext)}.
         * 
         * @param missingPermissionsContext
         *        a consumer that will call methods on {@link PermissionsErrorContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #missingPermissionsContext(PermissionsErrorContext)
         */
        default Builder missingPermissionsContext(Consumer<PermissionsErrorContext.Builder> missingPermissionsContext) {
            return missingPermissionsContext(PermissionsErrorContext.builder().applyMutation(missingPermissionsContext).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String code;

        private String message;

        private String resourceArn;

        private String requestId;

        private PermissionsErrorContext missingPermissionsContext;

        private BuilderImpl() {
        }

        private BuilderImpl(PeeringError model) {
            code(model.code);
            message(model.message);
            resourceArn(model.resourceArn);
            requestId(model.requestId);
            missingPermissionsContext(model.missingPermissionsContext);
        }

        public final String getCode() {
            return code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        @Override
        public final Builder code(PeeringErrorCode code) {
            this.code(code == null ? null : code.toString());
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final PermissionsErrorContext.Builder getMissingPermissionsContext() {
            return missingPermissionsContext != null ? missingPermissionsContext.toBuilder() : null;
        }

        public final void setMissingPermissionsContext(PermissionsErrorContext.BuilderImpl missingPermissionsContext) {
            this.missingPermissionsContext = missingPermissionsContext != null ? missingPermissionsContext.build() : null;
        }

        @Override
        public final Builder missingPermissionsContext(PermissionsErrorContext missingPermissionsContext) {
            this.missingPermissionsContext = missingPermissionsContext;
            return this;
        }

        @Override
        public PeeringError build() {
            return new PeeringError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
